/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.MavenPomEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLEditorUtility {
    private static final Logger log = LoggerFactory.getLogger(XMLEditorUtility.class);

    public static void openXmlEditor(IFileStore fileStore) {
        XMLEditorUtility.openXmlEditor(fileStore, -1, -1, fileStore.getName());
    }

    public static void openXmlEditor(IFileStore fileStore, int line, int column, String name) {
        IWorkbenchPage page;
        assert (fileStore != null);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                IEditorPart part = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                XMLEditorUtility.reveal(XMLEditorUtility.selectEditorPage(part), line, column);
            }
            catch (PartInitException e) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PomHyperlinkDetector_error_title, (String)NLS.bind((String)Messages.PomHyperlinkDetector_error_message, (Object)fileStore, (Object)e.toString()));
            }
        }
    }

    private static ITextEditor selectEditorPage(IEditorPart part) {
        if (part == null) {
            return null;
        }
        if (part instanceof FormEditor) {
            FormEditor ed = (FormEditor)part;
            ed.setActivePage(null);
            if (ed instanceof MavenPomEditor) {
                return ((MavenPomEditor)ed).getSourcePage();
            }
        }
        return null;
    }

    private static void reveal(ITextEditor editor, int line, int column) {
        if (editor == null || line < 0 || column < 0) {
            return;
        }
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        try {
            int offset = doc.getLineOffset(line - 1);
            editor.selectAndReveal(offset + column - 1, 0);
        }
        catch (BadLocationException e) {
            log.error("failed selecting part of editor", (Throwable)e);
        }
    }
}

