/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenConsoleLineTracker
implements IConsoleLineTracker {
    private static final Logger log = LoggerFactory.getLogger(MavenConsoleLineTracker.class);
    private static final String PLUGIN_ID = "org.eclipse.m2e.launching";
    private static final String IDENTIFIER = "([\\w\\.\\-]+)";
    private static final Pattern LISTENING_MARKER = Pattern.compile("Listening for transport dt_socket at address: (\\d+)$");
    private static final int DEBUGGER_PORT = 1;
    private static final Pattern RUNNING_TEST_CLASS = Pattern.compile("Running ([\\w\\.]+)$");
    private static final int TEST_CLASS_NAME = 1;
    private static final Pattern EXECUTION_FAILURE = Pattern.compile("^\\[ERROR\\] Failed to execute goal .+ on project ([\\w\\.\\-]+)");
    private static final int FAILED_ARTIFACT_ID = 1;
    private boolean isMavenBuildProcess;
    private IConsole console;
    private boolean initialized = false;
    private IMavenProjectFacade mavenProject;
    private final Deque<IRegion> projectDefinitionLines = new ArrayDeque<IRegion>(2);
    private static final Pattern GROUP_ARTIFACT_LINE = Pattern.compile("^\\[INFO\\] -+< ([\\w\\.\\-]+):([\\w\\.\\-]+) >-+$");
    private static final int GROUP_ID = 1;
    private static final int ARTIFACT_ID = 2;
    private static final Pattern VERSION_LINE = Pattern.compile("^\\[INFO\\] Building .+ ([\\w\\.\\-]+)( +\\[\\d+/\\d+\\])?$");
    private static final int VERSION = 1;
    private static final Pattern PACKAGING_TYPE_LINE = Pattern.compile("^\\[INFO\\] -+\\[ [\\w\\-\\. ]+ \\]-+$");

    public void init(IConsole console) {
        if (this.initialized) {
            throw new IllegalStateException("MavenConsoleLineTracker already connected to console");
        }
        this.console = console;
        ILaunchConfiguration launchConfiguration = console.getProcess().getLaunch().getLaunchConfiguration();
        this.isMavenBuildProcess = launchConfiguration != null && this.isMavenProcess(launchConfiguration);
        this.initialized = true;
    }

    public void lineAppended(IRegion line) {
        if (this.isMavenBuildProcess) {
            try {
                String text = this.getText(line);
                if (this.mavenProject == null) {
                    return;
                }
                Matcher runningTestMatcher = RUNNING_TEST_CLASS.matcher(text);
                if (runningTestMatcher.find()) {
                    String testName = runningTestMatcher.group(1);
                    int start = runningTestMatcher.start(1);
                    MavenTestReportHyperLink link = new MavenTestReportHyperLink(this.mavenProject, testName);
                    this.console.addLink((IHyperlink)link, line.getOffset() + start, testName.length());
                    return;
                }
                Matcher listeningMatcher = LISTENING_MARKER.matcher(text);
                if (listeningMatcher.find()) {
                    String portString = listeningMatcher.group(1);
                    MavenConsoleLineTracker.launchRemoteJavaApp(this.mavenProject.getProject(), portString);
                    return;
                }
                Matcher failureMatcher = EXECUTION_FAILURE.matcher(text);
                if (failureMatcher.find()) {
                    this.addProjectLink(line, failureMatcher, 1, 1);
                }
            }
            catch (BadLocationException text) {
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private boolean isMavenProcess(ILaunchConfiguration launchConfiguration) {
        try {
            ILaunchConfigurationType type = launchConfiguration.getType();
            return PLUGIN_ID.equals(type.getPluginIdentifier());
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private String getText(IRegion lineRegion) throws BadLocationException {
        Iterator<IRegion> previousLines;
        IRegion line1Region;
        String line1;
        Matcher vMatcher;
        String line0 = this.getLineText(lineRegion);
        if (this.projectDefinitionLines.size() < 2) {
            this.projectDefinitionLines.add(lineRegion);
            return line0;
        }
        if (PACKAGING_TYPE_LINE.matcher(line0).matches() && (vMatcher = VERSION_LINE.matcher(line1 = this.getLineText(line1Region = (previousLines = this.projectDefinitionLines.descendingIterator()).next()))).matches()) {
            String version = vMatcher.group(1);
            IRegion line2Region = previousLines.next();
            String line2 = this.getLineText(line2Region);
            Matcher gaMatcher = GROUP_ARTIFACT_LINE.matcher(line2);
            if (gaMatcher.matches()) {
                String groupId = gaMatcher.group(1);
                String artifactId = gaMatcher.group(2);
                IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
                this.mavenProject = projectManager.getMavenProject(groupId, artifactId, version);
                this.addProjectLink(line2Region, gaMatcher, 1, 2);
            }
        }
        this.projectDefinitionLines.remove();
        this.projectDefinitionLines.add(lineRegion);
        return line0;
    }

    private String getLineText(IRegion lineRegion) throws BadLocationException {
        return this.console.getDocument().get(lineRegion.getOffset(), lineRegion.getLength()).strip();
    }

    private void addProjectLink(IRegion line, Matcher matcher, int startGroup, int endGroup) {
        MavenProjectHyperLink link = new MavenProjectHyperLink(this.mavenProject);
        int start = matcher.start(startGroup);
        int end = matcher.end(endGroup);
        this.console.addLink((IHyperlink)link, line.getOffset() + start, end - start);
    }

    public void dispose() {
        this.isMavenBuildProcess = false;
        this.projectDefinitionLines.clear();
        this.mavenProject = null;
        this.initialized = false;
    }

    private static void launchRemoteJavaApp(IProject project, String portString) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, "Connecting debugger to port " + portString);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, IJavaLaunchConfigurationConstants.ID_SOCKET_ATTACH_VM_CONNECTOR);
        HashMap<String, String> connectMap = new HashMap<String, String>();
        connectMap.put("port", portString);
        connectMap.put("hostname", "localhost");
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, connectMap);
        if (project != null && project.exists()) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        }
        DebugUITools.launch((ILaunchConfiguration)workingCopy, (String)"debug");
    }

    private static void openFileInStandardEditor(IFile file) {
        try {
            file.refreshLocal(0, null);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private static class MavenProjectHyperLink
    implements IHyperlink {
        private final IMavenProjectFacade mavenProjectFacade;

        public MavenProjectHyperLink(IMavenProjectFacade mavenProjectFacade) {
            this.mavenProjectFacade = mavenProjectFacade;
        }

        public void linkActivated() {
            IFile pom = this.mavenProjectFacade.getPom();
            MavenConsoleLineTracker.openFileInStandardEditor(pom);
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }

    private static class MavenTestReportHyperLink
    implements IHyperlink {
        private final String testName;
        private final IMavenProjectFacade mavenProjectFacade;

        public MavenTestReportHyperLink(IMavenProjectFacade mavenProjectFacade, String testName) {
            this.testName = testName;
            this.mavenProjectFacade = mavenProjectFacade;
        }

        public void linkActivated() {
            MavenProject mavenProject = this.mavenProjectFacade.getMavenProject();
            if (mavenProject == null) {
                return;
            }
            Path baseDir = Path.of(mavenProject.getBuild().getDirectory(), new String[0]);
            List<Path> reportFiles = MavenTestReportHyperLink.getTestReportFiles(baseDir, this.testName);
            if (!reportFiles.isEmpty()) {
                IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                for (Path reportFile : reportFiles) {
                    IFile[] files = wsRoot.findFilesForLocationURI(reportFile.toUri());
                    if (files.length <= 0) continue;
                    MavenConsoleLineTracker.openFileInStandardEditor(files[0]);
                }
            }
        }

        private static List<Path> getTestReportFiles(Path baseDir, String testName) {
            ArrayList<Path> jUnitXMLFiles = new ArrayList<Path>();
            ArrayList plainTextFiles = new ArrayList();
            Path jUnitReportFile = Path.of("TEST-" + testName + ".xml", new String[0]);
            Path plainTextSummaryFile = Path.of(String.valueOf(testName) + ".txt", new String[0]);
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (Stream<Path> s = Files.walk(baseDir, new FileVisitOption[0]);){
                    s.forEach(p -> {
                        if (p.endsWith(jUnitReportFile) && Files.isRegularFile(p, new LinkOption[0])) {
                            jUnitXMLFiles.add((Path)p);
                        } else if (p.endsWith(plainTextSummaryFile) && Files.isRegularFile(p, new LinkOption[0])) {
                            plainTextFiles.add(p);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error("Failed to search test summary files", (Throwable)e);
                return Collections.emptyList();
            }
            return !jUnitXMLFiles.isEmpty() ? jUnitXMLFiles : plainTextFiles;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }
}

