/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.svg;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.cwt.svg.SvgContainer;
import org.eclipse.nebula.cwt.svg.SvgElement;
import org.eclipse.nebula.cwt.svg.SvgGradientStop;
import org.eclipse.nebula.cwt.svg.SvgShape;
import org.eclipse.nebula.cwt.svg.SvgTransform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;

class SvgGradient
extends SvgElement {
    static final int X1 = 0;
    static final int Y1 = 1;
    static final int X2 = 3;
    static final int Y2 = 4;
    static final int CX = 3;
    static final int CY = 4;
    static final int FX = 3;
    static final int FY = 4;
    static final int R = 5;
    static final int PAD = 0;
    static final int REFLECT = 1;
    static final int REPEAT = 2;
    float[] data;
    String linkId;
    List<SvgGradientStop> stops = new ArrayList<SvgGradientStop>();
    GC gc;
    float[] bounds;
    Pattern pattern;
    boolean boundingBox = true;
    int spreadMethod = 0;
    SvgTransform transform;

    SvgGradient(SvgContainer container, String id) {
        super(container, id);
    }

    public void apply(boolean foreground) {
        SvgGradientStop[] stops = this.getStops();
        if (stops.length == 1) {
            this.apply(this.gc, stops[0], foreground);
        } else if (stops.length > 1) {
            if (this.pattern == null) {
                this.apply(this.gc, stops[stops.length - 1], foreground);
            } else if (foreground) {
                this.gc.setForegroundPattern(this.pattern);
            } else {
                this.gc.setBackgroundPattern(this.pattern);
            }
        }
    }

    private void apply(GC gc, SvgGradientStop stop, boolean foreground) {
        Color c = this.createColor(gc, stop.color);
        if (foreground) {
            gc.setForeground(c);
        } else {
            gc.setBackground(c);
        }
        c.dispose();
        gc.setAlpha((int)(255.0f * stop.opacity.floatValue()));
    }

    public void create(SvgShape shape, GC gc) {
        this.gc = gc;
        this.bounds = this.boundingBox ? shape.getBounds() : shape.getViewport();
        try {
            Class<?> c = Class.forName("org.eclipse.nebula.cwt.SwtAdapter");
            Method m = c.getMethod("createPattern", SvgGradient.class);
            this.pattern = (Pattern)m.invoke(c, this);
        }
        catch (Exception exception) {
            System.out.println("Could not create pattern - fragment must be missing");
        }
    }

    private Color createColor(GC gc, int color) {
        return new Color(gc.getDevice(), color >> 16, (color & 0xFF00) >> 8, color & 0xFF);
    }

    public void dispose() {
        if (this.pattern != null) {
            this.gc.setBackgroundPattern(null);
            this.pattern.dispose();
        }
        this.gc = null;
        this.bounds = null;
        this.pattern = null;
    }

    public SvgGradientStop[] getStops() {
        SvgGradientStop[] linkStops;
        SvgElement def;
        if (this.linkId != null && (def = this.getFragment().getElement(this.linkId)) instanceof SvgGradient && (linkStops = ((SvgGradient)def).getStops()).length > 0) {
            return linkStops;
        }
        return this.stops.toArray(new SvgGradientStop[this.stops.size()]);
    }

    public SvgTransform getTransform() {
        return this.transform;
    }

    void setLinkId(String id) {
        this.linkId = id != null && id.length() > 2 && '#' == id.charAt(0) ? id.substring(1) : null;
    }

    void setSpreadMethod(String s) {
        if (s != null) {
            if ("pad".equals(s)) {
                this.spreadMethod = 0;
            } else if ("reflect".equals(s)) {
                this.spreadMethod = 1;
            } else if ("repeat".equals(s)) {
                this.spreadMethod = 2;
            }
        }
    }

    void setTransform(SvgTransform transform) {
        this.transform = transform;
    }

    void setUnits(String s) {
        if (s != null) {
            this.boundingBox = "objectBoundingBox".equals(s);
        }
    }
}

