/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.model;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.AbstractModelWithSharedResource;
import org.eclipse.papyrus.infra.core.resource.BadArgumentExcetion;
import org.eclipse.papyrus.infra.core.resource.IEMFModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class NotationModel
extends AbstractModelWithSharedResource<Diagram>
implements IModel {
    public static final String NOTATION_FILE_EXTENSION = "notation";
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.core.resource.notation.NotationModel";
    private boolean checkingControlState = false;

    public NotationModel() {
        super(AbstractModelWithSharedResource.ModelKind.master);
    }

    protected String getModelFileExtension() {
        return NOTATION_FILE_EXTENSION;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public void addDiagram(Diagram newDiagram) {
        this.getResource().getContents().add((Object)newDiagram);
    }

    public boolean isControlled(Resource resource) {
        if (this.checkingControlState) {
            return false;
        }
        try {
            this.checkingControlState = true;
            for (Resource resourceInModelSet : this.modelSet.getResources()) {
                EObject eObject;
                IModel iModel;
                if (!resource.getURI().trimFileExtension().equals(resourceInModelSet.getURI().trimFileExtension()) || this.isRelatedResource(resourceInModelSet) || resourceInModelSet.getContents().isEmpty() || !((iModel = this.modelSet.getModelFor((Object)(eObject = (EObject)resourceInModelSet.getContents().get(0)))) instanceof IEMFModel) || !((IEMFModel)iModel).isControlled(resourceInModelSet)) continue;
                return true;
            }
        }
        finally {
            this.checkingControlState = false;
        }
        return false;
    }

    public void handle(Resource resource) {
        super.handle(resource);
    }

    public Diagram getDiagram(String diagramName) throws NotFoundException, BadArgumentExcetion {
        if (diagramName == null || diagramName.length() == 0) {
            throw new BadArgumentExcetion("Diagram name should not be null and size should be >0.");
        }
        for (Resource current : this.getResources()) {
            for (EObject element : current.getContents()) {
                Diagram diagram;
                if (!(element instanceof Diagram) || !diagramName.equals((diagram = (Diagram)element).getName())) continue;
                return diagram;
            }
        }
        throw new NotFoundException(NLS.bind((String)"No Diagram named '{0}' can be found in Model.", (Object)diagramName));
    }

    protected boolean isRootElement(EObject object) {
        return super.isRootElement(object) && ViewPrototype.isViewObject((EObject)object);
    }

    protected boolean isSupportedRoot(EObject object) {
        return ViewPrototype.isViewObject((EObject)object);
    }

    protected boolean isModelRoot(EObject object) {
        return object instanceof Diagram;
    }
}

