/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.emf;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.ui.CustomizedContentProviderUtils;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.emf.readonly.spi.IReadOnlyManagerProcessor;
import org.eclipse.papyrus.infra.emf.spi.resolver.IEObjectResolver;
import org.eclipse.papyrus.infra.ui.emf.internal.facet.ArchitectureFrameworkCustomizationManagerUpdater;
import org.eclipse.papyrus.infra.ui.emf.internal.facet.ICustomizationManagerUpdater;
import org.eclipse.papyrus.infra.ui.internal.emf.readonly.EditorReloadProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.ui.emf";
    private static Activator plugin;
    public static LogHelper log;
    private ServiceRegistration<IEObjectResolver> eobjectResolverReg;
    private ServiceRegistration<IReadOnlyManagerProcessor> roManagerProcessorReg;
    private ICustomizationManagerUpdater customizationUpdater;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
        this.customizationUpdater = ArchitectureFrameworkCustomizationManagerUpdater.INSTANCE;
        this.eobjectResolverReg = context.registerService(IEObjectResolver.class, CustomizedContentProviderUtils::resolve, null);
        this.roManagerProcessorReg = context.registerService(IReadOnlyManagerProcessor.class, (Object)new EditorReloadProcessor(), null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.roManagerProcessorReg != null) {
            this.roManagerProcessorReg.unregister();
            this.roManagerProcessorReg = null;
        }
        if (this.eobjectResolverReg != null) {
            this.eobjectResolverReg.unregister();
            this.eobjectResolverReg = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void saveCustomizationManagerState() {
        this.customizationUpdater.saveUserCustomizationsState();
    }

    private void init(ICustomizationManager customizationManager) {
        this.customizationUpdater.applyCustomizations();
    }

    public void resetToDefaultCustomizations() {
        this.customizationUpdater.resetToDefaultCustomizations();
    }

    public ICustomizationManager getCustomizationManager() {
        return org.eclipse.papyrus.infra.emf.Activator.getDefault().getCustomizationManager();
    }

    public static Image getPluginIconImage(String pluginId, String iconPath) {
        String key = String.valueOf(pluginId) + iconPath;
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)iconPath);
            registry.put(key, desc);
            image = registry.get(key);
        }
        return image;
    }
}

