/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.SingleProjectContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class StringWorkspaceFileSelector
extends StringEditor {
    private Button deleteButton;
    private Button browseWorkspace;
    private List<String> filterNames;
    private List<String> filterExtensions;
    private boolean readOnly = false;
    private boolean showOnlyCurrentProject = false;
    protected String currentProjectName;

    public StringWorkspaceFileSelector(Composite parent, int style) {
        super(parent, style | 8);
        super.setReadOnly(this.readOnly);
        ((GridLayout)this.getLayout()).numColumns = 5;
        this.deleteButton = factory.createButton((Composite)this, "", 8);
        this.deleteButton.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.deleteButton.setLayoutData((Object)new GridData());
        this.browseWorkspace = factory.createButton((Composite)this, Messages.StringWorkspaceFileSelector_BrowseWorkspace, 8);
        this.browseWorkspace.setLayoutData((Object)new GridData());
        this.filterNames = new LinkedList<String>();
        this.filterExtensions = new LinkedList<String>();
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringWorkspaceFileSelector.this.setResult("");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.browseWorkspace.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object file;
                Object[] result;
                int code;
                LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
                try {
                    labelProviderService.startService();
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                }
                ILabelProvider labelProvider = labelProviderService.getLabelProvider();
                IFile currentFile = StringWorkspaceFileSelector.this.getIFile(StringWorkspaceFileSelector.this.text.getText());
                TreeSelectorDialog dialog = new TreeSelectorDialog(StringWorkspaceFileSelector.this.getShell());
                if (StringWorkspaceFileSelector.this.labelText != null) {
                    dialog.setTitle(StringWorkspaceFileSelector.this.labelText);
                }
                WorkspaceContentProvider contentProvider = StringWorkspaceFileSelector.this.createWorkspaceContentProvider();
                if (!StringWorkspaceFileSelector.this.filterExtensions.isEmpty() && !StringWorkspaceFileSelector.this.filterNames.isEmpty()) {
                    contentProvider.setExtensionFilters(new LinkedHashMap<String, String>());
                    int i = 0;
                    while (i < Math.min(StringWorkspaceFileSelector.this.filterNames.size(), StringWorkspaceFileSelector.this.filterExtensions.size())) {
                        contentProvider.addExtensionFilter(StringWorkspaceFileSelector.this.filterExtensions.get(i), StringWorkspaceFileSelector.this.filterNames.get(i));
                        ++i;
                    }
                }
                dialog.setContentProvider(contentProvider);
                dialog.setLabelProvider(labelProvider);
                if (currentFile != null && currentFile.exists()) {
                    dialog.setInitialSelections(new Object[]{currentFile});
                }
                if ((code = dialog.open()) == 0 && (result = dialog.getResult()).length > 0 && (file = result[0]) instanceof IFile) {
                    StringWorkspaceFileSelector.this.setResult((IFile)file);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected IFile getIFile(String path) {
        return FileUtil.getIFile(path);
    }

    protected WorkspaceContentProvider createWorkspaceContentProvider() {
        if (this.showOnlyCurrentProject && this.currentProjectName != null && !this.currentProjectName.isEmpty()) {
            return new SingleProjectContentProvider(this.currentProjectName);
        }
        return new WorkspaceContentProvider();
    }

    protected void setResult(IFile file) {
        this.setResult(file.getFullPath().toString());
    }

    protected void setResult(String path) {
        this.text.setText(path);
        this.notifyChange();
    }

    public void setFilters(String[] filterExtensions, String[] filterNames) {
        if (filterExtensions.length != filterNames.length) {
            Activator.log.warn("FilterExtensions and FilterNames do not match");
        }
        this.setFilterNames(this.getFilterLabels(filterNames, filterExtensions));
        this.setFilterExtensions(filterExtensions);
    }

    protected String[] getFilterLabels(String[] filterNames, String[] filterExtensions) {
        int size = Math.min(filterNames.length, filterExtensions.length);
        String[] filters = new String[size];
        int i = 0;
        while (i < size) {
            filters[i] = String.valueOf(filterNames[i]) + " (" + filterExtensions[i] + ")";
            ++i;
        }
        return filters;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = Arrays.asList(filterExtensions);
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = Arrays.asList(filterNames);
    }

    public void addFilteredExtension(String filteredExtension, String filterName) {
        if (filteredExtension != null) {
            if (filterName == null) {
                filterName = filteredExtension;
            }
            this.filterExtensions.add(filteredExtension);
            this.filterNames.add(filterName);
        }
    }

    @Override
    public Object getEditableType() {
        return String.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.readOnly = readOnly;
        this.updateButtons();
    }

    private void updateButtons() {
        this.deleteButton.setEnabled(!this.readOnly);
        this.browseWorkspace.setEnabled(!this.readOnly);
    }

    public void setShowOnlyCurrentProject(boolean showOnlyCurrentProject) {
        this.showOnlyCurrentProject = showOnlyCurrentProject;
    }

    public void setProjectName(String projectName) {
        this.currentProjectName = projectName;
    }
}

