/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.tools.model.INewValueStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateFieldPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.tools.model.query.UpdateClauseStateObject;
import org.eclipse.persistence.jpa.jpql.utility.iterable.ListIterable;

public class UpdateItemStateObject
extends AbstractStateObject {
    private INewValueStateObjectBuilder builder;
    private StateObject newValue;
    private StateFieldPathExpressionStateObject stateFieldPath;
    public static final String NEW_VALUE_PROPERTY = "newValue";

    public UpdateItemStateObject(UpdateClauseStateObject parent) {
        super(parent);
    }

    public UpdateItemStateObject(UpdateClauseStateObject parent, String path, StateObject newValue) {
        super(parent);
        this.newValue = this.parent(newValue);
        this.setPath(path);
    }

    public UpdateItemStateObject(UpdateClauseStateObject parent, String path, String newValue) {
        super(parent);
        this.parseNewValue(newValue);
        this.setPath(path);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.stateFieldPath != null) {
            children.add(this.stateFieldPath);
        }
        if (this.newValue != null) {
            children.add(this.newValue);
        }
    }

    public void appendToPath(String text) {
        this.stateFieldPath.append(text);
    }

    public INewValueStateObjectBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = this.getQueryBuilder().buildStateObjectBuilder(this);
        }
        return this.builder;
    }

    @Override
    public UpdateItem getExpression() {
        return (UpdateItem)super.getExpression();
    }

    public StateObject getNewValue() {
        return this.newValue;
    }

    @Override
    public UpdateClauseStateObject getParent() {
        return (UpdateClauseStateObject)super.getParent();
    }

    public String getPath() {
        return this.stateFieldPath.getPath();
    }

    public StateFieldPathExpressionStateObject getStateFieldPath() {
        return this.stateFieldPath;
    }

    public boolean hasNewValue() {
        return this.newValue != null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.stateFieldPath = new StateFieldPathExpressionStateObject(this);
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            UpdateItemStateObject updateItem = (UpdateItemStateObject)stateObject;
            return this.stateFieldPath.isEquivalent(updateItem.stateFieldPath) && this.areEquivalent(this.newValue, updateItem.newValue);
        }
        return false;
    }

    public ListIterable<String> items() {
        return this.stateFieldPath.items();
    }

    public int itemsSize() {
        return this.stateFieldPath.itemsSize();
    }

    public void parseNewValue(String newValue) {
        Object newValueStateObject = this.buildStateObject(newValue, "new_value");
        this.setNewValue((StateObject)newValueStateObject);
    }

    public void setExpression(UpdateItem expression) {
        super.setExpression(expression);
    }

    public void setNewValue(StateObject newValue) {
        this.builder = null;
        StateObject oldNewValue = this.newValue;
        this.newValue = this.parent(newValue);
        this.firePropertyChanged(NEW_VALUE_PROPERTY, oldNewValue, newValue);
    }

    public void setPath(String path) {
        this.stateFieldPath.setPath(path);
    }

    public void setPaths(ListIterator<String> paths) {
        this.stateFieldPath.setPaths(paths);
    }

    public void setPaths(String[] paths) {
        this.stateFieldPath.setPaths(paths);
    }

    public void setVirtualIdentificationVariable(String identificationVariable) {
        IdentificationVariableStateObject variable = new IdentificationVariableStateObject(this.stateFieldPath, identificationVariable);
        variable.setVirtual(true);
        this.stateFieldPath.setIdentificationVariableInternally(variable);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        this.stateFieldPath.toString(writer);
        writer.append(' ');
        writer.append("=");
        if (this.hasNewValue()) {
            writer.append(' ');
            this.newValue.toString(writer);
        }
    }
}

