/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.wizards.types.Messages;
import org.eclipse.php.internal.ui.wizards.types.NewPHPClassPage;
import org.eclipse.php.internal.ui.wizards.types.NewPHPElementData;
import org.eclipse.php.internal.ui.wizards.types.NewPHPTypePage;
import org.eclipse.php.internal.ui.wizards.types.NewPHPTypeWizard;
import org.eclipse.php.internal.ui.wizards.types.PHPClassTemplate;
import org.eclipse.php.internal.ui.wizards.types.PHPElementTemplate;
import org.eclipse.ui.INewWizard;

public class NewPHPClassWizard
extends NewPHPTypeWizard
implements INewWizard {
    private ArrayList<IMethod> funcsToAdd = new ArrayList();

    public NewPHPClassWizard() {
        this.setWindowTitle(Messages.NewPHPClassWizard_0);
        this.setDefaultPageImageDescriptor(PHPUiPlugin.getImageDescriptor("icons/full/wizban/newclass_wiz.png"));
        this.setNeedsProgressMonitor(true);
    }

    public NewPHPClassWizard(NewPHPTypePage page) {
        this();
        this.page = page;
        this.addPage((IWizardPage)page);
    }

    public void addPages() {
        if (this.page == null) {
            this.page = new NewPHPClassPage();
            this.addPage((IWizardPage)this.page);
            this.page.init(this.getSelection());
        }
    }

    public boolean performFinish() {
        String contents;
        if (this.page.isInExistingPHPFile()) {
            this.existingPHPFile = DLTKCore.createSourceModuleFrom((IFile)this.page.getExistingFile());
        }
        ClassPostFinishValidator validator = new ClassPostFinishValidator();
        ((NewPHPTypeWizard.PostFinishValidator)validator).packAndValidate();
        String containerName = this.page.getSourceText();
        String fileName = this.page.getNewFileName();
        PHPClassTemplate templateEngine = new PHPClassTemplate();
        try {
            templateEngine.resolveTemplate();
        }
        catch (IOException ioe) {
            Logger.logException(ioe);
        }
        NewPHPElementData data = this.populatePHPElementData();
        this.compilationResult = contents = ((PHPElementTemplate)templateEngine).processTemplate(data);
        if (!this.page.isInExistingPHPFile()) {
            this.createNewPHPFile(containerName, fileName, contents);
        } else {
            this.injectCodeIntoExistingFile();
        }
        if (validator.hasWarnings()) {
            this.getShell().getDisplay().asyncExec(() -> this.showWarningsDialog(validator.getWarnings()));
        }
        this.page.saveGeneratedGroupValues();
        return true;
    }

    private NewPHPElementData populatePHPElementData() {
        IType type;
        PHPVersion phpVersion = this.page.getPHPVersion();
        NewPHPClassPage page = (NewPHPClassPage)this.page;
        NewPHPElementData data = new NewPHPElementData();
        data.phpVersion = phpVersion;
        data.isGeneratePHPDoc = page.isCheckboxCreationChecked("PHPDoc Blocks");
        data.isGenerateTODOs = page.isCheckboxCreationChecked("TODOs");
        data.superClass = page.getSuperClassData();
        List<IType> interfacesList = page.getInterfaces();
        IType[] interfaces = new IType[interfacesList.size()];
        interfacesList.toArray(interfaces);
        data.interfaces = interfaces;
        List<IType> traitsList = page.getTraits();
        IType[] traits = new IType[traitsList.size()];
        traitsList.toArray(traits);
        data.traits = traits;
        List<String> existingImports = this.getExistingImports();
        data.existingImports = existingImports.toArray(new String[0]);
        ArrayList<String> imports = new ArrayList<String>();
        IType[] iTypeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            type = iTypeArray[n2];
            this.addImport(imports, type, existingImports);
            ++n2;
        }
        if (data.superClass != null) {
            this.addImport(imports, data.superClass, existingImports);
        }
        iTypeArray = traits;
        n = traits.length;
        n2 = 0;
        while (n2 < n) {
            type = iTypeArray[n2];
            this.addImport(imports, type, existingImports);
            ++n2;
        }
        data.isGenerateConstructor = page.isCheckboxCreationChecked("Constructor");
        data.isGenerateDestructor = page.isCheckboxCreationChecked("Destructor");
        data.isFinal = page.isCreateModifierChecked(1);
        data.isAbstract = page.isCreateModifierChecked(2);
        IMethod[] funcs = new IMethod[this.funcsToAdd.size()];
        this.funcsToAdd.toArray(funcs);
        IMethod[] iMethodArray = funcs;
        int n3 = funcs.length;
        n = 0;
        while (n < n3) {
            IMethod method = iMethodArray[n];
            try {
                IParameter[] parameters;
                IParameter[] iParameterArray = parameters = method.getParameters();
                int n4 = parameters.length;
                int n5 = 0;
                while (n5 < n4) {
                    IParameter parameter = iParameterArray[n5];
                    if (parameter.getType() != null) {
                        IType[] parameterTypes;
                        IType[] iTypeArray2 = parameterTypes = PHPModelUtils.getTypes((String)parameter.getType(), (ISourceModule)method.getSourceModule(), (int)method.getSourceRange().getOffset(), null);
                        int n6 = parameterTypes.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            IType parameterType = iTypeArray2[n7];
                            this.addImport(imports, parameterType, existingImports);
                            ++n7;
                        }
                    }
                    ++n5;
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            ++n;
        }
        data.funcsToAdd = funcs;
        data.className = page.getElementName();
        data.namespace = page.getNamespace();
        data.realNamespace = page.getRealNamespace();
        data.isExistingFile = page.isInExistingPHPFile();
        data.requiredToAdd = this.getRequires();
        if (data.isExistingFile) {
            data.isInFirstBlock = page.isInFirstPHPBlock();
            data.hasFirstBlock = true;
        }
        data.imports = imports.toArray(new String[0]);
        return data;
    }

    class ClassPostFinishValidator
    extends NewPHPTypeWizard.PostFinishValidator {
        ClassPostFinishValidator() {
        }

        @Override
        public void packAndValidate() {
            super.packAndValidate();
            this.handleInterfaces();
            IType superClassData = ((NewPHPClassPage)NewPHPClassWizard.this.page).getSuperClassData();
            if (superClassData != null) {
                NewPHPClassWizard.this.extractReqruiresInclude(superClassData);
                this.addRequiredFuns(superClassData);
            }
        }

        private void addRequiredFuns(IType superClassData) {
            if (((NewPHPClassPage)NewPHPClassWizard.this.page).isCheckboxCreationChecked("Inherited abstract methods")) {
                try {
                    NewPHPClassWizard.this.funcsToAdd.addAll(Arrays.asList(PHPModelUtils.getUnimplementedMethods((IType)superClassData, null)));
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
            }
        }

        private void handleInterfaces() {
            for (IType currentInterface : NewPHPClassWizard.this.page.getInterfaces()) {
                if (currentInterface == null) continue;
                NewPHPClassWizard.this.extractReqruiresInclude(currentInterface);
                this.addRequiredFuns(currentInterface);
            }
            for (IType currentInterface : NewPHPClassWizard.this.page.getTraits()) {
                if (currentInterface == null) continue;
                NewPHPClassWizard.this.extractReqruiresInclude(currentInterface);
            }
        }
    }
}

