/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.internal.preferences.PropertyMapAdapter;

public final class PreferenceStoreAdapter
extends PropertyMapAdapter {
    private IPreferenceStore store;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            PreferenceStoreAdapter.this.firePropertyChange(event.getProperty());
        }
    };

    public PreferenceStoreAdapter(IPreferenceStore toConvert) {
        this.store = toConvert;
    }

    @Override
    protected void attachListener() {
        this.store.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void detachListener() {
        this.store.removePropertyChangeListener(this.listener);
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getValue(String propertyId, Class propertyType) {
        if (propertyType.isAssignableFrom(String.class)) {
            return this.store.getString(propertyId);
        }
        if (propertyType == Boolean.class) {
            return this.store.getBoolean(propertyId) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (propertyType == Double.class) {
            return new Double(this.store.getDouble(propertyId));
        }
        if (propertyType == Float.class) {
            return new Float(this.store.getFloat(propertyId));
        }
        if (propertyType == Integer.class) {
            return new Integer(this.store.getInt(propertyId));
        }
        if (propertyType == Long.class) {
            return new Long(this.store.getLong(propertyId));
        }
        return null;
    }

    @Override
    public boolean propertyExists(String propertyId) {
        return this.store.contains(propertyId);
    }

    @Override
    public void setValue(String propertyId, Object newValue) {
        if (newValue instanceof String) {
            this.store.setValue(propertyId, (String)newValue);
        } else if (newValue instanceof Integer) {
            this.store.setValue(propertyId, ((Integer)newValue).intValue());
        } else if (newValue instanceof Boolean) {
            this.store.setValue(propertyId, ((Boolean)newValue).booleanValue());
        } else if (newValue instanceof Double) {
            this.store.setValue(propertyId, ((Double)newValue).doubleValue());
        } else if (newValue instanceof Float) {
            this.store.setValue(propertyId, ((Float)newValue).floatValue());
        } else if (newValue instanceof Integer) {
            this.store.setValue(propertyId, ((Integer)newValue).intValue());
        } else if (newValue instanceof Long) {
            this.store.setValue(propertyId, ((Long)newValue).longValue());
        }
    }
}

