/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.processes.shell.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.Activator;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.WaiterJob;
import org.eclipse.rse.services.clientserver.processes.ISystemProcessRemoteConstants;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

public class LinuxProcessHelper {
    private HashMap stateMap = new HashMap();
    private HashMap _usernamesByUid;
    private HashMap _uidsByUserName;
    private IHost _host;
    private static String COMMAND_GET_PASSWD = "getent passwd";

    public LinuxProcessHelper(IHost host) {
        int i = 0;
        while (i < 9) {
            this.stateMap.put(new Character(ISystemProcessRemoteConstants.ALL_STATES[i]), ISystemProcessRemoteConstants.ALL_STATES_STR[i]);
            ++i;
        }
        this._host = host;
    }

    public String convertToStateCode(String state) {
        String stateCode = " ";
        if (state == null) {
            return stateCode;
        }
        if (state.trim().equals("")) {
            return stateCode;
        }
        int i = 0;
        while (i < state.length()) {
            String nextState = (String)this.stateMap.get(new Character(state.charAt(i)));
            if (nextState != null) {
                stateCode = String.valueOf(stateCode) + nextState;
                if (i < state.length() - 1) {
                    stateCode = String.valueOf(stateCode) + ",";
                }
            }
            ++i;
        }
        if (stateCode.trim().equals("")) {
            return " ";
        }
        return stateCode.trim();
    }

    public void populateUsernames() {
        if (this._usernamesByUid != null && this._uidsByUserName != null || this._host == null) {
            return;
        }
        this._usernamesByUid = new HashMap();
        this._uidsByUserName = new HashMap();
        IShellService shellService = Activator.getShellService(this._host);
        Process p = null;
        try {
            IHostShell hostShell = shellService.launchShell("", null, (IProgressMonitor)new NullProgressMonitor());
            hostShell.writeToShell(this.getUserNameCommand());
            p = new HostShellProcessAdapter(hostShell);
        }
        catch (Exception e) {
            Activator.log(e);
            if (p != null) {
                p.destroy();
            }
            return;
        }
        BufferedReader bufferReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String nextLine;
            while ((nextLine = bufferReader.readLine()) != null && !nextLine.equals(Activator.DONE_MARKUP_STRING)) {
                String[] fields = nextLine.split(":");
                int length = fields.length;
                if (length < 3) continue;
                String uid = fields[2];
                String username = fields[0];
                if (uid == null || username == null) continue;
                this._usernamesByUid.put(uid, username);
                this._uidsByUserName.put(username, uid);
            }
            bufferReader.close();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        WaiterJob waiter = new WaiterJob(p);
        waiter.schedule();
    }

    public String getUid(String username) {
        if (this._uidsByUserName != null) {
            return (String)this._uidsByUserName.get(username);
        }
        return "";
    }

    public String getUsername(String uid) {
        String username = null;
        if (this._usernamesByUid != null) {
            username = (String)this._usernamesByUid.get(uid);
        }
        if (username != null && !username.equals("")) {
            return username;
        }
        return uid;
    }

    protected String getUserNameCommand() {
        return Activator.formatShellCommand(COMMAND_GET_PASSWD);
    }

    public boolean isInitialized() {
        return this._usernamesByUid != null && this._uidsByUserName != null;
    }
}

