/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.cdt.tabs;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CMainTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapResolverService;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.dialogs.FSOpenFileDialog;
import org.eclipse.tcf.te.tcf.launch.cdt.controls.TCFPeerSelector;
import org.eclipse.tcf.te.tcf.launch.cdt.interfaces.IRemoteTEConfigurationConstants;
import org.eclipse.tcf.te.tcf.launch.cdt.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.ui.controls.validator.NumberVerifyListener;

public abstract class TEAbstractMainTab
extends CMainTab {
    private static final String REMOTE_PROG_LABEL_TEXT = Messages.RemoteCMainTab_Program;
    private static final String SKIP_DOWNLOAD_BUTTON_TEXT = Messages.RemoteCMainTab_SkipDownload;
    private static final String REMOTE_PROG_TEXT_ERROR = Messages.RemoteCMainTab_ErrorNoProgram;
    private static final String CONNECTION_TEXT_ERROR = Messages.RemoteCMainTab_ErrorNoConnection;
    private static final String PRE_RUN_LABEL_TEXT = Messages.RemoteCMainTab_Prerun;
    private static final String PID_LABEL_TEXT = Messages.RemoteCMainTab_Pid;
    private static final String REMOTE_PROG_SYMBOLIC_TEXT_ERROR = Messages.RemoteCMainTab_ErrorSymbolicLink;
    private static final String REMOTE_USER_ID_LABEL_TEXT = Messages.RemoteCMainTab_RemoteUser_Label;
    protected TCFPeerSelector peerSelector;
    protected Label remoteProgLabel;
    protected Text remoteProgText;
    protected Button remoteBrowseButton;
    protected boolean remoteProgVisible = true;
    protected Button skipDownloadButton;
    protected boolean skipDownloadButtonVisible = true;
    protected boolean progTextFireNotification = true;
    protected boolean remoteProgTextFireNotification;
    protected boolean remoteProgValidation = true;
    protected Text preRunText;
    private Label preRunLabel;
    private Button preRunEditButton;
    private boolean preRunVisible = true;
    private Text userIdText;
    private Button userIdButton;
    private Label pidLabel;
    private Text pidText;
    private boolean pidVisible = false;
    public static final int NO_DOWNLOAD_GROUP = 512;
    public static final int NO_PRERUN_GROUP = 1024;
    public static final int NO_REMOTE_PATH = 2048;
    public static final int PID_GROUP = 4096;

    public TEAbstractMainTab() {
    }

    public TEAbstractMainTab(int flags) {
        super(flags);
        if ((flags & 2) != 0) {
            this.remoteProgValidation = false;
        }
        if ((flags & 0x200) != 0) {
            this.skipDownloadButtonVisible = false;
        }
        if ((flags & 0x400) != 0) {
            this.preRunVisible = false;
        }
        if ((flags & 0x800) != 0) {
            this.remoteProgVisible = false;
        }
        if ((flags & 0x1000) != 0) {
            this.pidVisible = true;
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.getControl();
        this.createVerticalSpacer(comp, 1);
        this.createRemoteConnectionGroup(comp);
        if (this.remoteProgVisible || this.preRunVisible || this.pidVisible) {
            this.createVerticalSpacer(comp, 1);
        }
        this.createTargetExePathGroup(comp);
        this.fProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (TEAbstractMainTab.this.progTextFireNotification) {
                    TEAbstractMainTab.this.setRemotePathFromLocalPath();
                }
            }
        });
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean retVal = super.isValid(config);
        if (retVal) {
            String name;
            this.setErrorMessage(null);
            if (this.peerSelector.getPeerId() == null) {
                this.setErrorMessage(CONNECTION_TEXT_ERROR);
                retVal = false;
            }
            if (retVal && this.remoteProgValidation && this.remoteProgVisible && (name = this.remoteProgText.getText().trim()).length() == 0) {
                this.setErrorMessage(REMOTE_PROG_TEXT_ERROR);
                retVal = false;
            }
        } else {
            try {
                if (Files.isSymbolicLink(Paths.get(this.fProgText.getText(), new String[0]))) {
                    this.setErrorMessage(NLS.bind((String)REMOTE_PROG_SYMBOLIC_TEXT_ERROR, (Object)Files.readSymbolicLink(Paths.get(this.fProgText.getText(), new String[0]))));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retVal;
    }

    protected void createRemoteConnectionGroup(Composite parent) {
        this.peerSelector = new TCFPeerSelector(parent, 0, 2);
        this.peerSelector.setLayoutData(new GridData(768));
        this.peerSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TEAbstractMainTab.this.setDirty(true);
                TEAbstractMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createTargetExePathGroup(Composite parent) {
        if (!this.remoteProgVisible && !this.preRunVisible) {
            return;
        }
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        if (this.remoteProgVisible) {
            this.remoteProgLabel = new Label(mainComp, 0);
            this.remoteProgLabel.setText(REMOTE_PROG_LABEL_TEXT);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.remoteProgLabel.setLayoutData((Object)gd);
            this.remoteProgText = new Text(mainComp, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            this.remoteProgText.setLayoutData((Object)gd);
            this.remoteProgText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent evt) {
                    if (TEAbstractMainTab.this.remoteProgTextFireNotification) {
                        TEAbstractMainTab.this.setLocalPathFromRemotePath();
                    }
                    TEAbstractMainTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.remoteBrowseButton = this.createPushButton(mainComp, Messages.RemoteCMainTab_Remote_Path_Browse_Button, null);
            this.remoteBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    TEAbstractMainTab.this.handleRemoteBrowseSelected();
                    TEAbstractMainTab.this.updateLaunchConfigurationDialog();
                }
            });
        }
        if (this.skipDownloadButtonVisible) {
            this.createDownloadOption(mainComp);
        }
        if (this.pidVisible) {
            this.pidLabel = new Label(mainComp, 0);
            this.pidLabel.setText(PID_LABEL_TEXT);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.pidLabel.setLayoutData((Object)gd);
            this.pidText = new Text(mainComp, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.pidText.setLayoutData((Object)gd);
            this.pidText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent evt) {
                    TEAbstractMainTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.pidText.addVerifyListener((VerifyListener)new NumberVerifyListener());
        }
        if (this.preRunVisible) {
            this.createVerticalSpacer(mainComp, 2);
            Composite userIdComp = new Composite(mainComp, 0);
            GridLayout userIdCompLayout = new GridLayout();
            userIdCompLayout.numColumns = 2;
            userIdCompLayout.marginHeight = 0;
            userIdCompLayout.marginWidth = 0;
            userIdComp.setLayout((Layout)userIdCompLayout);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            userIdComp.setLayoutData((Object)gd);
            this.userIdButton = this.createCheckButton(userIdComp, REMOTE_USER_ID_LABEL_TEXT);
            this.userIdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    TEAbstractMainTab.this.updateLaunchRemoteUserControls();
                    TEAbstractMainTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.userIdButton.setEnabled(true);
            this.userIdText = new Text(userIdComp, 2052);
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            this.userIdText.setLayoutData((Object)gd);
            this.userIdText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent evt) {
                    TEAbstractMainTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.createVerticalSpacer(mainComp, 2);
            this.preRunLabel = new Label(mainComp, 0);
            this.preRunLabel.setText(PRE_RUN_LABEL_TEXT);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.preRunLabel.setLayoutData((Object)gd);
            this.preRunText = new Text(mainComp, 2050);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            gd.heightHint = 3 * this.preRunText.getLineHeight();
            this.preRunText.setLayoutData((Object)gd);
            this.preRunText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent evt) {
                    TEAbstractMainTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.preRunEditButton = this.createPushButton(mainComp, Messages.RemoteCMainTab_Prerun_Edit_Button, null);
            gd = new GridData(4, 1, false, false);
            this.preRunEditButton.setLayoutData((Object)gd);
            this.preRunEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    TEAbstractMainTab.this.showCommandsEditor();
                }
            });
        }
    }

    protected void createDownloadOption(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        mainComp.setLayoutData((Object)gd);
        this.skipDownloadButton = this.createCheckButton(mainComp, SKIP_DOWNLOAD_BUTTON_TEXT);
        this.skipDownloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TEAbstractMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.skipDownloadButton.setEnabled(true);
    }

    protected void handleRemoteBrowseSelected() {
        IPeerNode connection = this.peerSelector.getPeerNode();
        if (connection != null) {
            String absPath;
            Object candidate;
            FSOpenFileDialog dialog = new FSOpenFileDialog(this.getShell());
            dialog.setInput((Object)connection);
            if (dialog.open() == 0 && (candidate = dialog.getFirstResult()) instanceof FSTreeNode && (absPath = ((FSTreeNode)candidate).getLocation()) != null) {
                this.remoteProgText.setText(absPath);
            }
        }
    }

    protected void updateTargetProgFromConfig(ILaunchConfiguration config) {
        if (this.remoteProgText != null) {
            String targetPath = "";
            try {
                targetPath = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PATH, "");
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            boolean prevRemoteProgTextFireNotification = this.remoteProgTextFireNotification;
            this.remoteProgTextFireNotification = false;
            this.remoteProgText.setText(targetPath);
            this.remoteProgTextFireNotification = prevRemoteProgTextFireNotification;
        }
        if (this.pidText != null) {
            String pid = "";
            try {
                pid = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PID, "");
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.pidText.setText(pid);
        }
        if (this.preRunText != null) {
            String prelaunchCmd = "";
            try {
                prelaunchCmd = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.preRunText.setText(prelaunchCmd);
        }
        if (this.userIdText != null) {
            String user = "";
            try {
                user = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_USER_ID, "");
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.userIdText.setText(user);
        }
    }

    protected void updateSkipDownloadFromConfig(ILaunchConfiguration config) {
        if (this.skipDownloadButton != null) {
            boolean downloadToTarget = true;
            try {
                downloadToTarget = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.skipDownloadButton.setSelection(downloadToTarget);
        }
    }

    protected void updateLaunchRemoteUserFromConfig(ILaunchConfiguration config) {
        if (this.userIdButton != null) {
            boolean launchRemoteUser = true;
            try {
                launchRemoteUser = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_LAUNCH_REMOTE_USER, false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.userIdButton.setSelection(launchRemoteUser);
            this.updateLaunchRemoteUserControls();
        }
    }

    private void updateLaunchRemoteUserControls() {
        if (this.userIdText != null && this.userIdButton != null) {
            this.userIdText.setEnabled(this.userIdButton.getSelection());
        }
    }

    private void setRemotePathFromLocalPath() {
        IPathMapResolverService svc;
        IPeerNode connection;
        String programName = this.fProgText.getText().trim();
        if (programName != null && !"".equals(programName) && this.remoteProgText != null && (connection = this.peerSelector.getPeerNode()) != null && (svc = (IPathMapResolverService)ServiceManager.getInstance().getService((Object)connection, IPathMapResolverService.class)) != null) {
            URI uri;
            File f;
            ICProject project;
            String remoteName = null;
            try {
                programName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programName);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            Path p = new Path(programName);
            if (!p.isAbsolute() && (project = this.getCProject()) != null && project.isOpen() && (f = URIUtil.toFile((URI)(uri = project.getLocationURI()))) != null) {
                programName = new File(f, p.toString()).getAbsolutePath();
            }
            if ((remoteName = svc.findTargetPath((Object)connection, programName)) != null) {
                boolean prevRemoteProgTextFireNotification = this.remoteProgTextFireNotification;
                this.remoteProgTextFireNotification = false;
                this.remoteProgText.setText(remoteName);
                this.remoteProgTextFireNotification = prevRemoteProgTextFireNotification;
            }
        }
    }

    private void setLocalPathFromRemotePath() {
        IPathMapResolverService svc;
        IPeerNode connection;
        String remoteName = this.remoteProgText.getText().trim();
        if (remoteName != null && !"".equals(remoteName) && (connection = this.peerSelector.getPeerNode()) != null && (svc = (IPathMapResolverService)ServiceManager.getInstance().getService((Object)connection, IPathMapResolverService.class)) != null) {
            String programName = svc.findHostPath((Object)connection, remoteName);
            if (programName == null) {
                String programParent = svc.findHostPath((Object)connection, Path.fromPortableString((String)remoteName).removeLastSegments(1).toPortableString());
                programName = programParent != null ? new File(programParent, Path.fromPortableString((String)remoteName).lastSegment()).toString() : "";
            }
            boolean prevProgTextFireNotification = this.progTextFireNotification;
            this.progTextFireNotification = false;
            this.fProgText.setText(programName);
            this.progTextFireNotification = prevProgTextFireNotification;
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        String remoteConnection = null;
        try {
            remoteConnection = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_CONNECTION, "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            this.progTextFireNotification = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_AUTO_PATH_MAPPING_FROM_LOCAL_TO_REMOTE, true);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            this.remoteProgTextFireNotification = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_AUTO_PATH_MAPPING_FROM_REMOTE_TO_LOCAL, true);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.peerSelector.updateSelectionFrom(remoteConnection);
        super.initializeFrom(config);
        this.updateTargetProgFromConfig(config);
        this.updateSkipDownloadFromConfig(config);
        this.updateLaunchRemoteUserFromConfig(config);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        String value;
        String currentSelection = this.peerSelector.getPeerId();
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_CONNECTION, currentSelection != null ? currentSelection : null);
        if (this.remoteProgText != null) {
            value = this.remoteProgText.getText();
            config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PATH, !"".equals(value.trim()) ? value.trim() : null);
        }
        if (this.pidText != null) {
            value = this.pidText.getText();
            config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PID, !"".equals(value.trim()) ? value.trim() : null);
        }
        if (this.skipDownloadButton != null) {
            config.setAttribute(IRemoteTEConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, this.skipDownloadButton.getSelection());
        }
        if (this.preRunText != null) {
            value = this.preRunText.getText();
            config.setAttribute(IRemoteTEConfigurationConstants.ATTR_PRERUN_COMMANDS, !"".equals(value.trim()) ? value.trim() : null);
        }
        if (this.userIdText != null) {
            value = this.userIdText.getText();
            config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_USER_ID, !"".equals(value.trim()) ? value.trim() : null);
        }
        if (this.userIdButton != null) {
            config.setAttribute(IRemoteTEConfigurationConstants.ATTR_LAUNCH_REMOTE_USER, this.userIdButton.getSelection());
        }
        super.performApply(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_CONNECTION, null);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PATH, null);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PID, null);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_PRERUN_COMMANDS, null);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_AUTO_PATH_MAPPING_FROM_LOCAL_TO_REMOTE, true);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_AUTO_PATH_MAPPING_FROM_REMOTE_TO_LOCAL, true);
    }

    protected void showCommandsEditor() {
        Dialog dialog = new Dialog(this.getShell()){
            private StyledText textArea;
            {
                this.textArea = null;
            }

            protected Control createDialogArea(Composite parent) {
                Composite baseComposite = (Composite)super.createDialogArea(parent);
                baseComposite.getShell().setText(Messages.RemoteCMainTab_Prerun_Edit_Dialog_Title);
                this.textArea = new StyledText(baseComposite, 2818);
                this.textArea.setAlwaysShowScrollBars(false);
                GridData textAreaGD = new GridData(1808);
                textAreaGD.heightHint = 180;
                textAreaGD.widthHint = 300;
                this.textArea.setLayoutData((Object)textAreaGD);
                this.textArea.setText(TEAbstractMainTab.this.preRunText.getText());
                return baseComposite;
            }

            protected void okPressed() {
                if (TEAbstractMainTab.this.preRunText != null && this.textArea != null) {
                    TEAbstractMainTab.this.preRunText.setText(this.textArea.getText());
                }
                super.okPressed();
            }

            protected boolean isResizable() {
                return true;
            }
        };
        dialog.open();
    }
}

