/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.accessor;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.accessor.AccessorUtils;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IAccessibleExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class MethodInvocationAccessor
extends ExpressionAccessor {
    private final Method m_method;
    private final String m_methodSignature;
    private final IAccessibleExpressionAccessor m_accessibleAccessor;
    private final PropertyTooltipProvider m_tooltipProvider;

    public MethodInvocationAccessor(Method setMethod) throws Exception {
        this.m_method = setMethod;
        this.m_methodSignature = ReflectionUtils.getMethodSignature((Method)this.m_method);
        this.m_accessibleAccessor = AccessorUtils.IAccessibleExpressionAccessor_forMethod(this.m_method);
        this.m_tooltipProvider = AccessorUtils.PropertyTooltipProvider_forMethod(this.m_method);
    }

    @Override
    public Expression getExpression(JavaInfo javaInfo) throws Exception {
        return this.getMethodInvocation(javaInfo);
    }

    @Override
    public boolean setExpression(final JavaInfo javaInfo, final String source) throws Exception {
        final MethodInvocation invocation = this.getMethodInvocation(javaInfo);
        if (invocation != null) {
            final AstEditor editor = javaInfo.getEditor();
            if (source == null) {
                ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        editor.removeEnclosingStatement((ASTNode)invocation);
                    }
                });
            } else {
                ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        editor.replaceInvocationArguments(invocation, (List<String>)ImmutableList.of((Object)source));
                    }
                });
            }
        } else if (source != null) {
            ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    javaInfo.addMethodInvocation(MethodInvocationAccessor.this.m_methodSignature, source);
                }
            });
        }
        return true;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IAccessibleExpressionAccessor.class) {
            return adapter.cast(this.m_accessibleAccessor);
        }
        if (adapter == PropertyTooltipProvider.class) {
            return adapter.cast(this.m_tooltipProvider);
        }
        return super.getAdapter(adapter);
    }

    private MethodInvocation getMethodInvocation(JavaInfo javaInfo) throws Exception {
        return javaInfo.getMethodInvocation(this.m_methodSignature);
    }
}

