/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

import java.util.Map;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.ICodanBuilder;
import org.eclipse.cdt.codan.internal.core.CodanRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CodanBuilder
extends IncrementalProjectBuilder
implements ICodanBuilder {
    public static final String BUILDER_ID = "org.eclipse.cdt.codan.core.codanBuilder";
    private boolean enabled = true;

    public CodanBuilder() {
        if (Boolean.valueOf(System.getProperty("codan.disabled")).booleanValue()) {
            this.enabled = false;
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (!this.enabled) {
            return null;
        }
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    @Override
    public void processResource(IResource resource, IProgressMonitor monitor) {
        this.processResource(resource, monitor, CheckerLaunchMode.RUN_ON_FULL_BUILD);
    }

    @Override
    public void processResource(IResource resource, IProgressMonitor monitor, CheckerLaunchMode mode) {
        if (!this.enabled) {
            return;
        }
        CodanRunner.processResource(resource, mode, monitor);
    }

    private void processResourceDelta(IResource resource, IProgressMonitor monitor) {
        this.processResource(resource, monitor, CheckerLaunchMode.RUN_ON_INC_BUILD);
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.processResource((IResource)this.getProject(), monitor);
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new CodanDeltaVisitor(monitor));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processResource(IResource resource, IProgressMonitor monitor, CheckerLaunchMode mode, Object model) {
        if (!this.enabled) {
            return;
        }
        if (model != null) {
            if (mode != CheckerLaunchMode.RUN_AS_YOU_TYPE) throw new IllegalArgumentException("This mode is not supported");
            CodanRunner.runInEditor(model, resource, monitor);
            return;
        } else {
            this.processResource(resource, monitor, mode);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private class CodanDeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public CodanDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    CodanBuilder.this.processResourceDelta(resource, this.monitor);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    CodanBuilder.this.processResourceDelta(resource, this.monitor);
                }
            }
            return true;
        }
    }
}

