/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.exporter.ui.contribution.base;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterURIPage;
import org.eclipse.emf.exporter.ExporterPlugin;
import org.eclipse.emf.exporter.ModelExporter;
import org.eclipse.emf.exporter.ui.contribution.base.IModelExporterPage;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ModelExporterDirectoryURIPage
extends ModelConverterURIPage
implements IModelExporterPage {
    public ModelExporterDirectoryURIPage(ModelExporter modelExporter, String pageName) {
        super((ModelConverter)modelExporter, pageName);
        this.setDescription(ExporterPlugin.INSTANCE.getString("_UI_ArtifactDirectory_description"));
    }

    public ModelExporter getModelExporter() {
        return (ModelExporter)this.getModelConverter();
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.getModelExporter().getDirectoryURI() != null;
    }

    protected String getURITextLabel() {
        return ExporterPlugin.INSTANCE.getString("_UI_ArtifactDirectoryURI_label");
    }

    protected String getURITextInitialValue() {
        URI uri = this.getModelExporter().getDirectoryURI();
        return uri == null ? super.getURITextInitialValue() : uri.toString();
    }

    protected void uriTextModified(String text) {
        if (text.length() == 0) {
            this.setErrorMessage(ExporterPlugin.INSTANCE.getString("_UI_DirectoryURI_error"));
        } else {
            Diagnostic diagnostic = this.getModelExporter().validateDirectoryURI(text);
            if (diagnostic.getSeverity() == 0) {
                this.getModelExporter().setDirectoryURI(text);
                if (this.getErrorMessage() != null) {
                    this.handleDiagnostic(diagnostic);
                }
            } else {
                this.getModelExporter().setDirectoryURI((URI)null);
                if (this.getErrorMessage() == null) {
                    this.handleDiagnostic(diagnostic);
                }
            }
        }
    }

    protected boolean browseFileSystem() {
        String directory;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 0);
        directoryDialog.setText(CommonUIPlugin.INSTANCE.getString("_UI_FolderSelection_title"));
        URI uri = this.getModelExporter().getDirectoryURI();
        if (uri != null) {
            directoryDialog.setFilterPath(uri.toFileString());
        }
        if ((directory = directoryDialog.open()) != null) {
            this.setDirectory(directory, false);
            return true;
        }
        return false;
    }

    protected boolean browseWorkspace() {
        IContainer[] containers;
        IResource initialFolderResource = null;
        URI uri = this.getModelExporter().getDirectoryURI();
        if (uri != null && uri.isPlatformResource()) {
            String initialFolder = uri.toPlatformString(true);
            initialFolderResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(initialFolder));
        }
        if ((containers = WorkspaceResourceDialog.openFolderSelection((Shell)this.getShell(), null, null, (boolean)false, (Object[])new Object[]{initialFolderResource}, null)).length == 1) {
            this.setDirectory(containers[0].getFullPath().toString(), true);
            return true;
        }
        return false;
    }

    protected void setDirectory(String directory, boolean platformURI) {
        if (!directory.endsWith(File.separator)) {
            directory = String.valueOf(directory) + File.separator;
        }
        if (platformURI) {
            this.getModelExporter().setDirectoryURI(URI.createPlatformResourceURI((String)directory, (boolean)true));
        } else {
            this.getModelExporter().setDirectoryURI(URI.createFileURI((String)directory));
        }
        this.setURIText(this.getModelExporter().getDirectoryURI().toString());
    }
}

