/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo.form;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.internal.rpm.createrepo.Activator;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoProject;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;
import org.eclipse.linuxtools.internal.rpm.createrepo.tree.CreaterepoCategoryModel;
import org.eclipse.linuxtools.internal.rpm.createrepo.tree.CreaterepoTreeCategory;
import org.eclipse.linuxtools.internal.rpm.createrepo.tree.CreaterepoTreeContentProvider;
import org.eclipse.linuxtools.internal.rpm.createrepo.tree.CreaterepoTreeLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.menus.IMenuService;
import org.osgi.service.prefs.BackingStoreException;

public class MetadataPage
extends FormPage {
    private CreaterepoProject project;
    private IEclipsePreferences eclipsePreferences;
    private FormToolkit toolkit;
    private Text tagTxt;
    private Tree tagsTree;
    private TreeViewer tagsTreeViewer;
    private static final String MENU_URI = "toolbar:formsToolbar";
    private static final String HEADER_ICON = "/icons/library_obj.gif";

    public MetadataPage(FormEditor editor, CreaterepoProject project) {
        super(editor, Messages.MetadataPage_title, Messages.MetadataPage_title);
        this.project = project;
        this.eclipsePreferences = project.getEclipsePreferences();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        GridLayout layout = new GridLayout();
        this.toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText(Messages.MetadataPage_formHeaderText);
        form.setImage(Activator.getImageDescriptor(HEADER_ICON).createImage());
        ToolBarManager toolbarManager = (ToolBarManager)form.getToolBarManager();
        this.toolkit.decorateFormHeading(form.getForm());
        IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)toolbarManager, MENU_URI);
        toolbarManager.update(true);
        layout = new GridLayout();
        layout.marginWidth = 6;
        layout.marginHeight = 12;
        form.getBody().setLayout((Layout)layout);
        Section revSection = this.toolkit.createSection(form.getBody(), 384);
        layout = new GridLayout();
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        revSection.setText(Messages.MetadataPage_sectionTitleRevision);
        revSection.setDescription(Messages.MetadataPage_sectionInstructionRevision);
        revSection.setLayoutData((Object)data);
        Composite sectionClient = this.toolkit.createComposite((Composite)revSection);
        layout = new GridLayout(2, false);
        layout.marginWidth = 1;
        layout.marginHeight = 7;
        sectionClient.setLayout((Layout)layout);
        Text revisionTxt = this.createTextFieldWithLabel(sectionClient, Messages.MetadataPage_labelRevision);
        String prefRevisionTxt = this.eclipsePreferences.get("revision", "");
        if (!prefRevisionTxt.isEmpty()) {
            revisionTxt.setText(prefRevisionTxt);
        }
        revisionTxt.addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(e -> {
            String revisionText = revisionTxt.getText().trim();
            this.savePreferences("revision", revisionText);
        }));
        revSection.setClient((Control)sectionClient);
        Section tagSection = this.toolkit.createSection(form.getBody(), 384);
        layout = new GridLayout();
        tagSection.setText(Messages.MetadataPage_sectionTitleTags);
        tagSection.setDescription(Messages.MetadataPage_sectionInstructionTags);
        tagSection.setLayoutData((Object)MetadataPage.expandComposite());
        Composite sectionClientTags = this.toolkit.createComposite((Composite)tagSection);
        layout = new GridLayout(2, false);
        layout.marginWidth = 1;
        layout.marginHeight = 7;
        sectionClientTags.setLayout((Layout)layout);
        this.tagTxt = this.createTextFieldWithLabel(sectionClientTags, Messages.MetadataPage_labelTags);
        this.tagTxt.addSelectionListener((SelectionListener)new AddTagButtonListener());
        this.tagsTreeViewer = new TreeViewer(sectionClientTags, 33622788);
        this.tagsTreeViewer.setContentProvider((IContentProvider)new CreaterepoTreeContentProvider());
        this.tagsTreeViewer.setLabelProvider((IBaseLabelProvider)new CreaterepoTreeLabelProvider());
        CreaterepoCategoryModel model = new CreaterepoCategoryModel(this.project);
        this.tagsTreeViewer.setInput((Object)model);
        this.tagsTreeViewer.addSelectionChangedListener(event -> {
            if (this.tagsTree.getSelectionCount() == 1) {
                TreeItem treeItem = this.tagsTree.getSelection()[0];
                if (!(treeItem.getData() instanceof CreaterepoTreeCategory)) {
                    String tag = (String)treeItem.getData();
                    this.tagTxt.setText(tag);
                } else {
                    this.tagTxt.setText("");
                }
            }
        });
        this.tagsTreeViewer.addDoubleClickListener(event -> {
            ITreeSelection selection = this.tagsTreeViewer.getStructuredSelection();
            Object object = selection.getFirstElement();
            if (object instanceof CreaterepoTreeCategory var3_4) {
                void category;
                this.tagsTreeViewer.setExpandedState((Object)category, !this.tagsTreeViewer.getExpandedState((Object)category));
            }
        });
        this.tagsTree = this.tagsTreeViewer.getTree();
        this.tagsTree.setLayoutData((Object)MetadataPage.expandComposite());
        Composite buttonList = this.toolkit.createComposite(sectionClientTags);
        layout = new GridLayout();
        data = new GridData(1, 4, false, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonList.setLayout((Layout)layout);
        buttonList.setLayoutData((Object)data);
        MetadataPage.createPushButton(buttonList, Messages.MetadataPage_buttonAddTag, this.toolkit).addSelectionListener((SelectionListener)new AddTagButtonListener());
        MetadataPage.createPushButton(buttonList, Messages.MetadataPage_buttonEditTag, this.toolkit).addSelectionListener((SelectionListener)new EditTagButtonListener());
        MetadataPage.createPushButton(buttonList, Messages.MetadataPage_buttonRemoveTag, this.toolkit).addSelectionListener((SelectionListener)new RemoveTagButtonListener());
        tagSection.setClient((Control)sectionClientTags);
        this.refreshTree();
        managedForm.refresh();
    }

    /*
     * WARNING - void declaration
     */
    private void refreshTree() {
        TreeItem[] treeItemArray = this.tagsTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            void category;
            TreeItem treeItem = treeItemArray[n2];
            Object object = treeItem.getData();
            if (object instanceof CreaterepoTreeCategory var5_5 && category.getTags().isEmpty()) {
                this.tagsTreeViewer.expandToLevel((Object)category, 1);
                this.tagsTreeViewer.update((Object)category, null);
            }
            ++n2;
        }
    }

    private static GridData expandComposite() {
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        return data;
    }

    private static Button createPushButton(Composite parent, String buttonText, FormToolkit toolkit) {
        Button button = toolkit.createButton(parent, buttonText, 0x3800008);
        button.setFont(parent.getFont());
        GridData gd = new GridData(4, 1, true, false);
        button.setLayoutData((Object)gd);
        return button;
    }

    private Text createTextFieldWithLabel(Composite parent, String labelName) {
        Composite areaLabelText = new Composite(parent, 0);
        GridData layoutData = new GridData();
        GridLayout gridlayout = new GridLayout(2, false);
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 2;
        layoutData.horizontalSpan = 2;
        layoutData.grabExcessHorizontalSpace = true;
        areaLabelText.setLayoutData((Object)layoutData);
        areaLabelText.setLayout((Layout)gridlayout);
        Label respositoryBaseURLLbl = new Label(areaLabelText, 0);
        respositoryBaseURLLbl.setText(labelName);
        layoutData = new GridData();
        layoutData.widthHint = 100;
        layoutData.horizontalAlignment = 1;
        layoutData.verticalAlignment = 2;
        respositoryBaseURLLbl.setLayoutData((Object)layoutData);
        Text textField = new Text(areaLabelText, 4);
        layoutData = new GridData();
        layoutData.horizontalIndent = 50;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 2;
        textField.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        textField.setLayoutData((Object)layoutData);
        this.toolkit.paintBordersFor(areaLabelText);
        return textField;
    }

    private void savePreferences(String key, String val) {
        this.eclipsePreferences.put(key, val);
        try {
            this.eclipsePreferences.flush();
            this.refreshTree();
        }
        catch (BackingStoreException e) {
            Activator.logError(Messages.MetadataPage_errorSavingPreferences, e);
        }
    }

    private static String preparePreferenceTag(CreaterepoTreeCategory category) {
        String preferenceToSave = "";
        if (!category.getTags().isEmpty()) {
            for (String tag : category.getTags()) {
                preferenceToSave = preferenceToSave.concat(String.valueOf(tag) + ";");
            }
            preferenceToSave = preferenceToSave.substring(0, preferenceToSave.length() - 1);
        }
        return preferenceToSave;
    }

    private class AddTagButtonListener
    extends SelectionAdapter {
        private AddTagButtonListener() {
        }

        /*
         * WARNING - void declaration
         */
        private void addTag() {
            String text;
            void var3_2;
            CreaterepoTreeCategory createrepoTreeCategory;
            ITreeSelection selection = MetadataPage.this.tagsTreeViewer.getStructuredSelection();
            Object object = selection.getFirstElement();
            if (object instanceof CreaterepoTreeCategory && (createrepoTreeCategory = (CreaterepoTreeCategory)object) == (CreaterepoTreeCategory)var3_2 && !(text = MetadataPage.this.tagTxt.getText().trim()).isEmpty()) {
                void category;
                category.addTag(text);
                MetadataPage.this.tagsTreeViewer.refresh((Object)category, false);
                MetadataPage.this.tagsTreeViewer.setExpandedState((Object)category, true);
                MetadataPage.this.tagTxt.setText("");
                String preferenceToSave = MetadataPage.preparePreferenceTag((CreaterepoTreeCategory)category);
                MetadataPage.this.savePreferences(category.getName(), preferenceToSave);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.addTag();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.addTag();
        }
    }

    private class EditTagButtonListener
    extends SelectionAdapter {
        private EditTagButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (MetadataPage.this.tagsTree.getSelectionCount() == 1) {
                TreeItem treeItem = MetadataPage.this.tagsTree.getSelection()[0];
                String newTag = MetadataPage.this.tagTxt.getText().trim();
                if (!(treeItem.getData() instanceof CreaterepoTreeCategory) && !newTag.isEmpty()) {
                    CreaterepoTreeCategory parent = (CreaterepoTreeCategory)treeItem.getParentItem().getData();
                    String oldTag = (String)treeItem.getData();
                    int oldTagIndex = parent.getTags().indexOf(oldTag);
                    if (parent.getTags().indexOf(newTag) == -1) {
                        parent.getTags().set(oldTagIndex, newTag);
                        MetadataPage.this.tagsTreeViewer.refresh((Object)parent, true);
                        MetadataPage.this.tagsTree.setSelection(treeItem);
                        String preferenceToSave = MetadataPage.preparePreferenceTag(parent);
                        MetadataPage.this.savePreferences(parent.getName(), preferenceToSave);
                    }
                }
            }
        }
    }

    private class RemoveTagButtonListener
    extends SelectionAdapter {
        private RemoveTagButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TreeItem treeItem;
            if (MetadataPage.this.tagsTree.getSelectionCount() == 1 && !((treeItem = MetadataPage.this.tagsTree.getSelection()[0]).getData() instanceof CreaterepoTreeCategory)) {
                CreaterepoTreeCategory parent = (CreaterepoTreeCategory)treeItem.getParentItem().getData();
                String tag = (String)treeItem.getData();
                parent.removeTag(tag);
                MetadataPage.this.tagsTreeViewer.refresh((Object)parent, true);
                MetadataPage.this.tagTxt.setText("");
                String preferenceToSave = MetadataPage.preparePreferenceTag(parent);
                MetadataPage.this.savePreferences(parent.getName(), preferenceToSave);
            }
        }
    }
}

