/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo.preference;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.linuxtools.internal.rpm.createrepo.Activator;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;
import org.eclipse.linuxtools.internal.rpm.createrepo.preference.CreaterepoPropertyPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CreaterepoGeneralPropertyPage
extends CreaterepoPropertyPage {
    private static final String linkTags = "<a>{0}</a>";
    private Button btnProjectSettings;
    private Link lnWorkspaceSettings;
    private Group generalGroup;
    private BooleanFieldEditor bfeIncludeChecksum;
    private BooleanFieldEditor bfeSQLDB;
    private BooleanFieldEditor bfeIgnoreSymlinks;
    private BooleanFieldEditor bfePrettyXML;
    private IntegerFieldEditor ifeSpawns;
    private Group updatesGroup;
    private BooleanFieldEditor bfeSameFilename;
    private Label lblCheckTs;
    private Group changelogGroup;
    private IntegerFieldEditor ifeChangelogLimit;
    private Composite checksumsContainer;
    private RadioGroupFieldEditor rgfeChecksums;
    private Composite compressContainer;
    private RadioGroupFieldEditor rgfeCompressionTypes;

    public CreaterepoGeneralPropertyPage() {
        super(Messages.CreaterepoPreferencePage_description);
    }

    @Override
    protected Composite addContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData layoutData = new GridData();
        composite.setLayout((Layout)layout);
        this.btnProjectSettings = new Button(composite, 32);
        this.btnProjectSettings.addListener(13, event -> this.toggleEnabled());
        layoutData = new GridData();
        layoutData.horizontalAlignment = 1;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.btnProjectSettings.setText(Messages.CreaterepoGeneralPropertyPage_projectSettings);
        this.btnProjectSettings.setLayoutData((Object)layoutData);
        this.btnProjectSettings.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("projectSettings"));
        this.btnProjectSettings.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.checkState()));
        this.lnWorkspaceSettings = new Link(composite, 0);
        layoutData = new GridData();
        layoutData.horizontalAlignment = 0x1000008;
        this.lnWorkspaceSettings.setLayoutData((Object)layoutData);
        this.lnWorkspaceSettings.setText(NLS.bind((String)linkTags, (Object)Messages.CreaterepoGeneralPropertyPage_workspaceSettings));
        this.lnWorkspaceSettings.setFont(parent.getFont());
        this.lnWorkspaceSettings.addListener(13, event -> {
            PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.eclipse.linuxtools.rpm.createrepo.preferences", (String[])new String[]{"org.eclipse.linuxtools.rpm.createrepo.preferences"}, null);
            preferenceDialog.open();
        });
        this.generalGroup = new Group(composite, 16);
        layout = new GridLayout(2, false);
        this.generalGroup.setLayout((Layout)layout);
        this.generalGroup.setText(Messages.CreaterepoPreferencePage_generalGroupLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.generalGroup);
        this.bfeIncludeChecksum = new BooleanFieldEditor("md-filenames", Messages.CreaterepoPreferencePage_booleanChecksumName, (Composite)this.generalGroup);
        this.bfeIncludeChecksum.fillIntoGrid((Composite)this.generalGroup, 2);
        this.bfeIncludeChecksum.setPreferenceStore(this.preferenceStore);
        this.bfeIncludeChecksum.setPropertyChangeListener((IPropertyChangeListener)this);
        this.bfeIncludeChecksum.load();
        this.bfeSQLDB = new BooleanFieldEditor("database", Messages.CreaterepoPreferencePage_booleanGenerateSQLDB, (Composite)this.generalGroup);
        this.bfeSQLDB.fillIntoGrid((Composite)this.generalGroup, 2);
        this.bfeSQLDB.setPreferenceStore(this.preferenceStore);
        this.bfeSQLDB.setPropertyChangeListener((IPropertyChangeListener)this);
        this.bfeSQLDB.load();
        this.bfeIgnoreSymlinks = new BooleanFieldEditor("skip-symlinks", Messages.CreaterepoPreferencePage_booleanIgnoreSymlinks, (Composite)this.generalGroup);
        this.bfeIgnoreSymlinks.fillIntoGrid((Composite)this.generalGroup, 2);
        this.bfeIgnoreSymlinks.setPreferenceStore(this.preferenceStore);
        this.bfeIgnoreSymlinks.setPropertyChangeListener((IPropertyChangeListener)this);
        this.bfeIgnoreSymlinks.load();
        this.bfePrettyXML = new BooleanFieldEditor("pretty", Messages.CreaterepoPreferencePage_booleanPrettyXML, (Composite)this.generalGroup);
        this.bfePrettyXML.fillIntoGrid((Composite)this.generalGroup, 2);
        this.bfePrettyXML.setPreferenceStore(this.preferenceStore);
        this.bfePrettyXML.setPropertyChangeListener((IPropertyChangeListener)this);
        this.bfePrettyXML.load();
        this.ifeSpawns = new IntegerFieldEditor("workers", Messages.CreaterepoPreferencePage_numWorkers, (Composite)this.generalGroup);
        this.ifeSpawns.fillIntoGrid((Composite)this.generalGroup, 2);
        this.ifeSpawns.setValidRange(0, 128);
        this.ifeSpawns.setPreferenceStore(this.preferenceStore);
        this.ifeSpawns.setPropertyChangeListener((IPropertyChangeListener)this);
        this.ifeSpawns.load();
        CreaterepoGeneralPropertyPage.updateGroupSpacing(this.generalGroup);
        this.updatesGroup = new Group(composite, 16);
        this.updatesGroup.setText(Messages.CreaterepoPreferencePage_updateGroupLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).hint(10, -1).applyTo((Control)this.updatesGroup);
        this.bfeSameFilename = new BooleanFieldEditor("checkts", Messages.CreaterepoPreferencePage_booleanCheckTS, (Composite)this.updatesGroup);
        this.bfeSameFilename.fillIntoGrid((Composite)this.updatesGroup, 2);
        this.bfeSameFilename.setPreferenceStore(this.preferenceStore);
        this.bfeSameFilename.setPropertyChangeListener((IPropertyChangeListener)this);
        this.bfeSameFilename.load();
        this.lblCheckTs = new Label((Composite)this.updatesGroup, 64);
        this.lblCheckTs.setText(Messages.CreaterepoPreferencePage_checkTSNote);
        layoutData = new GridData();
        layoutData.widthHint = 130;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalIndent = 5;
        this.lblCheckTs.setLayoutData((Object)layoutData);
        CreaterepoGeneralPropertyPage.updateGroupSpacing(this.updatesGroup);
        this.changelogGroup = new Group(composite, 16);
        this.changelogGroup.setText(Messages.CreaterepoPreferencePage_changelogGroupLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).hint(10, -1).applyTo((Control)this.changelogGroup);
        this.ifeChangelogLimit = new IntegerFieldEditor("changelog-limit", Messages.CreaterepoPreferencePage_numChangelogLimit, (Composite)this.changelogGroup);
        this.ifeChangelogLimit.fillIntoGrid((Composite)this.changelogGroup, 2);
        this.ifeChangelogLimit.setValidRange(0, Integer.MAX_VALUE);
        this.ifeChangelogLimit.setPreferenceStore(this.preferenceStore);
        this.ifeChangelogLimit.setPropertyChangeListener((IPropertyChangeListener)this);
        this.ifeChangelogLimit.load();
        CreaterepoGeneralPropertyPage.updateGroupSpacing(this.changelogGroup);
        this.checksumsContainer = new Composite(composite, 0);
        this.checksumsContainer.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(0, 20).grab(true, false).applyTo((Control)this.checksumsContainer);
        this.rgfeChecksums = new RadioGroupFieldEditor("checksum", Messages.CreaterepoPreferencePage_checksumGroupLabel, 1, (String[][])new String[][]{{"sha1", "sha1"}, {"md5", "md5"}, {"sha256", "sha256"}, {"sha512", "sha512"}}, this.checksumsContainer, true);
        this.rgfeChecksums.setPreferenceStore(this.preferenceStore);
        this.rgfeChecksums.setPropertyChangeListener((IPropertyChangeListener)this);
        this.rgfeChecksums.load();
        this.compressContainer = new Composite(composite, 0);
        this.compressContainer.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(0, 20).grab(true, false).applyTo((Control)this.compressContainer);
        this.rgfeCompressionTypes = new RadioGroupFieldEditor("compress-type", Messages.CreaterepoPreferencePage_compressionGroupLabel, 1, (String[][])new String[][]{{"compat", "compat"}, {"xz", "xz"}, {"gz", "gz"}, {"bz2", "bz2"}}, this.compressContainer, true);
        this.rgfeCompressionTypes.setPreferenceStore(this.preferenceStore);
        this.rgfeCompressionTypes.setPropertyChangeListener((IPropertyChangeListener)this);
        this.rgfeCompressionTypes.load();
        this.toggleEnabled();
        return composite;
    }

    public void performDefaults() {
        this.btnProjectSettings.setSelection(Activator.getDefault().getPreferenceStore().getDefaultBoolean("projectSettings"));
        this.bfeIncludeChecksum.loadDefault();
        this.bfeSQLDB.loadDefault();
        this.bfeIgnoreSymlinks.loadDefault();
        this.bfePrettyXML.loadDefault();
        this.ifeSpawns.loadDefault();
        this.rgfeChecksums.loadDefault();
        this.bfeSameFilename.loadDefault();
        this.ifeChangelogLimit.loadDefault();
        this.rgfeChecksums.loadDefault();
        this.rgfeCompressionTypes.loadDefault();
        Activator.getDefault().getPreferenceStore().setToDefault("projectSettings");
        this.getPreferenceStore().setToDefault("md-filenames");
        this.getPreferenceStore().setToDefault("database");
        this.getPreferenceStore().setToDefault("skip-symlinks");
        this.getPreferenceStore().setToDefault("pretty");
        this.getPreferenceStore().setToDefault("workers");
        this.getPreferenceStore().setToDefault("checkts");
        this.getPreferenceStore().setToDefault("changelog-limit");
        this.getPreferenceStore().setToDefault("checksum");
        this.getPreferenceStore().setToDefault("compress-type");
        this.toggleEnabled();
    }

    public boolean performOk() {
        if (this.btnProjectSettings.getSelection()) {
            Activator.getDefault().getPreferenceStore().setValue("projectSettings", true);
            this.getPreferenceStore().setValue("md-filenames", this.bfeIncludeChecksum.getBooleanValue());
            this.getPreferenceStore().setValue("database", this.bfeSQLDB.getBooleanValue());
            this.getPreferenceStore().setValue("skip-symlinks", this.bfeIgnoreSymlinks.getBooleanValue());
            this.getPreferenceStore().setValue("pretty", this.bfePrettyXML.getBooleanValue());
            this.getPreferenceStore().setValue("workers", this.ifeSpawns.getIntValue());
            this.getPreferenceStore().setValue("checkts", this.bfeSameFilename.getBooleanValue());
            this.getPreferenceStore().setValue("changelog-limit", this.ifeChangelogLimit.getIntValue());
            this.getPreferenceStore().setValue("checksum", this.getSelectedRadioButton(this.rgfeChecksums.getRadioBoxControl(this.checksumsContainer), this.rgfeChecksums.getPreferenceName()));
            this.getPreferenceStore().setValue("compress-type", this.getSelectedRadioButton(this.rgfeCompressionTypes.getRadioBoxControl(this.compressContainer), this.rgfeCompressionTypes.getPreferenceName()));
        } else {
            Activator.getDefault().getPreferenceStore().setValue("projectSettings", false);
        }
        return true;
    }

    private String getSelectedRadioButton(Composite radioBoxControl, String preferenceKey) {
        String defaultValue = this.getPreferenceStore().getDefaultString(preferenceKey);
        Control[] children = radioBoxControl.getChildren();
        if (children.length > 0) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                Button radioButton = (Button)control;
                if (radioButton.getSelection()) {
                    return radioButton.getText();
                }
                ++n2;
            }
        }
        return defaultValue;
    }

    @Override
    protected void checkState() {
        if (!this.btnProjectSettings.getSelection()) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else if (!this.ifeSpawns.isValid()) {
            this.setErrorMessage(this.ifeSpawns.getErrorMessage());
            this.setValid(false);
        } else if (!this.ifeChangelogLimit.isValid()) {
            this.setErrorMessage(this.ifeChangelogLimit.getErrorMessage());
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
        this.toggleEnabled();
    }

    private void toggleEnabled() {
        boolean enabled = this.btnProjectSettings.getSelection();
        this.lnWorkspaceSettings.setEnabled(!enabled);
        this.bfeIncludeChecksum.setEnabled(enabled, (Composite)this.generalGroup);
        this.bfeSQLDB.setEnabled(enabled, (Composite)this.generalGroup);
        this.bfeIgnoreSymlinks.setEnabled(enabled, (Composite)this.generalGroup);
        this.bfePrettyXML.setEnabled(enabled, (Composite)this.generalGroup);
        this.ifeSpawns.setEnabled(enabled, (Composite)this.generalGroup);
        this.rgfeChecksums.setEnabled(enabled, (Composite)this.generalGroup);
        this.bfeSameFilename.setEnabled(enabled, (Composite)this.updatesGroup);
        this.ifeChangelogLimit.setEnabled(enabled, (Composite)this.changelogGroup);
        this.rgfeChecksums.setEnabled(enabled, this.checksumsContainer);
        this.rgfeCompressionTypes.setEnabled(enabled, this.compressContainer);
        this.lblCheckTs.setEnabled(enabled);
    }
}

