/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.rpmlint.actions;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.rpm.rpmlint.actions.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ToggleRpmlintNatureAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        for (Object element : selection.toList()) {
            IProject project = null;
            if (element instanceof IProject var6_6) {
                project = p;
            } else {
                if (element instanceof IAdaptable var8_8) {
                    project = (IProject)a.getAdapter(IProject.class);
                }
            }
            if (project == null) continue;
            ToggleRpmlintNatureAction.toggleNature(project);
        }
        return null;
    }

    private static void toggleNature(IProject project) {
        String rpmlintPath = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.linuxtools.rpm.rpmlint").getString("RpmlintPath");
        if (!Files.exists(Paths.get(rpmlintPath, new String[0]), new LinkOption[0])) {
            IStatus warning = Status.warning((String)Messages.RunRpmlintAction_1);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.RunRpmlintAction_2, null, (IStatus)warning);
            return;
        }
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("org.eclipse.linuxtools.rpm.rpmlint.rpmlintNature".equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                    return;
                }
                ++i;
            }
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "org.eclipse.linuxtools.rpm.rpmlint.rpmlintNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

