/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.lemminx;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.Maven;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenConfigurationChangeListener;
import org.eclipse.m2e.editor.lemminx.InitializationOptionsProvider;
import org.eclipse.wildwebdeveloper.xml.LemminxClasspathExtensionProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRuntimeClasspathProvider
implements LemminxClasspathExtensionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MavenRuntimeClasspathProvider.class);
    private static IMavenConfigurationChangeListener mavenConfigurationlistener;
    private static final String LANGUAGE_SERVER = "org.eclipse.wildwebdeveloper.xml";

    public MavenRuntimeClasspathProvider() {
        if (mavenConfigurationlistener == null) {
            IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
            LanguageServersRegistry.LanguageServerDefinition definition = LanguageServersRegistry.getInstance().getDefinition(LANGUAGE_SERVER);
            if (mavenConfiguration != null && definition != null) {
                mavenConfigurationlistener = event -> {
                    Map<String, Object> options = InitializationOptionsProvider.toLemMinXOptions(mavenConfiguration);
                    DidChangeConfigurationParams params = new DidChangeConfigurationParams(Map.of("xml", options));
                    LanguageServiceAccessor.getActiveLanguageServers(null).stream().filter(s -> definition.equals(LanguageServiceAccessor.resolveServerDefinition((LanguageServer)s).get())).forEach(ls -> ls.getWorkspaceService().didChangeConfiguration(params));
                };
                MavenPlugin.getMavenConfiguration().addConfigurationChangeListener(mavenConfigurationlistener);
            }
        }
    }

    public List<File> get() {
        ArrayList<File> mavenRuntimeJars = new ArrayList<File>();
        MavenRuntimeClasspathProvider.addJarsFromBundle(FrameworkUtil.getBundle(Maven.class), "/jars/", mavenRuntimeJars);
        try {
            mavenRuntimeJars.add(FileLocator.getBundleFile((Bundle)FrameworkUtil.getBundle(Inject.class)));
            mavenRuntimeJars.add(FileLocator.getBundleFile((Bundle)FrameworkUtil.getBundle(Logger.class)));
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return mavenRuntimeJars;
    }

    private static void addJarsFromBundle(Bundle bundle, String folder, List<File> jarFiles) {
        try {
            URL fileURL = FileLocator.toFileURL((URL)bundle.getResource(folder));
            Path jarDir = Path.of(URIUtil.toURI((URL)fileURL));
            Throwable throwable = null;
            Object var6_8 = null;
            try (Stream<Path> paths = Files.walk(jarDir, 1, new FileVisitOption[0]);){
                paths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(Path::toFile).forEach(jarFiles::add);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

