/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.events;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.events.TmfEventTableColumnDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.VirtualTableQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.EventTableLine;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfFilterModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.TmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableCell;
import org.eclipse.tracecompass.internal.tmf.core.filter.TmfCollapseFilter;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.MultiAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.filter.FilterManager;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class TmfEventTableDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfVirtualTableDataProvider<TmfEventTableColumnDataModel, EventTableLine> {
    public static final String TABLE_SEARCH_EXPRESSION_KEY = "table_search_expressions";
    public static final String TABLE_SEARCH_DIRECTION_KEY = "table_search_direction";
    public static final String TABLE_FILTERS_KEY = "table_filters";
    public static final String ID = "org.eclipse.tracecompass.internal.provisional.tmf.core.model.events.TmfEventTableDataProvider";
    private @Nullable ITmfFilter fFilter;
    private TreeMap<Long, Long> fIndexToRankMap = new TreeMap();
    private TreeMap<Long, Long> fRankToIndexMap = new TreeMap();
    private long fFilteredCount = -1L;
    private static final AtomicLong fAtomicLong = new AtomicLong();
    private static final BiMap<ITmfEventAspect<?>, Long> fAspectToIdMap = HashBiMap.create();
    private static final int INDEX_STORING_INTERVAL = 1000;

    public TmfEventTableDataProvider(ITmfTrace trace) {
        super(trace);
    }

    @Override
    public String getId() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TmfModelResponse<TmfTreeModel<TmfEventTableColumnDataModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        BiMap<ITmfEventAspect<?>, Long> name;
        ArrayList<TmfEventTableColumnDataModel> model = new ArrayList<TmfEventTableColumnDataModel>();
        boolean hasTs = false;
        LinkedHashMap aspects = new LinkedHashMap();
        for (ITmfEventAspect<?> biMap : TmfEventTableDataProvider.getTraceAspects(this.getTrace())) {
            name = biMap.getName();
            aspects.computeIfPresent((String)name, (BiFunction<String, ITmfEventAspect<?>, ITmfEventAspect<?>>)((BiFunction<String, ITmfEventAspect, ITmfEventAspect>)(key, existing) -> MultiAspect.createFrom(existing, aspect)));
            aspects.putIfAbsent((String)name, biMap);
        }
        for (ITmfEventAspect<Object> iTmfEventAspect : aspects.values()) {
            name = fAspectToIdMap;
            synchronized (name) {
                long id = (Long)fAspectToIdMap.computeIfAbsent(iTmfEventAspect, a -> fAtomicLong.getAndIncrement());
                model.add(new TmfEventTableColumnDataModel(id, -1L, Collections.singletonList(iTmfEventAspect.getName()), iTmfEventAspect.getHelpText(), iTmfEventAspect.isHiddenByDefault()));
                hasTs |= iTmfEventAspect == TmfBaseAspects.getTimestampAspect();
            }
        }
        if (hasTs) {
            BiMap<ITmfEventAspect<?>, Long> biMap = fAspectToIdMap;
            synchronized (biMap) {
                ITmfEventAspect<Long> aspect = TmfBaseAspects.getTimestampNsAspect();
                long id = (Long)fAspectToIdMap.computeIfAbsent(aspect, a -> fAtomicLong.getAndIncrement());
                model.add(new TmfEventTableColumnDataModel(id, -1L, Collections.singletonList(aspect.getName()), aspect.getHelpText(), aspect.isHiddenByDefault()));
            }
        }
        return new TmfModelResponse<TmfTreeModel<TmfEventTableColumnDataModel>>(new TmfTreeModel(Collections.emptyList(), model), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    @Override
    public TmfModelResponse<ITmfVirtualTableModel<EventTableLine>> fetchLines(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        TableEventRequest request;
        boolean isIndexRequest;
        VirtualTableQueryFilter queryFilter;
        if (!fetchParameters.containsKey("requested_table_index") && fetchParameters.containsKey("requested_times")) {
            fetchParameters.put("requested_table_index", this.getTableIndex(fetchParameters));
        }
        if (!fetchParameters.containsKey("requested_table_column_ids")) {
            fetchParameters.put("requested_table_column_ids", Collections.emptyList());
        }
        if ((queryFilter = FetchParametersUtils.createVirtualTableQueryFilter(fetchParameters)) == null) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        @Nullable ITmfFilter filter = TmfEventTableDataProvider.extractFilter(fetchParameters);
        @Nullable ITmfFilter searchFilter = TmfEventTableDataProvider.extractSearchFilter(fetchParameters);
        @Nullable TmfCollapseFilter collapseFilter = TmfEventTableDataProvider.extractCollapseFilter(fetchParameters);
        Map<Long, ITmfEventAspect<?>> aspects = TmfEventTableDataProvider.getAspectsFromColumnsId(queryFilter.getColumnsId());
        if (aspects.isEmpty()) {
            return new TmfModelResponse<ITmfVirtualTableModel<EventTableLine>>(new TmfVirtualTableModel(Collections.emptyList(), Collections.emptyList(), queryFilter.getIndex(), 0L), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        ArrayList<Long> columnsIds = new ArrayList<Long>(aspects.keySet());
        if (this.getTrace().getNbEvents() == 0L) {
            return new TmfModelResponse<ITmfVirtualTableModel<EventTableLine>>(new TmfVirtualTableModel(columnsIds, Collections.emptyList(), queryFilter.getIndex(), 0L), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        Object directionValue = fetchParameters.get(TABLE_SEARCH_DIRECTION_KEY);
        Boolean isFiltered = DataProviderParameterUtils.extractIsFiltered(fetchParameters);
        boolean bl = isIndexRequest = isFiltered != null && isFiltered != false;
        if (isIndexRequest && directionValue == null) {
            directionValue = Direction.NEXT.name();
        }
        if (searchFilter != null && directionValue != null) {
            Direction direction = directionValue.equals(Direction.PREVIOUS.name()) ? Direction.PREVIOUS : Direction.NEXT;
            WrappedEvent event = null;
            Predicate<@NonNull ITmfEvent> predicate = filter == null ? searchFilter::matches : e -> filter.matches((ITmfEvent)e) && searchFilter.matches((ITmfEvent)e);
            if (direction == Direction.NEXT) {
                event = TmfEventTableDataProvider.getNextWrappedEventMatching(this.getTrace(), Math.abs(queryFilter.getIndex()), predicate, monitor);
            } else if (direction == Direction.PREVIOUS) {
                event = TmfEventTableDataProvider.getPreviousWrappedEventMatching(this.getTrace(), Math.abs(queryFilter.getIndex()), predicate, monitor);
            }
            ArrayList<EventTableLine> lines = new ArrayList<EventTableLine>();
            long rank = queryFilter.getIndex();
            if (event != null) {
                rank = event.getRank();
                queryFilter = new VirtualTableQueryFilter(queryFilter.getColumnsId(), rank, queryFilter.getCount());
                lines.add(TmfEventTableDataProvider.buildEventTableLine(aspects, event.getOriginalEvent(), rank, rank, true));
            }
            if (queryFilter.getCount() == 1 || event == null) {
                TmfVirtualTableModel model = new TmfVirtualTableModel(columnsIds, lines, rank, this.getTrace().getNbEvents());
                return new TmfModelResponse<ITmfVirtualTableModel<EventTableLine>>(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
        }
        if (filter != null) {
            request = this.filteredTableRequest(Math.abs(queryFilter.getCount()), queryFilter.getIndex(), aspects, filter, searchFilter, collapseFilter, monitor);
        } else {
            request = this.tableRequest(Math.abs(queryFilter.getCount()), queryFilter.getIndex(), aspects, searchFilter, collapseFilter, monitor);
            request.setEventCount(this.getTrace().getNbEvents());
        }
        this.getTrace().sendRequest(request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException e2) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, NonNullUtils.nullToEmptyString((Object)e2.getMessage()));
        }
        if (request.isCancelled()) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        TmfVirtualTableModel<EventTableLine> model = new TmfVirtualTableModel<EventTableLine>(columnsIds, request.getEventLines(), queryFilter.getIndex(), request.getCurrentCount());
        return new TmfModelResponse<ITmfVirtualTableModel<EventTableLine>>(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private long getTableIndex(Map<String, Object> fetchParameters) {
        List<Long> timeRequested = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        long index = 0L;
        if (timeRequested != null && !timeRequested.isEmpty()) {
            ITmfTrace trace = this.getTrace();
            ITmfContext context = trace.seekEvent(TmfTimestamp.fromNanos(timeRequested.get(0)));
            long rank = context.getRank();
            index = rank == -1L ? trace.getNbEvents() - 1L : rank;
            context.dispose();
        }
        return index;
    }

    public TmfModelResponse<List<Long>> fetchIndex(Map<String, Object> fetchParameters, long traceRank, long timeBegin, final @Nullable IProgressMonitor monitor) {
        long rank;
        final @Nullable ITmfFilter filter = TmfEventTableDataProvider.extractFilter(fetchParameters);
        if (traceRank == -1L) {
            ITmfContext context = this.getTrace().seekEvent(TmfTimestamp.fromNanos(timeBegin));
            rank = context.getRank();
        } else {
            rank = traceRank;
        }
        if (filter == null) {
            return new TmfModelResponse<List<Long>>(Collections.singletonList(rank), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        this.applyFilter(filter);
        Map.Entry<Long, Long> nearestEntry = this.fRankToIndexMap.floorEntry(rank);
        long startingIndex = nearestEntry != null ? nearestEntry.getValue() : 0L;
        long startingRank = nearestEntry != null ? nearestEntry.getKey() : 0L;
        final ArrayList foundIndex = new ArrayList();
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, TmfTimeRange.ETERNITY, startingRank, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND, startingIndex, startingRank){
            private long currentIndex;
            private long fRank;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                this.currentIndex = l;
                this.fRank = l2;
            }

            @Override
            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (monitor != null && monitor.isCanceled()) {
                    this.cancel();
                    return;
                }
                if (this.fRank >= rank) {
                    foundIndex.add(this.currentIndex);
                    this.done();
                    return;
                }
                if (filter.matches(event)) {
                    ++this.currentIndex;
                }
                ++this.fRank;
            }
        };
        this.getTrace().sendRequest(request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, NonNullUtils.nullToEmptyString((Object)e.getMessage()));
        }
        return new TmfModelResponse<List<Long>>(foundIndex, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private TableEventRequest filteredTableRequest(final int queryCount, final long queryIndex, final Map<Long, ITmfEventAspect<?>> aspects, final ITmfFilter filter, final @Nullable ITmfFilter searchFilter, final @Nullable ITmfFilter collapseFilter, final @Nullable IProgressMonitor monitor) {
        this.applyFilter(filter);
        Map.Entry<Long, Long> nearestEntry = this.fIndexToRankMap.floorEntry(queryIndex);
        long startingRank = nearestEntry != null ? nearestEntry.getValue() : 0L;
        Long startingIndex = nearestEntry != null ? nearestEntry.getKey() : 0L;
        return new TableEventRequest(this, startingRank, startingIndex, startingRank){
            private long currentIndex;
            private long rank;
            {
                super($anonymous0);
                this.currentIndex = l;
                this.rank = l2;
            }

            @Override
            public void handleData(@NonNull ITmfEvent event) {
                super.handleData(event);
                if (monitor != null && monitor.isCanceled()) {
                    this.cancel();
                    return;
                }
                List<EventTableLine> events = this.getEventLines();
                if (filter.matches(event) && (collapseFilter == null || collapseFilter.matches(event))) {
                    boolean matches;
                    boolean bl = matches = searchFilter != null && searchFilter.matches(event);
                    if (events.size() < queryCount && queryIndex <= this.currentIndex) {
                        events.add(TmfEventTableDataProvider.buildEventTableLine(aspects, event, this.currentIndex, this.rank, matches));
                    }
                    if (this.currentIndex % 1000L == 0L) {
                        fIndexToRankMap.put(this.currentIndex, this.rank);
                        fRankToIndexMap.put(this.rank, this.currentIndex);
                    }
                    ++this.currentIndex;
                    this.incrementCount();
                } else if (collapseFilter != null && !events.isEmpty()) {
                    int lastIndex = events.size() - 1;
                    EventTableLine prevLine = events.get(lastIndex);
                    long prevRepeatCount = prevLine.getRepeatCount();
                    events.set(lastIndex, new EventTableLine(prevLine.getCells(), prevLine.getIndex(), prevLine.getTimestamp(), prevLine.getRank(), ++prevRepeatCount));
                }
                ++this.rank;
            }

            @Override
            public long getCurrentCount() {
                long currentCount = super.getCurrentCount();
                if (fFilteredCount == -1L) {
                    fFilteredCount = currentCount;
                }
                return fFilteredCount;
            }
        };
    }

    private TableEventRequest tableRequest(final int queryCount, long queryIndex, final Map<Long, ITmfEventAspect<?>> aspects, final @Nullable ITmfFilter searchFilter, final @Nullable ITmfFilter collapseFilter, final @Nullable IProgressMonitor monitor) {
        return new TableEventRequest(this, queryIndex, queryIndex){
            private long rank;
            {
                super($anonymous0);
                this.rank = l;
            }

            @Override
            public void handleData(ITmfEvent event) {
                boolean matches;
                super.handleData(event);
                if (monitor != null && monitor.isCanceled()) {
                    this.cancel();
                    return;
                }
                List<EventTableLine> events = this.getEventLines();
                boolean bl = matches = searchFilter != null && searchFilter.matches(event);
                if (collapseFilter == null || collapseFilter.matches(event)) {
                    if (events.size() < queryCount) {
                        events.add(TmfEventTableDataProvider.buildEventTableLine(aspects, event, this.rank, this.rank, matches));
                    }
                } else if (!events.isEmpty()) {
                    int lastIndex = events.size() - 1;
                    EventTableLine prevLine = events.get(lastIndex);
                    long prevRepeatCount = prevLine.getRepeatCount();
                    events.set(lastIndex, new EventTableLine(prevLine.getCells(), prevLine.getIndex(), prevLine.getTimestamp(), prevLine.getRank(), ++prevRepeatCount));
                }
                if (this.getNbRead() == queryCount || events.size() == queryCount) {
                    this.done();
                    return;
                }
                ++this.rank;
            }
        };
    }

    private static EventTableLine buildEventTableLine(Map<Long, ITmfEventAspect<?>> aspects, ITmfEvent event, long lineIndex, long lineRank, boolean matches) {
        ArrayList<VirtualTableCell> entry = new ArrayList<VirtualTableCell>(aspects.size());
        for (Map.Entry<Long, ITmfEventAspect<?>> aspectEntry : aspects.entrySet()) {
            ITmfEventAspect<?> aspect = Objects.requireNonNull(aspectEntry.getValue());
            Object aspectResolved = aspect.resolve(event);
            String cellContent = aspectResolved == null ? "" : String.valueOf(aspectResolved);
            entry.add(new VirtualTableCell(cellContent));
        }
        EventTableLine tableLine = new EventTableLine(entry, lineIndex, event.getTimestamp(), lineRank, 0L);
        tableLine.setActiveProperties(matches ? 8 : 0);
        return tableLine;
    }

    private void applyFilter(ITmfFilter filter) {
        if (!filter.equals(this.fFilter)) {
            this.fFilter = filter;
            this.fIndexToRankMap.clear();
            this.fRankToIndexMap.clear();
            this.fFilteredCount = -1L;
        }
    }

    private static Map<Long, ITmfEventAspect<?>> getAspectsFromColumnsId(List<Long> desiredColumns) {
        LinkedHashMap aspects = new LinkedHashMap();
        if (!desiredColumns.isEmpty()) {
            for (Long columnsId : desiredColumns) {
                ITmfEventAspect aspect = (ITmfEventAspect)fAspectToIdMap.inverse().get((Object)columnsId);
                if (aspect == null) continue;
                aspects.put(columnsId, aspect);
            }
            return aspects;
        }
        return (Map)Objects.requireNonNull(fAspectToIdMap.inverse());
    }

    private static @Nullable ITmfFilter extractFilter(Map<String, Object> fetchParameters) {
        Object filtersObject = fetchParameters.get(TABLE_FILTERS_KEY);
        if (filtersObject instanceof ITmfFilterModel) {
            ITmfFilterModel filters = (ITmfFilterModel)filtersObject;
            Map<Long, String> filterMap = filters.getTableFilter();
            List<String> presetFilter = filters.getPresetFilter();
            if ((filterMap == null || filterMap.isEmpty()) && (presetFilter == null || presetFilter.isEmpty())) {
                return null;
            }
            TmfFilterRootNode rootFilter = new TmfFilterRootNode();
            if (filterMap != null && !filterMap.isEmpty()) {
                for (Map.Entry<Long, String> filterEntry : filterMap.entrySet()) {
                    TmfFilterMatchesNode filterNode = new TmfFilterMatchesNode(null);
                    ITmfEventAspect aspect = (ITmfEventAspect)fAspectToIdMap.inverse().get((Object)filterEntry.getKey());
                    if (aspect == null) {
                        return null;
                    }
                    filterNode.setEventAspect(aspect);
                    filterNode.setRegex(filterEntry.getValue());
                    rootFilter.addChild(filterNode);
                }
            }
            if (presetFilter != null && !presetFilter.isEmpty()) {
                ITmfFilterTreeNode[] savedFilters;
                ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = savedFilters = FilterManager.getSavedFilters();
                int n = savedFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    ITmfFilterTreeNode filterNode = iTmfFilterTreeNodeArray[n2];
                    if (filterNode instanceof TmfFilterNode) {
                        for (String presetFilterName : presetFilter) {
                            if (!((TmfFilterNode)filterNode).getFilterName().equals(presetFilterName)) continue;
                            rootFilter.addChild(filterNode);
                        }
                    }
                    ++n2;
                }
            }
            return rootFilter;
        }
        return null;
    }

    private static @Nullable ITmfFilter extractSearchFilter(Map<String, Object> fetchParameters) {
        Object searchFilterObject = fetchParameters.get(TABLE_SEARCH_EXPRESSION_KEY);
        if (searchFilterObject instanceof Map) {
            return TmfEventTableDataProvider.extractSimpleSearchFilter((Map)searchFilterObject);
        }
        return null;
    }

    private static @Nullable ITmfFilter extractSimpleSearchFilter(Map<?, String> searchMap) {
        if (searchMap.isEmpty()) {
            return null;
        }
        TmfFilterRootNode rootFilter = new TmfFilterRootNode();
        for (Map.Entry<?, String> searchEntry : searchMap.entrySet()) {
            TmfFilterMatchesNode searchNode = new TmfFilterMatchesNode(rootFilter);
            Long key = TmfEventTableDataProvider.extractColumnId(searchEntry.getKey());
            if (key == null) continue;
            ITmfEventAspect aspect = (ITmfEventAspect)fAspectToIdMap.inverse().get((Object)key);
            if (aspect == null) {
                return null;
            }
            searchNode.setEventAspect(aspect);
            searchNode.setRegex(searchEntry.getValue());
        }
        return rootFilter;
    }

    private static @Nullable Long extractColumnId(@Nullable Object key) {
        try {
            if (key instanceof String) {
                return Long.valueOf((String)key);
            }
            if (key instanceof Long) {
                return (Long)key;
            }
            if (key instanceof Integer) {
                return (long)((Integer)key);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static @Nullable TmfCollapseFilter extractCollapseFilter(Map<?, Object> fetchParameters) {
        Object filtersObject = fetchParameters.get(TABLE_FILTERS_KEY);
        if (filtersObject instanceof ITmfFilterModel) {
            ITmfFilterModel filters = (ITmfFilterModel)filtersObject;
            if (filters.isCollapseFilter()) {
                return new TmfCollapseFilter();
            }
            return null;
        }
        return null;
    }

    private static Iterable<ITmfEventAspect<?>> getTraceAspects(ITmfTrace trace) {
        if (trace instanceof TmfExperiment) {
            return TmfEventTableDataProvider.getExperimentAspects((TmfExperiment)trace);
        }
        return trace.getEventAspects();
    }

    private static Iterable<ITmfEventAspect<?>> getExperimentAspects(TmfExperiment experiment) {
        List<ITmfTrace> traces = experiment.getTraces();
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.add(TmfBaseAspects.getTraceNameAspect());
        if (TmfEventTableDataProvider.hasCommonTraceType(experiment)) {
            builder.addAll(traces.get(0).getEventAspects());
        } else {
            for (ITmfTrace trace : traces) {
                builder.addAll(trace.getEventAspects());
            }
        }
        return builder.build();
    }

    private static boolean hasCommonTraceType(TmfExperiment experiment) {
        @Nullable String commonTraceType = null;
        for (ITmfTrace trace : experiment.getTraces()) {
            String traceType = trace.getTraceTypeId();
            if (commonTraceType != null && !commonTraceType.equals(traceType)) {
                return false;
            }
            commonTraceType = traceType;
        }
        return commonTraceType != null;
    }

    private static @Nullable WrappedEvent getNextWrappedEventMatching(ITmfTrace trace, long startRank, Predicate<ITmfEvent> predicate, @Nullable IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        EventMatchingRequest req = new EventMatchingRequest(startRank, predicate, monitor);
        trace.sendRequest(req);
        try {
            req.waitForCompletion();
        }
        catch (InterruptedException e) {
            return null;
        }
        return req.getFoundEvent();
    }

    private static @Nullable WrappedEvent getPreviousWrappedEventMatching(ITmfTrace trace, long startRank, Predicate<ITmfEvent> predicate, @Nullable IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        int step = trace.getCacheSize();
        long currentRank = startRank + 1L;
        try {
            while (currentRank > 0L) {
                if ((currentRank -= (long)step) < 0L) {
                    step = (int)((long)step + currentRank);
                    currentRank = 0L;
                }
                ArrayList<WrappedEvent> list = new ArrayList<WrappedEvent>(step);
                ArrayFillingRequest req = new ArrayFillingRequest(currentRank, step, list, monitor);
                trace.sendRequest(req);
                req.waitForCompletion();
                Optional<WrappedEvent> matchingEvent = Lists.reverse(list).stream().filter(e -> predicate.test(e.getOriginalEvent())).findFirst();
                if (!matchingEvent.isPresent()) continue;
                return matchingEvent.get();
            }
        }
        catch (InterruptedException e2) {
            return null;
        }
        return null;
    }

    private static class ArrayFillingRequest
    extends TmfEventRequest {
        private final List<WrappedEvent> fList;
        private final @Nullable IProgressMonitor fMonitor;

        public ArrayFillingRequest(long startRank, int limit, List<WrappedEvent> listToFill, @Nullable IProgressMonitor monitor) {
            super(ITmfEvent.class, startRank, limit, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fList = listToFill;
            this.fMonitor = monitor;
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            this.fList.add(new WrappedEvent(event, this.getIndex() + (long)this.getNbRead() - 1L));
            if (this.fMonitor != null && this.fMonitor.isCanceled()) {
                this.cancel();
            }
        }
    }

    public static enum Direction {
        NEXT,
        PREVIOUS;

    }

    private static class EventMatchingRequest
    extends TmfEventRequest {
        private final Predicate<ITmfEvent> fPredicate;
        private final @Nullable IProgressMonitor fMonitor;
        private @Nullable WrappedEvent fFoundEvent = null;

        public EventMatchingRequest(long startRank, Predicate<ITmfEvent> predicate, @Nullable IProgressMonitor monitor) {
            super(ITmfEvent.class, startRank, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fPredicate = predicate;
            this.fMonitor = monitor;
        }

        public EventMatchingRequest(long startRank, int limit, Predicate<ITmfEvent> predicate, @Nullable IProgressMonitor monitor) {
            super(ITmfEvent.class, startRank, limit, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fPredicate = predicate;
            this.fMonitor = monitor;
        }

        public @Nullable WrappedEvent getFoundEvent() {
            return this.fFoundEvent;
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (this.fPredicate.test(event)) {
                this.fFoundEvent = new WrappedEvent(event, (long)this.getNbRead() + this.getIndex() - 1L);
                this.done();
            }
            if (this.fMonitor != null && this.fMonitor.isCanceled()) {
                this.cancel();
            }
        }
    }

    private abstract class TableEventRequest
    extends TmfEventRequest {
        private long fEventCount;
        private List<EventTableLine> fEventLines;

        public TableEventRequest(long startingRank) {
            super(ITmfEvent.class, TmfTimeRange.ETERNITY, startingRank, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fEventCount = 0L;
            this.fEventLines = new ArrayList<EventTableLine>();
        }

        public void incrementCount() {
            ++this.fEventCount;
        }

        public void setEventCount(long count) {
            this.fEventCount = count;
        }

        public long getCurrentCount() {
            return this.fEventCount;
        }

        public List<EventTableLine> getEventLines() {
            return this.fEventLines;
        }
    }

    private static class WrappedEvent
    implements ITmfEvent {
        private final ITmfEvent fEvent;
        private final long fRank;

        public WrappedEvent(ITmfEvent tmfEvent, long rank) {
            this.fEvent = tmfEvent;
            this.fRank = rank;
        }

        public ITmfEvent getOriginalEvent() {
            return this.fEvent;
        }

        public <T> @Nullable T getAdapter(@Nullable Class<T> adapterType) {
            return (T)this.fEvent.getAdapter(adapterType);
        }

        @Override
        public ITmfTrace getTrace() {
            return this.fEvent.getTrace();
        }

        @Override
        public long getRank() {
            return this.fRank;
        }

        @Override
        public String getName() {
            return this.fEvent.getName();
        }

        @Override
        public ITmfTimestamp getTimestamp() {
            return this.fEvent.getTimestamp();
        }

        @Override
        public @Nullable ITmfEventType getType() {
            return this.fEvent.getType();
        }

        @Override
        public @Nullable ITmfEventField getContent() {
            return this.fEvent.getContent();
        }
    }
}

