import { ISourceMapPathOverrides, IPathMapping } from '../debugAdapterInterfaces';
/**
 * Resolves a relative path in terms of another file
 */
export declare function resolveRelativeToFile(absPath: string, relPath: string): string;
/**
 * Determine an absolute path for the sourceRoot.
 */
export declare function getComputedSourceRoot(sourceRoot: string, generatedPath: string, pathMapping?: IPathMapping): string;
export declare function getAspNetFallbackCount(): number;
/**
 * Applies a set of path pattern mappings to the given path. See tests for examples.
 * Returns something validated to be an absolute path.
 */
export declare function applySourceMapPathOverrides(sourcePath: string, sourceMapPathOverrides: ISourceMapPathOverrides, isVSClient?: boolean): string;
export declare function resolveMapPath(pathToGenerated: string, mapPath: string, pathMapping: IPathMapping): string;
export declare function getFullSourceEntry(sourceRoot: string | undefined, sourcePath: string): string;
