/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.tcl.core.packages.TclPackagesFactory;
import org.eclipse.dltk.tcl.core.packages.VariableValue;
import org.eclipse.dltk.tcl.internal.ui.GlobalVariableContentProvider;
import org.eclipse.dltk.tcl.internal.ui.GlobalVariableEntry;
import org.eclipse.dltk.tcl.internal.ui.GlobalVariableLabelProvider;
import org.eclipse.dltk.tcl.internal.ui.TclInterpreterMessages;
import org.eclipse.dltk.ui.dialogs.IStatusDialog;
import org.eclipse.dltk.ui.dialogs.MultipleInputDialog;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class GlobalVariableBlock
implements SelectionListener,
ISelectionChangedListener {
    private static final String NAME_LABEL = TclInterpreterMessages.GlobalVariableBlock_Name;
    private static final String VALUE_LABEL = TclInterpreterMessages.GlobalVariableBlock_Value;
    protected GlobalVariableContentProvider fContentProvider;
    protected TreeViewer fVariablesViewer;
    private Button fRemoveButton;
    private Button fAddButton;
    private Button fEditButton;
    private final IStatusDialog fDialog;

    public GlobalVariableBlock(IStatusDialog fDialog) {
        this.fDialog = fDialog;
    }

    public void createControlsIn(Composite parent) {
        Font font = parent.getFont();
        this.fVariablesViewer = new TreeViewer(parent);
        GridData gd = new GridData(1808);
        gd.heightHint = 6;
        this.fVariablesViewer.getControl().setLayoutData((Object)gd);
        this.fContentProvider = new GlobalVariableContentProvider();
        this.fVariablesViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fVariablesViewer.setLabelProvider(this.getLabelProvider());
        this.fVariablesViewer.setInput((Object)this);
        this.fVariablesViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = new Composite(parent, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.fAddButton = this.createPushButton(pathButtonComp, TclInterpreterMessages.GlobalVariableBlock_Add);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fEditButton = this.createPushButton(pathButtonComp, TclInterpreterMessages.GlobalVariableBlock_Edit);
        this.fEditButton.addSelectionListener((SelectionListener)this);
        this.fRemoveButton = this.createPushButton(pathButtonComp, TclInterpreterMessages.GlobalVariableBlock_Remove);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.setButtonLayoutData(button);
        return button;
    }

    public void update() {
        GlobalVariableEntry[] vars;
        this.updateButtons();
        IStatus status = Status.OK_STATUS;
        GlobalVariableEntry[] globalVariableEntryArray = vars = this.fContentProvider.getVariables();
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            GlobalVariableEntry var = globalVariableEntryArray[n2];
            if (var.getValue() == null || var.getValue().length() == 0) {
                status = new StatusInfo(4, TclInterpreterMessages.GlobalVariableBlock_ErrorNoValue);
                break;
            }
            ++n2;
        }
        this.updateDialogStatus(status);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fRemoveButton) {
            this.fContentProvider.remove(this.fVariablesViewer.getStructuredSelection().toList());
        } else if (source == this.fAddButton) {
            this.handleAdd();
        } else if (source == this.fEditButton) {
            this.edit((IStructuredSelection)this.fVariablesViewer.getStructuredSelection());
        }
        this.update();
    }

    private void edit(IStructuredSelection selection) {
        GlobalVariableEntry var = (GlobalVariableEntry)selection.getFirstElement();
        if (var == null) {
            return;
        }
        MultipleInputDialog dialog = new MultipleInputDialog(this.fDialog.getShell(), TclInterpreterMessages.GlobalVariableBlock_EditTitle);
        dialog.addTextField(NAME_LABEL, var.getName(), false);
        dialog.addVariablesField(VALUE_LABEL, var.getValue(), true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        String value = dialog.getStringValue(VALUE_LABEL);
        if (!var.getName().equals(name)) {
            GlobalVariableEntry newVar = new GlobalVariableEntry(name, value);
            if (this.fContentProvider.replaceVariable(newVar, var)) {
                this.fVariablesViewer.refresh();
                this.fVariablesViewer.setSelection((ISelection)new StructuredSelection((Object)newVar), true);
            }
        } else {
            var.setValue(value);
            this.fVariablesViewer.refresh(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void handleAdd() {
        GlobalVariableEntry newVar = this.add();
        if (newVar != null) {
            this.fContentProvider.replaceVariable(newVar, null);
            this.fVariablesViewer.setSelection((ISelection)new StructuredSelection((Object)newVar), true);
            this.fVariablesViewer.refresh();
            this.update();
        }
    }

    private GlobalVariableEntry add() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.fDialog.getShell(), TclInterpreterMessages.GlobalVariableBlock_AddTitle);
        dialog.addTextField(NAME_LABEL, null, false);
        dialog.addVariablesField(VALUE_LABEL, null, true);
        if (dialog.open() != 0) {
            return null;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        String value = dialog.getStringValue(VALUE_LABEL);
        if (name != null && value != null && name.length() > 0 && value.length() > 0) {
            return new GlobalVariableEntry(name.trim(), value.trim());
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        ITreeSelection selection = this.fVariablesViewer.getStructuredSelection();
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        this.fEditButton.setEnabled(selection.size() == 1);
    }

    public void setValues(EMap<String, VariableValue> vars) {
        ArrayList<GlobalVariableEntry> list = new ArrayList<GlobalVariableEntry>();
        for (Map.Entry entry : vars.entrySet()) {
            if (entry.getValue() == null) continue;
            list.add(new GlobalVariableEntry((String)entry.getKey(), ((VariableValue)entry.getValue()).getValue()));
        }
        this.fContentProvider.setVariables(list.toArray(new GlobalVariableEntry[list.size()]));
        this.update();
    }

    public EMap<String, VariableValue> getValues() {
        BasicEMap map = new BasicEMap();
        GlobalVariableEntry[] globalVariableEntryArray = this.fContentProvider.getVariables();
        int n = globalVariableEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            GlobalVariableEntry var = globalVariableEntryArray[n2];
            VariableValue value = TclPackagesFactory.eINSTANCE.createVariableValue();
            value.setValue(var.getValue());
            map.put((Object)var.getName(), (Object)value);
            ++n2;
        }
        return map;
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new GlobalVariableLabelProvider();
    }

    protected void updateDialogStatus(IStatus status) {
        this.fDialog.updateStatusLine();
    }

    protected void setButtonLayoutData(Button button) {
        this.fDialog.setButtonLayoutData(button);
    }

    public static boolean equalsEMap(EMap<String, VariableValue> a, EMap<String, VariableValue> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry entry : a.entrySet()) {
            VariableValue value = (VariableValue)b.get(entry.getKey());
            if (value == null) {
                return false;
            }
            if (EcoreUtil.equals((EObject)((EObject)entry.getValue()), (EObject)value)) continue;
            return false;
        }
        return true;
    }
}

