/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.ui.templates.core.processes;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.internal.ui.Activator;
import org.eclipse.embedcdt.templates.core.Utils;
import org.eclipse.embedcdt.ui.EclipseUiUtils;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ConditionalRunCommandUi
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String[] cmdArray;
        String shell;
        String joinedArgs;
        String substitutedArgs;
        IProject projectHandle = null;
        String condition = null;
        String cwd = null;
        String command = null;
        String[] cmdArgs = new String[]{};
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (argName.equals("projectName")) {
                projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(arg.getSimpleValue());
            } else if (argName.equals("condition")) {
                condition = arg.getSimpleValue();
            } else if (argName.equals("cwd")) {
                cwd = arg.getSimpleValue();
            } else if (argName.equals("command")) {
                command = arg.getSimpleValue();
            } else if (argName.equals("args")) {
                cmdArgs = arg.getSimpleArrayValue();
            }
            ++n2;
        }
        if (projectHandle == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "projectName not specified"));
        }
        if (cwd == null || cwd.isEmpty()) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "path not specified"));
        }
        if (command == null || command.isEmpty()) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, "path not specified"));
        }
        if (!Utils.isConditionSatisfied(condition)) {
            return;
        }
        String substitutedCommand = EclipseUtils.performStringSubstitution((String)command);
        if (substitutedCommand == null) {
            substitutedCommand = command;
        }
        if ((substitutedArgs = EclipseUtils.performStringSubstitution((String)(joinedArgs = StringUtils.join((String[])cmdArgs, (String)" ")))) == null) {
            substitutedArgs = joinedArgs;
        }
        if (EclipseUtils.isWindows()) {
            shell = System.getenv("ComSpec");
            if (shell == null) {
                shell = "cmd.exe";
            }
            cmdArray = new String[]{shell, "/d", "/s", "/c", String.valueOf(substitutedCommand) + " " + substitutedArgs};
        } else {
            shell = System.getenv("SHELL");
            if (shell == null) {
                shell = "/bin/sh";
            }
            cmdArray = new String[]{shell, "-i", "-c", String.valueOf(substitutedCommand) + " " + substitutedArgs};
        }
        if (Activator.getInstance().isDebugging()) {
            Map<String, String> env = System.getenv();
            for (String envName : env.keySet()) {
                System.out.format("%s=%s%n", envName, env.get(envName));
            }
        }
        final String[] envp = null;
        String substitutedCwd = EclipseUtils.performStringSubstitution((String)cwd);
        if (substitutedCwd == null) {
            substitutedCwd = cwd;
        }
        final File dir = new File(substitutedCwd);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("cwd: " + dir);
        }
        System.out.println("> " + StringUtils.join((String[])cmdArray, (String)" "));
        Activator.log("cwd: " + dir);
        Activator.log("> " + StringUtils.join((String[])cmdArray, (String)" "));
        final String dialogMessage = String.valueOf(substitutedCommand) + " " + substitutedArgs;
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(EclipseUiUtils.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InterruptedException {
                pm.beginTask(dialogMessage, 3);
                try {
                    try {
                        String line;
                        BufferedReader reader = null;
                        pm.worked(1);
                        Process process = ProcessFactory.getFactory().exec(cmdArray, envp, dir);
                        pm.worked(1);
                        reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        ArrayList<String> outputLines = new ArrayList<String>();
                        while ((line = reader.readLine()) != null) {
                            outputLines.add(line);
                        }
                        for (String l : outputLines) {
                            System.out.println(l);
                        }
                        reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        ArrayList<String> errorLines = new ArrayList<String>();
                        while ((line = reader.readLine()) != null) {
                            errorLines.add(line);
                        }
                        if (!errorLines.isEmpty()) {
                            Activator.log(((Object)errorLines).toString());
                        }
                        process.destroy();
                        pm.worked(1);
                        if (process.exitValue() != 0) {
                            for (String l : errorLines) {
                                System.out.println(l);
                            }
                            System.out.println("exit (" + process.exitValue() + ")");
                            Activator.log("exit (" + process.exitValue() + ")");
                            throw new InterruptedException(((Object)errorLines).toString());
                        }
                    }
                    catch (IOException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
                finally {
                    pm.done();
                }
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException e1) {
            throw new ProcessFailureException(e1.getMessage());
        }
        catch (InterruptedException e1) {
            throw new ProcessFailureException(e1.getMessage());
        }
        try {
            projectHandle.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

