/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.escstring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Justification implements Enumerator
{
    CENTERED(0, "CENTERED", "\\n"),
    LEFT(1, "LEFT", "\\l"),
    RIGHT(2, "RIGHT", "\\r");

    public static final int CENTERED_VALUE = 0;
    public static final int LEFT_VALUE = 1;
    public static final int RIGHT_VALUE = 2;
    private static final Justification[] VALUES_ARRAY;
    public static final List<Justification> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Justification[]{CENTERED, LEFT, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Justification get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Justification result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Justification getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Justification result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Justification get(int value) {
        switch (value) {
            case 0: {
                return CENTERED;
            }
            case 1: {
                return LEFT;
            }
            case 2: {
                return RIGHT;
            }
        }
        return null;
    }

    private Justification(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

