/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.query.AbstractTraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.internal.IPredicateMatcher;
import org.eclipse.jst.jsf.common.metadata.query.internal.SearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitQuerySpecVisitor
extends AbstractTraitQueryVisitor {
    private List<Trait> _traitResults;
    private Collection<Entity> _entities;
    private IPredicateMatcher<Trait> _matcher;
    private SearchControl _control;
    private boolean _stop;

    public TraitQuerySpecVisitor(Collection<Entity> entities, IPredicateMatcher<Trait> traitMatcher) {
        this(entities, traitMatcher, new SearchControl());
    }

    public TraitQuerySpecVisitor(Collection<Entity> entities, IPredicateMatcher<Trait> traitMatcher, SearchControl control) {
        this._entities = entities;
        this._matcher = traitMatcher;
        this._traitResults = new ArrayList<Trait>();
        this._control = control;
    }

    public IResultSet<Trait> findTraits() throws MetaDataException {
        this._matcher.reset();
        if (this._entities != null && this._entities.size() > 0) {
            block0: for (Entity entity : this._entities) {
                for (Trait trait : entity.getTraits()) {
                    trait.accept(this);
                    this.checkShouldStopVisiting();
                    if (this.stopVisiting()) break block0;
                }
            }
        }
        return new SimpleResultSet<Trait>(this._traitResults);
    }

    @Override
    public boolean stopVisiting() {
        return this._stop;
    }

    private void checkShouldStopVisiting() {
        if (!this._stop && this._control.getCountLimit() == this._traitResults.size() && this._control.getCountLimit() != -1) {
            this._stop = true;
        }
    }

    @Override
    public void visit(Trait trait) {
        IPredicateMatcher.MATCH match = this._matcher.matches(trait);
        if (match == IPredicateMatcher.MATCH.FULLY) {
            this._traitResults.add(trait);
        }
    }
}

