/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.ServerMessageHandler;
import org.eclipse.lsp4e.progress.LSPProgressManager;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowDocumentParams;
import org.eclipse.lsp4j.ShowDocumentResult;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.PlatformUI;

public class LanguageClientImpl
implements LanguageClient {
    private Consumer<PublishDiagnosticsParams> diagnosticConsumer;
    private final LSPProgressManager progressManager = new LSPProgressManager();
    private LanguageServer server;
    private LanguageServerWrapper wrapper;

    public final void connect(LanguageServer server, LanguageServerWrapper wrapper) {
        this.server = server;
        this.wrapper = wrapper;
        this.progressManager.connect(server);
    }

    protected void setDiagnosticsConsumer(@NonNull Consumer<PublishDiagnosticsParams> diagnosticConsumer) {
        this.diagnosticConsumer = diagnosticConsumer;
    }

    protected final LanguageServer getLanguageServer() {
        return this.server;
    }

    public CompletableFuture<List<Object>> configuration(ConfigurationParams configurationParams) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public void telemetryEvent(Object object) {
    }

    public final CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        return ServerMessageHandler.showMessageRequest(this.wrapper, requestParams);
    }

    public final void showMessage(MessageParams messageParams) {
        ServerMessageHandler.showMessage(this.wrapper.serverDefinition.label, messageParams);
    }

    public final void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        this.diagnosticConsumer.accept(diagnostics);
    }

    public final void logMessage(MessageParams message) {
        CompletableFuture.runAsync(() -> ServerMessageHandler.logMessage(this.wrapper, message));
    }

    public CompletableFuture<Void> createProgress(WorkDoneProgressCreateParams params) {
        return this.progressManager.createProgress(params);
    }

    public void notifyProgress(ProgressParams params) {
        this.progressManager.notifyProgress(params);
    }

    public final CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(final ApplyWorkspaceEditParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Job job = new Job(Messages.serverEdit){

                public IStatus run(IProgressMonitor monitor) {
                    LSPEclipseUtils.applyWorkspaceEdit(params.getEdit(), params.getLabel());
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            try {
                job.join();
                return new ApplyWorkspaceEditResponse(true);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
                return new ApplyWorkspaceEditResponse(false);
            }
        });
    }

    public CompletableFuture<Void> registerCapability(RegistrationParams params) {
        return CompletableFuture.runAsync(() -> this.wrapper.registerCapability(params));
    }

    public CompletableFuture<Void> unregisterCapability(UnregistrationParams params) {
        return CompletableFuture.runAsync(() -> this.wrapper.unregisterCapability(params));
    }

    public CompletableFuture<List<WorkspaceFolder>> workspaceFolders() {
        return CompletableFuture.completedFuture(LSPEclipseUtils.getWorkspaceFolders());
    }

    public CompletableFuture<ShowDocumentResult> showDocument(ShowDocumentParams params) {
        return CompletableFuture.supplyAsync(() -> {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                Location location = new Location(params.getUri(), params.getSelection());
                LSPEclipseUtils.openInEditor(location);
            });
            return new ShowDocumentResult(true);
        });
    }
}

