/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowser;
import org.eclipse.pde.internal.runtime.registry.model.Bundle;
import org.eclipse.pde.internal.runtime.registry.model.Extension;
import org.eclipse.pde.internal.runtime.registry.model.ExtensionPoint;
import org.eclipse.pde.internal.runtime.registry.model.ModelChangeDelta;
import org.eclipse.pde.internal.runtime.registry.model.ModelChangeListener;
import org.eclipse.pde.internal.runtime.registry.model.ModelObject;
import org.eclipse.pde.internal.runtime.registry.model.ServiceName;
import org.eclipse.pde.internal.runtime.registry.model.ServiceRegistration;
import org.eclipse.ui.progress.UIJob;

public class RegistryBrowserModelChangeListener
implements ModelChangeListener {
    private RegistryBrowser fRegistryBrowser;

    public RegistryBrowserModelChangeListener(RegistryBrowser registryBrowser) {
        this.fRegistryBrowser = registryBrowser;
    }

    @Override
    public void modelChanged(ModelChangeDelta[] delta) {
        UIJob.create((String)"Updating Registry", monitor -> {
            this.update(delta);
            return Status.OK_STATUS;
        }).schedule();
    }

    private boolean topLevelElement(Object object) {
        switch (this.fRegistryBrowser.getGroupBy()) {
            case 0: {
                return object instanceof Bundle;
            }
            case 1: {
                return object instanceof ExtensionPoint;
            }
            case 2: {
                return object instanceof ServiceName;
            }
        }
        return false;
    }

    private Object getTopLevelElement(Object object) {
        switch (this.fRegistryBrowser.getGroupBy()) {
            case 0: {
                if (object instanceof Bundle) {
                    return object;
                }
                if (object instanceof ExtensionPoint) {
                    ExtensionPoint ext = (ExtensionPoint)object;
                    return ext.getContributor();
                }
                if (object instanceof Extension) {
                    Extension ext = (Extension)object;
                    return ext.getContributor();
                }
                if (!(object instanceof ServiceRegistration)) break;
                ServiceRegistration reg = (ServiceRegistration)object;
                Bundle[] bundles = reg.getUsingBundles();
                if (bundles.length == 0) {
                    return reg.getBundle();
                }
                Object[] result = new Object[bundles.length + 1];
                result[0] = reg.getBundle();
                System.arraycopy(bundles, 0, result, 1, bundles.length);
                return result;
            }
            case 1: {
                if (object instanceof ExtensionPoint) {
                    return object;
                }
                if (!(object instanceof Extension)) break;
                Extension ext = (Extension)object;
                return ext.getExtensionPoint();
            }
            case 2: {
                if (object instanceof ServiceRegistration) {
                    ServiceRegistration service = (ServiceRegistration)object;
                    return service.getName();
                }
                if (!(object instanceof Bundle)) break;
                return ((Bundle)object).getServicesInUse();
            }
        }
        return null;
    }

    private void refreshTopLevelElements(Object object) {
        Object topLevelElement = this.getTopLevelElement(object);
        if (topLevelElement == null) {
            return;
        }
        if (topLevelElement.getClass().isArray()) {
            Object[] array = (Object[])topLevelElement;
            this.fRegistryBrowser.refresh(array);
        } else {
            this.fRegistryBrowser.refresh(topLevelElement);
        }
    }

    protected void update(ModelChangeDelta[] deltas) {
        ModelChangeDelta[] modelChangeDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            ModelChangeDelta delta = modelChangeDeltaArray[n2];
            ModelObject object = delta.getModelObject();
            int flag = delta.getFlag();
            switch (flag) {
                case 0: {
                    if (this.topLevelElement(object)) {
                        this.fRegistryBrowser.add(object);
                        break;
                    }
                    this.refreshTopLevelElements(object);
                    break;
                }
                case 2: {
                    if (this.topLevelElement(object)) {
                        this.fRegistryBrowser.remove(object);
                        break;
                    }
                    this.refreshTopLevelElements(object);
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    if (this.topLevelElement(object)) {
                        this.fRegistryBrowser.refresh(object);
                        break;
                    }
                    this.refreshTopLevelElements(object);
                }
            }
            ++n2;
        }
    }
}

