/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBlock;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IBlock;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IControlFlowGraph;

public class MPISSA {
    protected ICallGraph cg_;
    protected MPICallGraphNode currentFunc_;
    protected Hashtable<String, List<IBlock>> defTable_;
    protected IControlFlowGraph cfg_;

    public MPISSA(ICallGraph cg) {
        this.cg_ = cg;
    }

    public void run() {
        ICallGraphNode n = this.cg_.botEntry();
        while (n != null) {
            MPICallGraphNode node = (MPICallGraphNode)n;
            if (node.marked) {
                this.currentFunc_ = node;
                this.cfg_ = node.getCFG();
                this.defTable_ = node.getDefTable();
                this.domFrontier();
                this.placePHI();
                ExitBlockPhi ebp = new ExitBlockPhi();
                ebp.run();
            }
            n = n.botNext();
        }
    }

    public void domFrontier() {
        IBlock bx = this.cfg_.getEntry();
        while (bx != null) {
            MPIBlock x = (MPIBlock)bx;
            ArrayList<IBlock> DF = new ArrayList<IBlock>();
            IBlock by = this.cfg_.getEntry();
            while (by != null) {
                MPIBlock y = (MPIBlock)by;
                for (MPIBlock pred : y.getPreds()) {
                    if (!pred.getDOM().contains((Object)x) || y.getDOM().contains((Object)x) && x != y || DF.contains((Object)y)) continue;
                    DF.add((IBlock)y);
                }
                by = by.topNext();
            }
            x.setDF(DF);
            bx = bx.topNext();
        }
    }

    public void placePHI() {
        int iterCount = 0;
        IBlock b = this.cfg_.getEntry();
        while (b != null) {
            MPIBlock block = (MPIBlock)b;
            block.hasAlready = 0;
            block.work = 0;
            b = b.topNext();
        }
        LinkedList<MPIBlock> W = new LinkedList<MPIBlock>();
        Enumeration<String> e = this.defTable_.keys();
        while (e.hasMoreElements()) {
            String var = e.nextElement();
            ++iterCount;
            List<IBlock> defs = this.defTable_.get(var);
            for (MPIBlock mPIBlock : defs) {
                mPIBlock.work = iterCount;
                W.add(mPIBlock);
            }
            while (!W.isEmpty()) {
                MPIBlock next = (MPIBlock)((Object)W.remove());
                for (MPIBlock mPIBlock : next.getDF()) {
                    if (mPIBlock.hasAlready >= iterCount) continue;
                    if (mPIBlock.getCond() == null && mPIBlock != this.cfg_.getExit()) {
                        System.out.println("Error: phi Node has no condition!" + this.currentFunc_.getFuncName() + " Block " + mPIBlock.getID());
                    }
                    mPIBlock.setPhi();
                    if (!mPIBlock.getDef().contains(var)) {
                        mPIBlock.getDef().add(var);
                    }
                    if (mPIBlock.getUse().contains(var) && !mPIBlock.getUsedPhiVar().contains(var)) {
                        mPIBlock.getUsedPhiVar().add(var);
                    }
                    if (!mPIBlock.getPhiVar().contains(var)) {
                        mPIBlock.getPhiVar().add(var);
                    }
                    if (!defs.contains((Object)mPIBlock)) {
                        defs.add((IBlock)mPIBlock);
                    }
                    this.updateDefTable((IBlock)mPIBlock, var);
                    mPIBlock.hasAlready = iterCount;
                    if (mPIBlock.work >= iterCount) continue;
                    mPIBlock.work = iterCount;
                    W.add(mPIBlock);
                }
            }
        }
        IBlock b2 = this.cfg_.getEntry();
        while (b2 != null) {
            MPIBlock block = (MPIBlock)b2;
            if (block.hasPhi()) {
                for (String var : block.getPhiVar()) {
                    if (block.getUse().contains(var)) continue;
                    block.getUse().add(var);
                }
            }
            b2 = b2.topNext();
        }
    }

    protected void updateDefTable(IBlock block, String var) {
        List<IBlock> list = this.defTable_.get(var);
        if (list == null) {
            System.out.print("Error in SSA!");
            return;
        }
        if (!list.contains(block)) {
            list.add(block);
        }
    }

    class ExitBlockPhi
    extends ASTVisitor {
        ExitBlockPhi() {
        }

        public void run() {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            MPISSA.this.currentFunc_.getFuncDef().accept((ASTVisitor)this);
        }

        public int visit(IASTStatement stmt) {
            MPIBlock condblock = null;
            if (stmt instanceof IASTDoStatement) {
                IASTDoStatement doS = (IASTDoStatement)stmt;
                condblock = (MPIBlock)MPISSA.this.cfg_.getBlock(doS.getCondition(), stmt);
            } else if (stmt instanceof IASTForStatement) {
                IASTForStatement forS = (IASTForStatement)stmt;
                condblock = (MPIBlock)MPISSA.this.cfg_.getBlock(forS.getConditionExpression(), stmt);
            } else if (stmt instanceof IASTWhileStatement) {
                IASTWhileStatement whileS = (IASTWhileStatement)stmt;
                condblock = (MPIBlock)MPISSA.this.cfg_.getBlock(whileS.getCondition(), stmt);
            } else {
                return 3;
            }
            MPIBlock exitblock = null;
            for (MPIBlock succ : condblock.getSuccs()) {
                if (succ.getType() != 5) continue;
                exitblock = succ;
            }
            exitblock.setPhi();
            for (String phivar : condblock.getPhiVar()) {
                if (!exitblock.getDef().contains(phivar)) {
                    exitblock.getDef().add(phivar);
                }
                if (!exitblock.getUse().contains(phivar)) {
                    exitblock.getUse().add(phivar);
                }
                if (!exitblock.getPhiVar().contains(phivar)) {
                    exitblock.getPhiVar().add(phivar);
                }
                MPISSA.this.updateDefTable((IBlock)exitblock, phivar);
            }
            return 3;
        }
    }
}

