/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.fortran.editorHelp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpResource;
import org.eclipse.photran.ui.IFortranAPIHelpProvider;
import org.eclipse.ptp.pldt.mpi.core.MpiPlugin;
import org.eclipse.ptp.pldt.mpi.fortran.MPIFortranPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MpiFortranHelpProvider
implements IFortranAPIHelpProvider {
    private final Map<String, String> fNameToCname;

    public MpiFortranHelpProvider() {
        Map<String, String> fNameToCname;
        URL fileURL = FileLocator.find((Bundle)Platform.getBundle((String)MpiPlugin.getPluginId()), (IPath)new Path("mpiref.xml"), null);
        try {
            fNameToCname = MpiFortranHelpProvider.parseDOM(fileURL.openStream());
        }
        catch (IOException e) {
            MPIFortranPlugin.log(e);
            fNameToCname = Collections.emptyMap();
        }
        this.fNameToCname = fNameToCname;
    }

    public static Map<String, String> parseDOM(InputStream xmlIn) {
        HashMap<String, String> fNameToCname = new HashMap<String, String>();
        if (xmlIn != null) {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse(xmlIn);
                NodeList functionList = document.getElementsByTagName("function");
                int i = 0;
                while (i < functionList.getLength()) {
                    Node func = functionList.item(i);
                    NodeList child = func.getChildNodes();
                    String fname = null;
                    String cname = null;
                    int j = 0;
                    while (j < child.getLength()) {
                        Node sub = child.item(j);
                        if (sub.getNodeName().equals("cname")) {
                            cname = sub.getTextContent();
                        } else if (sub.getNodeName().equals("fname")) {
                            fname = sub.getTextContent();
                        }
                        ++j;
                    }
                    if (fname != null && cname != null) {
                        fNameToCname.put(fname.toUpperCase(), cname);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                MPIFortranPlugin.log(e);
            }
        }
        return fNameToCname;
    }

    public IHelpResource[] getHelpResources(ITextEditor fortranEditor, String name, String precedingText) {
        final String fname = name.toUpperCase();
        if (this.fNameToCname.containsKey(fname)) {
            return new IHelpResource[]{new IHelpResource(){

                public String getHref() {
                    return String.format("/%s/html/%s.html", MpiPlugin.getPluginId(), MpiFortranHelpProvider.this.fNameToCname.get(fname));
                }

                public String getLabel() {
                    return fname;
                }
            }};
        }
        return null;
    }
}

