/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.internal.rm.jaxb.core.JAXBCoreConstants;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JAXBCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.rm.jaxb.core";
    private static JAXBCorePlugin fPlugin;

    public JAXBCorePlugin() {
        fPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace().addSaveParticipant(JAXBCorePlugin.getUniqueIdentifier(), new ISaveParticipant(){

            public void doneSaving(ISaveContext saveContext) {
            }

            public void prepareToSave(ISaveContext saveContext) throws CoreException {
            }

            public void rollback(ISaveContext saveContext) {
            }

            public void saving(ISaveContext saveContext) throws CoreException {
                Preferences.savePreferences((String)JAXBCorePlugin.getUniqueIdentifier());
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        try {
            Preferences.savePreferences((String)JAXBCorePlugin.getUniqueIdentifier());
            ResourcesPlugin.getWorkspace().removeSaveParticipant(JAXBCorePlugin.getUniqueIdentifier());
        }
        finally {
            super.stop(context);
            fPlugin = null;
        }
    }

    public static CoreException coreErrorException(String message) {
        return new CoreException((IStatus)new Status(4, JAXBCorePlugin.getDefault().getBundle().getSymbolicName(), message));
    }

    public static CoreException coreErrorException(String message, Throwable t) {
        return new CoreException((IStatus)new Status(4, JAXBCorePlugin.getDefault().getBundle().getSymbolicName(), message, t));
    }

    public static JAXBCorePlugin getDefault() {
        return fPlugin;
    }

    public static URL getResource(String resource) throws IOException {
        URL url = null;
        if (JAXBCorePlugin.getDefault() != null) {
            Bundle bundle = JAXBCorePlugin.getDefault().getBundle();
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(String.valueOf(JAXBCoreConstants.PATH_SEP) + resource), null);
        } else {
            url = new File(resource).toURI().toURL();
        }
        return url;
    }

    public static String getUniqueIdentifier() {
        if (JAXBCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return JAXBCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        JAXBCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        JAXBCorePlugin.log((IStatus)new Status(4, JAXBCorePlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(Throwable e) {
        JAXBCorePlugin.log((IStatus)new Status(4, JAXBCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }
}

