/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.helper.task.ModelOperationManagerDescriptor;
import org.eclipse.sirius.business.internal.helper.task.ModelOperationManagerRegistry;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.ChangeContextTask;
import org.eclipse.sirius.business.internal.helper.task.operations.CreateInstanceTask;
import org.eclipse.sirius.business.internal.helper.task.operations.ExternalJavaActionTask;
import org.eclipse.sirius.business.internal.helper.task.operations.ForTask;
import org.eclipse.sirius.business.internal.helper.task.operations.IfTask;
import org.eclipse.sirius.business.internal.helper.task.operations.LetTask;
import org.eclipse.sirius.business.internal.helper.task.operations.MoveElementTask;
import org.eclipse.sirius.business.internal.helper.task.operations.RemoveElementTask;
import org.eclipse.sirius.business.internal.helper.task.operations.SetValueTask;
import org.eclipse.sirius.business.internal.helper.task.operations.SwitchTask;
import org.eclipse.sirius.business.internal.helper.task.operations.UnexecutableOperationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.UnsetTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ChangeContext;
import org.eclipse.sirius.viewpoint.description.tool.ContainerModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.DeleteView;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionCall;
import org.eclipse.sirius.viewpoint.description.tool.For;
import org.eclipse.sirius.viewpoint.description.tool.If;
import org.eclipse.sirius.viewpoint.description.tool.Let;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.MoveElement;
import org.eclipse.sirius.viewpoint.description.tool.RemoveElement;
import org.eclipse.sirius.viewpoint.description.tool.SetObject;
import org.eclipse.sirius.viewpoint.description.tool.SetValue;
import org.eclipse.sirius.viewpoint.description.tool.Switch;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.tool.Unset;

public class ModelOperationToTask
implements Function<ModelOperation, ICommandTask> {
    private final ModelAccessor extPackage;
    private final UICallBack uiCallback;
    private final Session session;
    private final IInterpreter interpreter;
    private final CommandContext context;

    public ModelOperationToTask(ModelAccessor extPackage, UICallBack uiCallback, Session session, CommandContext context) {
        this.extPackage = extPackage;
        this.uiCallback = uiCallback;
        this.session = session;
        this.interpreter = session.getInterpreter();
        this.context = context;
    }

    public AbstractOperationTask createTask(ModelOperation op) {
        Option<EObject> opt;
        AbstractOperationTask task = null;
        Option<? extends AbstractCommandTask> optionalDialectTask = DialectManager.INSTANCE.createTask(this.context, this.extPackage, op, this.session, this.uiCallback);
        if (optionalDialectTask.some() && optionalDialectTask.get() instanceof AbstractOperationTask) {
            task = (AbstractOperationTask)optionalDialectTask.get();
        } else if (op instanceof CreateInstance) {
            task = new CreateInstanceTask(this.context, this.extPackage, (CreateInstance)op, this.interpreter);
        } else if (op instanceof SetValue) {
            task = new SetValueTask(this.context, this.extPackage, (SetValue)op, this.interpreter);
        } else if (op instanceof SetObject) {
            task = new SetValueTask(this.context, this.extPackage, (SetObject)op, this.interpreter);
        } else if (op instanceof ChangeContext) {
            task = new ChangeContextTask(this.context, this.extPackage, (ChangeContext)op, this.interpreter);
        } else if (op instanceof MoveElement) {
            task = new MoveElementTask(this.context, this.extPackage, (MoveElement)op, this.interpreter);
        } else if (op instanceof RemoveElement) {
            task = new RemoveElementTask(this.context, this.extPackage, (RemoveElement)op, this.interpreter);
        } else if (op instanceof For) {
            task = new ForTask(this.context, this.extPackage, (For)op, this.interpreter, this.uiCallback);
        } else if (op instanceof Unset) {
            task = new UnsetTask(this.context, this.extPackage, (Unset)op, this.interpreter);
        } else if (op instanceof If) {
            task = new IfTask(this.context, this.extPackage, (If)op, this.interpreter);
        } else if (op instanceof DeleteView) {
            task = new RemoveElementTask(this.extPackage, this.context, (DeleteView)op, this.interpreter);
        } else if (op instanceof ExternalJavaAction) {
            task = new ExternalJavaActionTask(this.context, this.extPackage, (ExternalJavaAction)op, this.interpreter, this.uiCallback);
        } else if (op instanceof ExternalJavaActionCall) {
            task = new ExternalJavaActionTask(this.context, this.extPackage, ((ExternalJavaActionCall)op).getAction(), this.interpreter, this.uiCallback);
        } else if (op instanceof Switch) {
            task = new SwitchTask(this.context, this.extPackage, (Switch)op, this.session, this.uiCallback);
        } else if (op instanceof Let) {
            task = new LetTask(this.context, this.extPackage, (Let)op, this.interpreter);
        }
        if (task == null) {
            Optional<Object> optionalTask = Optional.empty();
            Iterator<ModelOperationManagerDescriptor> iterator = ModelOperationManagerRegistry.getRegisteredExtensions().iterator();
            while (iterator.hasNext() && !optionalTask.isPresent()) {
                ModelOperationManagerDescriptor descriptor = iterator.next();
                optionalTask = descriptor.getModelOperationManager().createTask(op, this.extPackage, this.uiCallback, this.session, this.interpreter, this.context);
            }
            if (!optionalTask.isPresent()) {
                task = UnexecutableOperationTask.getInstance();
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", MessageFormat.format(Messages.ModelOperationToTask_cannotCreateTaskWarningMsg, op.eClass().getName())));
            } else if (optionalTask.isPresent() && optionalTask.get() instanceof AbstractOperationTask) {
                task = (AbstractOperationTask)optionalTask.get();
            }
        }
        if ((opt = new EObjectQuery((EObject)op).getFirstAncestorOfType(ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION)).some()) {
            task.setSourceTool((AbstractToolDescription)opt.get());
        }
        return task;
    }

    public ICommandTask apply(ModelOperation from) {
        AbstractOperationTask result = this.createTask(from);
        if (from instanceof ContainerModelOperation) {
            result.getChildrenTasks().addAll(Collections2.transform((Collection)((ContainerModelOperation)from).getSubModelOperations(), (Function)this));
        }
        return result;
    }
}

