/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.emf.common.EMFPlugin;

public class QueryCache {
    public static final Object NO_CACHED_RESULT = new Object();
    private static final Object INVALID_QUERY_RESULT = new Object();
    private static final Object NULL_QUERY_RESULT = new Object();
    private final Object invalid;
    private final Map<Query, Map<Object, Object>> queryResults = new HashMap<Query, Map<Object, Object>>();

    public QueryCache(Object invalid) {
        this.invalid = invalid;
    }

    public static boolean isCachedResult(Object result) {
        return result != NO_CACHED_RESULT;
    }

    public static boolean isInvalid(Object result) {
        return result == INVALID_QUERY_RESULT;
    }

    public static boolean isNull(Object result) {
        return result == NULL_QUERY_RESULT;
    }

    public void cacheResult(Query query, List<Object> params, Object result) {
        Map<Object, Object> cache;
        if (EMFPlugin.IS_ECLIPSE_RUNNING && !AcceleoPreferences.isQueryCacheEnabled()) {
            return;
        }
        Object key = params;
        if (params.size() == 1) {
            key = params.get(0);
        }
        if ((cache = this.queryResults.get(query)) == null) {
            cache = new HashMap<Object, Object>();
            this.queryResults.put(query, cache);
        }
        if (result == this.invalid) {
            cache.put(key, INVALID_QUERY_RESULT);
        } else if (result == null) {
            cache.put(key, NULL_QUERY_RESULT);
        } else {
            cache.put(key, result);
        }
    }

    public Object getResult(Query query, List<Object> params) {
        Map<Object, Object> cache;
        Object result;
        if (EMFPlugin.IS_ECLIPSE_RUNNING && !AcceleoPreferences.isQueryCacheEnabled() || !this.queryResults.containsKey(query)) {
            return NO_CACHED_RESULT;
        }
        Object key = params;
        if (params.size() == 1) {
            key = params.get(0);
        }
        if ((result = (cache = this.queryResults.get(query)).get(key)) == null) {
            result = NO_CACHED_RESULT;
        }
        return result;
    }
}

