/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.breakpoints;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IDsfBreakpointExtension;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.runtime.CoreException;

public class CBreakpointGdbThreadsFilterExtension
implements IDsfBreakpointExtension {
    private final Map<IRunControl.IContainerDMContext, Set<IRunControl.IExecutionDMContext>> fFilteredThreadsByTarget = Collections.synchronizedMap(new HashMap(1));

    public void initialize(ICBreakpoint breakpoint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRunControl.IContainerDMContext[] getTargetFilters() throws CoreException {
        Set<IRunControl.IContainerDMContext> set = this.fFilteredThreadsByTarget.keySet();
        Map<IRunControl.IContainerDMContext, Set<IRunControl.IExecutionDMContext>> map = this.fFilteredThreadsByTarget;
        synchronized (map) {
            return set.toArray(new IRunControl.IContainerDMContext[set.size()]);
        }
    }

    public IRunControl.IExecutionDMContext[] getThreadFilters(IRunControl.IContainerDMContext target) throws CoreException {
        Set<IRunControl.IExecutionDMContext> set = this.fFilteredThreadsByTarget.get(target);
        return set != null ? set.toArray(new IRunControl.IExecutionDMContext[set.size()]) : null;
    }

    public void removeTargetFilter(IRunControl.IContainerDMContext target) throws CoreException {
        this.fFilteredThreadsByTarget.remove(target);
    }

    public void removeThreadFilters(IRunControl.IExecutionDMContext[] threads) throws CoreException {
        IRunControl.IContainerDMContext target;
        Set<IRunControl.IExecutionDMContext> set;
        if (threads != null && threads.length > 0 && (set = this.fFilteredThreadsByTarget.get(target = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)threads[0], IRunControl.IContainerDMContext.class))) != null) {
            set.removeAll(Arrays.asList(threads));
            if (set.isEmpty()) {
                this.fFilteredThreadsByTarget.remove(target);
            }
        }
    }

    public void setTargetFilter(IRunControl.IContainerDMContext target) throws CoreException {
        this.fFilteredThreadsByTarget.put(target, null);
    }

    public void setThreadFilters(IRunControl.IExecutionDMContext[] threads) throws CoreException {
        if (threads != null && threads.length > 0) {
            IRunControl.IContainerDMContext target = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)threads[0], IRunControl.IContainerDMContext.class);
            this.fFilteredThreadsByTarget.put(target, new HashSet<IRunControl.IExecutionDMContext>(Arrays.asList(threads)));
        }
    }
}

