/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.fontname;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Variant implements Enumerator
{
    NORMAL(0, "NORMAL", ""),
    SMALL_CAPS(1, "SMALL_CAPS", "Small-Caps");

    public static final int NORMAL_VALUE = 0;
    public static final int SMALL_CAPS_VALUE = 1;
    private static final Variant[] VALUES_ARRAY;
    public static final List<Variant> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Variant[]{NORMAL, SMALL_CAPS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Variant get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Variant result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Variant getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Variant result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Variant get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return SMALL_CAPS;
            }
        }
        return null;
    }

    private Variant(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

