/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.wizards;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.CheckedTableSelectionDialog;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.Resources;
import org.eclipse.jdt.internal.junit.wizards.SuiteClassesContentProvider;
import org.eclipse.jdt.internal.junit.wizards.TestSuiteClassListRange;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class UpdateTestSuite
implements IObjectActionDelegate {
    private Shell fShell;
    private IPackageFragment fPack;
    private ICompilationUnit fTestSuite;
    private IMethod fSuiteMethod;
    private static boolean fEmptySelectionAllowed = false;
    private Object[] fSelectedTestCases;
    private boolean fIsJunit4;
    private boolean fIsJunit5;
    private IAnnotation fSuiteClasses;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        block13: {
            JavaElementLabelProvider lprovider = new JavaElementLabelProvider(18);
            SuiteClassesContentProvider cprovider = new SuiteClassesContentProvider(this.fIsJunit4, this.fIsJunit5);
            if (this.fIsJunit4) {
                IType testSuiteType = this.fTestSuite.findPrimaryType();
                this.fSuiteClasses = testSuiteType.getAnnotation("SuiteClasses");
                if (this.fSuiteClasses.exists()) {
                    this.openTestSelectionDialog((ILabelProvider)lprovider, cprovider, testSuiteType);
                } else {
                    this.noSuiteError();
                }
            } else if (this.fIsJunit5) {
                IType testSuiteType = this.fTestSuite.findPrimaryType();
                this.fSuiteClasses = testSuiteType.getAnnotation("SelectClasses");
                if (this.fSuiteClasses.exists()) {
                    this.openTestSelectionDialog((ILabelProvider)lprovider, cprovider, testSuiteType);
                } else {
                    this.noSuiteError();
                }
            } else {
                IType testSuiteType = this.fTestSuite.findPrimaryType();
                this.fSuiteMethod = testSuiteType.getMethod("suite", new String[0]);
                if (this.fSuiteMethod.exists()) {
                    try {
                        ISourceRange range = this.fSuiteMethod.getSourceRange();
                        IBuffer buf = this.fTestSuite.getBuffer();
                        String originalContent = buf.getText(range.getOffset(), range.getLength());
                        buf.close();
                        if (UpdateTestSuite.getTestSuiteClassListRange(originalContent) != null) {
                            this.openTestSelectionDialog((ILabelProvider)lprovider, cprovider, testSuiteType);
                            break block13;
                        }
                        this.cannotUpdateSuiteError();
                    }
                    catch (JavaModelException e) {
                        JUnitPlugin.log(e);
                    }
                } else {
                    this.noSuiteError();
                }
            }
        }
    }

    private void openTestSelectionDialog(ILabelProvider lprovider, SuiteClassesContentProvider cprovider, IType testSuiteType) {
        CheckedTableSelectionDialog dialog = new CheckedTableSelectionDialog(this.fShell, lprovider, cprovider);
        dialog.setValidator(new UpdateAllTestsValidator());
        dialog.setTitle(WizardMessages.UpdateAllTests_title);
        dialog.setMessage(WizardMessages.UpdateAllTests_message);
        Set<IType> elements = cprovider.getTests(this.fPack);
        elements.remove(testSuiteType);
        dialog.setInitialSelections(elements.toArray());
        dialog.setSize(60, 25);
        dialog.setInput(this.fPack);
        if (dialog.open() == 0) {
            this.fSelectedTestCases = dialog.getResult();
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(this.getRunnable());
            }
            catch (Exception e) {
                JUnitPlugin.log(e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object testSuiteObj;
        this.fShell = JUnitPlugin.getActiveWorkbenchShell();
        if (selection instanceof IStructuredSelection && (testSuiteObj = ((IStructuredSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
            IType primaryType;
            this.fTestSuite = (ICompilationUnit)testSuiteObj;
            IJavaElement packIJE = this.fTestSuite.getParent();
            if (packIJE instanceof IPackageFragment) {
                this.fPack = (IPackageFragment)packIJE;
            }
            if ((primaryType = this.fTestSuite.findPrimaryType()) != null) {
                this.fIsJunit4 = primaryType.getAnnotation("RunWith").exists();
                this.fIsJunit5 = primaryType.getAnnotation("Test").exists() && primaryType.getAnnotation("Test").getElementName().startsWith("org.junit.jupiter");
            }
        }
    }

    public static void updateTestCasesInJunit4Suite(IProgressMonitor monitor, ICompilationUnit testSuite, IAnnotation testClassesAnnotation, Object[] selectedTestCases) throws JavaModelException {
        try {
            try {
                monitor.beginTask(WizardMessages.UpdateAllTests_beginTask, 5);
                ISourceRange range = testClassesAnnotation.getSourceRange();
                Document fullSource = new Document(testSuite.getBuffer().getContents());
                StringBuilder source = new StringBuilder();
                monitor.worked(1);
                source.append(UpdateTestSuite.getUpdatableAnnotations(selectedTestCases));
                fullSource.replace(range.getOffset(), range.getLength(), source.toString());
                monitor.worked(1);
                String formattedContent = JUnitStubUtility.formatCompilationUnit(testSuite.getJavaProject(), fullSource.get(), testSuite.findRecommendedLineSeparator());
                IBuffer buf = testSuite.getBuffer();
                buf.replace(0, buf.getLength(), formattedContent);
                monitor.worked(1);
                testSuite.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                monitor.worked(1);
            }
            catch (BadLocationException badLocationException) {
                Assert.isTrue((boolean)false, (String)"Should never happen");
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void updateTestCasesInJunit5Suite(IProgressMonitor monitor, ICompilationUnit testSuite, IAnnotation testClassesAnnotation, Object[] selectedTestCases) throws JavaModelException {
        try {
            try {
                monitor.beginTask(WizardMessages.UpdateAllTests_beginTask, 5);
                ISourceRange range = testClassesAnnotation.getSourceRange();
                Document fullSource = new Document(testSuite.getBuffer().getContents());
                StringBuilder source = new StringBuilder();
                monitor.worked(1);
                source.append(UpdateTestSuite.getUpdatableJUnit5Annotations(selectedTestCases));
                fullSource.replace(range.getOffset(), range.getLength(), source.toString());
                monitor.worked(1);
                String formattedContent = JUnitStubUtility.formatCompilationUnit(testSuite.getJavaProject(), fullSource.get(), testSuite.findRecommendedLineSeparator());
                IBuffer buf = testSuite.getBuffer();
                buf.replace(0, buf.getLength(), formattedContent);
                monitor.worked(1);
                testSuite.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                monitor.worked(1);
            }
            catch (BadLocationException badLocationException) {
                Assert.isTrue((boolean)false, (String)"Should never happen");
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void updateTestCasesInSuite(IProgressMonitor monitor, ICompilationUnit testSuite, IMethod suiteMethod, Object[] selectedTestCases) throws JavaModelException {
        try {
            try {
                monitor.beginTask(WizardMessages.UpdateAllTests_beginTask, 5);
                ISourceRange range = suiteMethod.getSourceRange();
                Document fullSource = new Document(testSuite.getBuffer().getContents());
                String originalContent = fullSource.get(range.getOffset(), range.getLength());
                StringBuilder source = new StringBuilder(originalContent);
                TestSuiteClassListRange classRange = UpdateTestSuite.getTestSuiteClassListRange(source.toString());
                if (classRange != null) {
                    monitor.worked(1);
                    source.replace(classRange.getStart(), classRange.getEnd(), UpdateTestSuite.getUpdatableString(selectedTestCases));
                    fullSource.replace(range.getOffset(), range.getLength(), source.toString());
                    monitor.worked(1);
                    String formattedContent = JUnitStubUtility.formatCompilationUnit(testSuite.getJavaProject(), fullSource.get(), testSuite.findRecommendedLineSeparator());
                    IBuffer buf = testSuite.getBuffer();
                    buf.replace(0, buf.getLength(), formattedContent);
                    monitor.worked(1);
                    testSuite.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                    monitor.worked(1);
                }
            }
            catch (BadLocationException badLocationException) {
                Assert.isTrue((boolean)false, (String)"Should never happen");
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static TestSuiteClassListRange getTestSuiteClassListRange(String source) {
        int start = source.indexOf("$JUnit-BEGIN$");
        if (start <= -1) {
            return null;
        }
        if ((start = source.lastIndexOf("//", start)) <= -1) {
            return null;
        }
        int end = source.indexOf("$JUnit-END$", start);
        if (end <= -1) {
            return null;
        }
        return new TestSuiteClassListRange(start, end += "$JUnit-END$".length());
    }

    public static String getUpdatableString(Object[] selectedClasses) {
        StringBuilder suite = new StringBuilder();
        suite.append("//$JUnit-BEGIN$\n");
        Object[] objectArray = selectedClasses;
        int n = selectedClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedClasse = objectArray[n2];
            if (selectedClasse instanceof IType) {
                IType testType = (IType)selectedClasse;
                IMethod suiteMethod = testType.getMethod("suite", new String[0]);
                if (!suiteMethod.exists()) {
                    suite.append("suite.addTestSuite(" + testType.getElementName() + ".class);");
                } else {
                    suite.append("suite.addTest(" + testType.getElementName() + ".suite());");
                }
            }
            ++n2;
        }
        suite.append("\n//$JUnit-END$");
        return suite.toString();
    }

    public static String getUpdatableAnnotations(Object[] selectedClasses) {
        StringBuilder buffer = new StringBuilder("@SuiteClasses({");
        int i = 0;
        while (i < selectedClasses.length) {
            if (selectedClasses[i] instanceof IType) {
                IType testType = (IType)selectedClasses[i];
                buffer.append(testType.getElementName());
                buffer.append(".class");
                if (i < selectedClasses.length - 1) {
                    buffer.append(',');
                }
            }
            ++i;
        }
        buffer.append("})");
        buffer.append("\n");
        return buffer.toString();
    }

    public static String getUpdatableJUnit5Annotations(Object[] selectedClasses) {
        StringBuilder buffer = new StringBuilder("@SelectClasses({");
        int i = 0;
        while (i < selectedClasses.length) {
            if (selectedClasses[i] instanceof IType) {
                IType testType = (IType)selectedClasses[i];
                buffer.append(testType.getElementName());
                buffer.append(".class");
                if (i < selectedClasses.length - 1) {
                    buffer.append(',');
                }
            }
            ++i;
        }
        buffer.append("})");
        buffer.append("\n");
        return buffer.toString();
    }

    public static boolean checkValidateEditStatus(ICompilationUnit testSuiteCu, Shell shell) {
        IStatus status = UpdateTestSuite.validateModifiesFiles(UpdateTestSuite.getTestSuiteFile(testSuiteCu));
        if (status.isOK()) {
            return true;
        }
        ErrorDialog.openError((Shell)shell, (String)WizardMessages.UpdateTestSuite_update, (String)WizardMessages.UpdateTestSuite_could_not_update, (IStatus)status);
        return false;
    }

    private static IFile getTestSuiteFile(ICompilationUnit testSuiteCu) {
        return (IFile)testSuiteCu.getResource();
    }

    private static IStatus validateModifiesFiles(IFile fileToModify) {
        IFile[] filesToModify = new IFile[]{fileToModify};
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            return status;
        }
        status = Resources.makeCommittable((IResource[])filesToModify, null);
        if (!status.isOK()) {
            return status;
        }
        return new JUnitStatus();
    }

    public IRunnableWithProgress getRunnable() {
        return monitor -> {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (!UpdateTestSuite.checkValidateEditStatus(this.fTestSuite, this.fShell)) {
                return;
            }
            try {
                if (this.fIsJunit4) {
                    UpdateTestSuite.updateTestCasesInJunit4Suite(monitor, this.fTestSuite, this.fSuiteClasses, this.fSelectedTestCases);
                } else if (this.fIsJunit5) {
                    UpdateTestSuite.updateTestCasesInJunit5Suite(monitor, this.fTestSuite, this.fSuiteClasses, this.fSelectedTestCases);
                } else {
                    UpdateTestSuite.updateTestCasesInSuite(monitor, this.fTestSuite, this.fSuiteMethod, this.fSelectedTestCases);
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)e, this.fShell, WizardMessages.UpdateTestSuite_update, WizardMessages.UpdateTestSuite_error);
            }
        };
    }

    private void cannotUpdateSuiteError() {
        MessageDialog.openError((Shell)this.fShell, (String)WizardMessages.UpdateAllTests_cannotUpdate_errorDialog_title, (String)Messages.format((String)WizardMessages.UpdateAllTests_cannotUpdate_errorDialog_message, (Object[])new String[]{"//$JUnit-BEGIN$", "//$JUnit-END$"}));
    }

    private void noSuiteError() {
        if (this.fIsJunit4) {
            MessageDialog.openError((Shell)this.fShell, (String)WizardMessages.UpdateAllTests_cannotFind_annotation_errorDialog_title, (String)WizardMessages.UpdateAllTests_cannotFind_annotation_errorDialog_message);
        } else if (this.fIsJunit5) {
            MessageDialog.openError((Shell)this.fShell, (String)WizardMessages.UpdateAllTests_cannotFind_annotation5_errorDialog_title, (String)WizardMessages.UpdateAllTests_cannotFind_annotation5_errorDialog_message);
        } else {
            MessageDialog.openError((Shell)this.fShell, (String)WizardMessages.UpdateAllTests_cannotFind_errorDialog_title, (String)WizardMessages.UpdateAllTests_cannotFind_errorDialog_message);
        }
    }

    private class UpdateAllTestsValidator
    implements ISelectionStatusValidator {
        private UpdateAllTestsValidator() {
        }

        public IStatus validate(Object[] selection) {
            int count = 0;
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IType) {
                    ++count;
                }
                ++n2;
            }
            if (count == 0 && !fEmptySelectionAllowed) {
                return new JUnitStatus(4, "");
            }
            IStatus recursiveInclusionStatus = this.checkRecursiveSuiteInclusion(selection);
            if (recursiveInclusionStatus != null && !recursiveInclusionStatus.isOK()) {
                return recursiveInclusionStatus;
            }
            String message = count == 1 ? Messages.format((String)WizardMessages.UpdateAllTests_selected_methods_label_one, (Object)count) : Messages.format((String)WizardMessages.UpdateAllTests_selected_methods_label_many, (Object)count);
            return new JUnitStatus(1, message);
        }

        private IStatus checkRecursiveSuiteInclusion(Object[] selection) {
            IType suiteClass = null;
            suiteClass = UpdateTestSuite.this.fIsJunit4 || UpdateTestSuite.this.fIsJunit5 ? (IType)UpdateTestSuite.this.fSuiteClasses.getParent() : UpdateTestSuite.this.fSuiteMethod.getDeclaringType();
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IType && ((IType)element).equals(suiteClass)) {
                    return new JUnitStatus(2, WizardMessages.UpdateTestSuite_infinite_recursion);
                }
                ++n2;
            }
            return null;
        }
    }
}

