/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerPortBinding;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DataVolumeModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.EnvironmentVariableModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunNetworkModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunNetworkPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunSelectionModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.LabelVariableModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;

public class ImageRun
extends Wizard {
    private final ImageRunSelectionPage imageRunSelectionPage;
    private final ImageRunResourceVolumesVariablesPage imageRunResourceVolumesPage;
    private final ImageRunNetworkPage imageRunNetworkPage;

    public ImageRun(IDockerConnection connection) throws DockerException {
        this.setWindowTitle(WizardMessages.getString("ImageRun.title"));
        this.setNeedsProgressMonitor(true);
        this.imageRunSelectionPage = new ImageRunSelectionPage(connection);
        this.imageRunResourceVolumesPage = new ImageRunResourceVolumesVariablesPage(connection);
        this.imageRunNetworkPage = new ImageRunNetworkPage(connection);
    }

    public ImageRun(IDockerImage selectedImage) throws DockerException, CoreException {
        this.setWindowTitle(WizardMessages.getString("ImageRun.title"));
        this.setNeedsProgressMonitor(true);
        ILaunchConfiguration lastLaunchConfiguration = LaunchConfigurationUtils.getLaunchConfigurationByImageName(LaunchConfigurationUtils.getLaunchConfigType("org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType"), (String)selectedImage.repoTags().get(0));
        this.imageRunSelectionPage = new ImageRunSelectionPage(selectedImage, lastLaunchConfiguration);
        this.imageRunResourceVolumesPage = new ImageRunResourceVolumesVariablesPage(selectedImage, lastLaunchConfiguration);
        this.imageRunNetworkPage = new ImageRunNetworkPage(selectedImage, lastLaunchConfiguration);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.imageRunSelectionPage);
        this.addPage((IWizardPage)this.imageRunResourceVolumesPage);
        this.addPage((IWizardPage)this.imageRunNetworkPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.equals((Object)this.imageRunSelectionPage)) {
            this.imageRunResourceVolumesPage.getModel().setSelectedImage(this.imageRunSelectionPage.getModel().getSelectedImage());
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        return true;
    }

    public String getDockerContainerName() {
        return this.imageRunSelectionPage.getModel().getContainerName();
    }

    public boolean removeWhenExits() {
        return this.imageRunSelectionPage.getModel().isRemoveWhenExits();
    }

    public IDockerHostConfig getDockerHostConfig(List<String> unusedPorts) {
        String networkMode;
        ImageRunSelectionModel selectionModel = this.imageRunSelectionPage.getModel();
        ImageRunResourceVolumesVariablesModel resourcesModel = this.imageRunResourceVolumesPage.getModel();
        ImageRunNetworkModel networkModel = this.imageRunNetworkPage.getModel();
        DockerHostConfig.Builder hostConfigBuilder = new DockerHostConfig.Builder();
        if (selectionModel.isPublishAllPorts()) {
            hostConfigBuilder.publishAllPorts(Boolean.valueOf(true));
        } else {
            HashMap<String, List<IDockerPortBinding>> portBindings = new HashMap<String, List<IDockerPortBinding>>();
            for (ImageRunSelectionModel.ExposedPortModel exposedPort : selectionModel.getExposedPorts()) {
                if (!selectionModel.getSelectedPorts().contains(exposedPort)) {
                    StringBuilder b = new StringBuilder();
                    b.append(exposedPort.getContainerPort());
                    b.append("/");
                    b.append(exposedPort.getPortType());
                    b.append(":");
                    if (exposedPort.getHostAddress() != null) {
                        b.append(exposedPort.getHostAddress());
                    }
                    b.append(":");
                    b.append(exposedPort.getHostPort());
                    unusedPorts.add(b.toString());
                    continue;
                }
                DockerPortBinding portBinding = new DockerPortBinding(exposedPort.getHostAddress(), exposedPort.getHostPort());
                portBindings.put(String.valueOf(exposedPort.getContainerPort()) + "/" + exposedPort.getPortType(), Arrays.asList(portBinding));
            }
            hostConfigBuilder.portBindings(portBindings);
        }
        ArrayList<String> links = new ArrayList<String>();
        for (ImageRunSelectionModel.ContainerLinkModel link : selectionModel.getLinks()) {
            links.add(String.valueOf(link.getContainerName()) + ':' + link.getContainerAlias());
        }
        hostConfigBuilder.links(links);
        ArrayList<String> volumesFrom = new ArrayList<String>();
        ArrayList<String> binds = new ArrayList<String>();
        for (DataVolumeModel dataVolume : resourcesModel.getDataVolumes()) {
            if (!resourcesModel.getSelectedDataVolumes().contains(dataVolume)) continue;
            switch (dataVolume.getMountType()) {
                case HOST_FILE_SYSTEM: {
                    String bind = String.valueOf(LaunchConfigurationUtils.convertToUnixPath(dataVolume.getHostPathMount())) + ':' + dataVolume.getContainerPath() + ":Z";
                    if (dataVolume.isReadOnly()) {
                        bind = String.valueOf(bind) + ",ro";
                    }
                    binds.add(bind);
                    break;
                }
                case CONTAINER: {
                    volumesFrom.add(dataVolume.getContainerMount());
                    break;
                }
            }
        }
        hostConfigBuilder.binds(binds);
        hostConfigBuilder.volumesFrom(volumesFrom);
        hostConfigBuilder.privileged(Boolean.valueOf(selectionModel.isPrivileged()));
        if (selectionModel.isBasicSecurity()) {
            hostConfigBuilder.readonlyRootfs(Boolean.valueOf(true));
            HashMap<String, String> tmpfsValues = new HashMap<String, String>();
            tmpfsValues.put("/run", "rw,exec");
            tmpfsValues.put("/tmp", "rw,exec");
            hostConfigBuilder.tmpfs(tmpfsValues);
            ArrayList<String> capDropList = new ArrayList<String>();
            capDropList.add("all");
            hostConfigBuilder.capDrop(capDropList);
        }
        if (selectionModel.isUnconfined()) {
            ArrayList<String> seccomp = new ArrayList<String>();
            seccomp.add("seccomp:unconfined");
            hostConfigBuilder.securityOpt(seccomp);
        }
        if ((networkMode = networkModel.getNetworkModeString()) != null && !networkMode.equals("")) {
            hostConfigBuilder.networkMode(networkMode);
        }
        if (resourcesModel.isEnableResourceLimitations()) {
            hostConfigBuilder.memory(Long.valueOf(resourcesModel.getMemoryLimit() * 0x100000L));
            hostConfigBuilder.cpuShares(Long.valueOf(resourcesModel.getCpuShareWeight()));
        }
        return hostConfigBuilder.build();
    }

    public DockerContainerConfig getDockerContainerConfig() {
        ImageRunSelectionModel selectionModel = this.imageRunSelectionPage.getModel();
        ImageRunResourceVolumesVariablesModel resourcesModel = this.imageRunResourceVolumesPage.getModel();
        DockerContainerConfig.Builder config = new DockerContainerConfig.Builder().cmd(selectionModel.getCommand()).entryPoint(selectionModel.getEntrypoint()).image(selectionModel.getSelectedImageName()).tty(Boolean.valueOf(selectionModel.isAllocatePseudoTTY())).openStdin(Boolean.valueOf(selectionModel.isInteractiveMode()));
        if (resourcesModel.isEnableResourceLimitations()) {
            config.memory(Long.valueOf(resourcesModel.getMemoryLimit() * 0x100000L));
            config.cpuShares(Long.valueOf(resourcesModel.getCpuShareWeight()));
        }
        ArrayList<String> environmentVariables = new ArrayList<String>();
        for (EnvironmentVariableModel var : resourcesModel.getEnvironmentVariables()) {
            environmentVariables.add(String.valueOf(var.getName()) + "=" + var.getValue());
        }
        config.env(environmentVariables);
        HashMap<String, String> labelVariables = new HashMap<String, String>();
        for (LabelVariableModel var : resourcesModel.getLabelVariables()) {
            labelVariables.put(var.getName(), var.getValue());
        }
        config.labels(labelVariables);
        if (!selectionModel.isPublishAllPorts()) {
            HashSet<String> exposedPorts = new HashSet<String>();
            for (ImageRunSelectionModel.ExposedPortModel exposedPort : selectionModel.getExposedPorts()) {
                if (selectionModel.getSelectedPorts() == null || !selectionModel.getSelectedPorts().contains(exposedPort)) continue;
                exposedPorts.add(String.valueOf(exposedPort.getContainerPort()) + "/" + exposedPort.getPortType());
            }
            config.exposedPorts(exposedPorts);
        }
        HashMap emptyMap = new HashMap();
        HashMap volumes = new HashMap();
        for (DataVolumeModel dataVolume : resourcesModel.getDataVolumes()) {
            if (!resourcesModel.getSelectedDataVolumes().contains(dataVolume) || dataVolume.getMountType() != ImageRunResourceVolumesVariablesModel.MountType.NONE) continue;
            volumes.put(dataVolume.getContainerPath(), emptyMap);
        }
        if (!volumes.isEmpty()) {
            config.volumes(volumes);
        }
        return config.build();
    }
}

