/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.outline;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.outline.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.parser.SpecfilePreamble;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackageContainer;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileSection;
import org.eclipse.swt.graphics.Image;

public class SpecfileLabelProvider
extends LabelProvider {
    private static final String PREAMBLE_ICON = "icons/preamble_obj.gif";
    private static final String SECTION_ICON = "icons/section_obj.gif";
    private static final String PACKAGES_ICON = "icons/packages_obj.gif";
    private static final String PACKAGE_ICON = "icons/package_obj.gif";

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image getImage(Object element) {
        if (element instanceof SpecfilePackage) {
            return Activator.getDefault().getImage(PACKAGE_ICON);
        }
        if (element instanceof SpecfileSection) {
            return Activator.getDefault().getImage(SECTION_ICON);
        }
        if (element instanceof SpecfilePackageContainer) {
            return Activator.getDefault().getImage(PACKAGES_ICON);
        }
        if (element instanceof SpecfilePreamble) {
            return Activator.getDefault().getImage(PREAMBLE_ICON);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getText(Object element) {
        String str = "";
        Object object = element;
        if (object instanceof SpecfileSection) {
            void specfileSection;
            SpecfileSection specfileSection2 = (SpecfileSection)object;
            SpecfileSection cfr_ignored_0 = (SpecfileSection)object;
            str = specfileSection.toString();
        } else {
            Object object2 = element;
            if (object2 instanceof Specfile) {
                void s;
                Specfile specfile = (Specfile)object2;
                Specfile cfr_ignored_1 = (Specfile)object2;
                str = s.getName();
            } else if (element instanceof SpecfilePackageContainer) {
                str = Messages.SpecfileLabelProvider_0;
            } else if (element instanceof SpecfilePreamble) {
                str = Messages.SpecfileLabelProvider_1;
            } else {
                Object object3 = element;
                if (object3 instanceof SpecfileElement) {
                    void specfileElement;
                    SpecfileElement specfileElement2 = (SpecfileElement)object3;
                    SpecfileElement cfr_ignored_2 = (SpecfileElement)object3;
                    str = specfileElement.getName();
                } else {
                    Object object4 = element;
                    if (object4 instanceof String) {
                        void s;
                        String string = (String)object4;
                        String cfr_ignored_3 = (String)object4;
                        str = s;
                    } else {
                        Object object5 = element;
                        if (object5 instanceof SpecfilePackage) {
                            void sp;
                            SpecfilePackage specfilePackage = (SpecfilePackage)object5;
                            SpecfilePackage cfr_ignored_4 = (SpecfilePackage)object5;
                            str = sp.getName();
                        }
                    }
                }
            }
        }
        return this.filterMacros(str.trim());
    }

    private String filterMacros(String text) {
        Pattern variablePattern = Pattern.compile("%\\{\\?\\w+\\}");
        Matcher variableMatcher = variablePattern.matcher(text);
        while (variableMatcher.find()) {
            text = text.replace(variableMatcher.group(0), "");
        }
        return text;
    }
}

