/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindCommand;
import org.eclipse.linuxtools.internal.valgrind.launch.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindOutputDirectoryProvider;
import org.eclipse.linuxtools.valgrind.launch.IValgrindLaunchDelegate;
import org.eclipse.linuxtools.valgrind.launch.IValgrindOutputDirectoryProvider;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class ValgrindLaunchPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.launch";
    public static final String LAUNCH_ID = "org.eclipse.linuxtools.valgrind.launch.valgrindLaunch";
    public static final String MARKER_TYPE = "org.eclipse.linuxtools.valgrind.launch.marker";
    public static final String OUTPUT_DIR_EXT_ID = "outputDirectoryProviders";
    public static final String TOOL_EXT_ID = "valgrindTools";
    public static final String TOOL_EXT_DEFAULT = "org.eclipse.linuxtools.valgrind.launch.memcheck";
    protected static final String EXT_ELEMENT_TOOL = "tool";
    protected static final String EXT_ATTR_NAME = "name";
    protected static final String EXT_ATTR_ID = "id";
    protected static final String EXT_ATTR_PAGE = "page";
    protected static final String EXT_ATTR_DELEGATE = "delegate";
    protected static final String EXT_ELEMENT_PROVIDER = "provider";
    protected static final String EXT_ATTR_CLASS = "class";
    public static final Version VER_3_3_0 = new Version(3, 3, 0);
    public static final Version VER_3_4_0 = new Version(3, 4, 0);
    public static final Version VER_3_6_0 = new Version(3, 6, 0);
    private static final Version MIN_VER = VER_3_3_0;
    private static final String VERSION_PREFIX = "valgrind-";
    private static final char VERSION_DELIMITER = '-';
    protected HashMap<String, IConfigurationElement> toolMap;
    private ValgrindCommand valgrindCommand;
    private ILaunchConfiguration config;
    private ILaunch launch;
    private static ValgrindLaunchPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ValgrindLaunchPlugin getDefault() {
        return plugin;
    }

    public Version getValgrindVersion(IProject project) throws CoreException {
        Version valgrindVersion;
        try {
            String verString = this.getValgrindCommand().whichVersion(project);
            verString = verString.replace(VERSION_PREFIX, "");
            if (verString.indexOf(45) > 0) {
                verString = verString.substring(0, verString.indexOf(45));
            }
            if (verString.isEmpty()) {
                throw new CoreException(Status.error((String)Messages.getString("ValgrindLaunchPlugin.Couldn't_determine_version")));
            }
            valgrindVersion = Version.parseVersion((String)verString);
        }
        catch (IOException e) {
            IStatus status = Status.error((String)Messages.getString("ValgrindLaunchPlugin.Couldn't_determine_version"), (Throwable)e);
            throw new CoreException(status);
        }
        if (valgrindVersion.compareTo(MIN_VER) < 0) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.getString("ValgrindLaunchPlugin.Error_min_version"), (Object)valgrindVersion.toString(), (Object)MIN_VER.toString())));
        }
        return valgrindVersion;
    }

    public void setValgrindCommand(ValgrindCommand command) {
        this.valgrindCommand = command;
    }

    protected ValgrindCommand getValgrindCommand() {
        if (this.valgrindCommand == null) {
            this.valgrindCommand = new ValgrindCommand();
        }
        return this.valgrindCommand;
    }

    public String[] getRegisteredToolIDs() {
        Set<String> ids = this.getToolMap().keySet();
        return ids.toArray(new String[ids.size()]);
    }

    public String getToolName(String id) {
        String name = null;
        IConfigurationElement config = this.getToolMap().get(id);
        if (config != null) {
            name = config.getAttribute(EXT_ATTR_NAME);
        }
        return name;
    }

    public IValgrindToolPage getToolPage(String id) throws CoreException {
        Object obj;
        IValgrindToolPage tab = null;
        IConfigurationElement config = this.getToolMap().get(id);
        if (config != null && (obj = config.createExecutableExtension(EXT_ATTR_PAGE)) instanceof IValgrindToolPage) {
            tab = (IValgrindToolPage)obj;
        }
        if (tab == null) {
            throw new CoreException(Status.error((String)Messages.getString("ValgrindLaunchPlugin.Cannot_retrieve_page")));
        }
        return tab;
    }

    public IValgrindLaunchDelegate getToolDelegate(String id) throws CoreException {
        Object obj;
        IValgrindLaunchDelegate delegate = null;
        IConfigurationElement config = this.getToolMap().get(id);
        if (config != null && (obj = config.createExecutableExtension(EXT_ATTR_DELEGATE)) instanceof IValgrindLaunchDelegate) {
            delegate = (IValgrindLaunchDelegate)obj;
        }
        if (delegate == null) {
            throw new CoreException(Status.error((String)Messages.getString("ValgrindLaunchPlugin.Cannot_retrieve_delegate")));
        }
        return delegate;
    }

    public IValgrindOutputDirectoryProvider getOutputDirectoryProvider() throws CoreException {
        IValgrindOutputDirectoryProvider provider = null;
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, OUTPUT_DIR_EXT_ID);
        IConfigurationElement[] configs = extPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length && provider == null) {
            Object obj;
            IConfigurationElement config = configs[i];
            if (config.getName().equals(EXT_ELEMENT_PROVIDER) && (obj = config.createExecutableExtension(EXT_ATTR_CLASS)) instanceof IValgrindOutputDirectoryProvider) {
                provider = (IValgrindOutputDirectoryProvider)obj;
            }
            ++i;
        }
        if (provider == null) {
            provider = new ValgrindOutputDirectoryProvider();
        }
        return provider;
    }

    public void setCurrentLaunchConfiguration(ILaunchConfiguration config) {
        this.config = config;
    }

    public ILaunchConfiguration getCurrentLaunchConfiguration() {
        return this.config;
    }

    public void setCurrentLaunch(ILaunch launch) {
        this.launch = launch;
    }

    public ILaunch getCurrentLaunch() {
        return this.launch;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Shell getShell() {
        if (ValgrindLaunchPlugin.getActiveWorkbenchShell() != null) {
            return ValgrindLaunchPlugin.getActiveWorkbenchShell();
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        return windows[0].getShell();
    }

    IPath parseWSPath(String strpath) throws CoreException {
        IResource res;
        strpath = LaunchUtils.getStringVariableManager().performStringSubstitution(strpath, false);
        Path path = new Path(strpath);
        if (!path.isAbsolute() && (res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path)) != null) {
            path = res.getLocation();
        }
        return path;
    }

    private void initializeToolMap() {
        IConfigurationElement[] configs;
        this.toolMap = new HashMap();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, TOOL_EXT_ID);
        IConfigurationElement[] iConfigurationElementArray = configs = extPoint.getConfigurationElements();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (config.getName().equals(EXT_ELEMENT_TOOL) && (id = config.getAttribute(EXT_ATTR_ID)) != null && config.getAttribute(EXT_ATTR_NAME) != null && config.getAttribute(EXT_ATTR_PAGE) != null && config.getAttribute(EXT_ATTR_DELEGATE) != null) {
                this.toolMap.put(id, config);
            }
            ++n2;
        }
    }

    private HashMap<String, IConfigurationElement> getToolMap() {
        if (this.toolMap == null) {
            this.initializeToolMap();
        }
        return this.toolMap;
    }
}

