/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lpg.runtime.IToken;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.cst.AssertExpCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ClassifierDefCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ClassifierPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ContextualPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ImperativeIterateExpCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.QVTColorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.SemanticHighlightingReconciler;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.EntryOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsPackage;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeIterateExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.Typedef;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.CSTPackage;
import org.eclipse.ocl.cst.FeatureCallExpCS;
import org.eclipse.ocl.cst.IntegerLiteralExpCS;
import org.eclipse.ocl.cst.IteratorExpCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.RealLiteralExpCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.VariableExpCS;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.utilities.PredefinedType;

class QVTSemanticHighlighter {
    private final int INDEX_NUMBERS;
    private final int INDEX_INTERM_DATA;
    private final int INDEX_MODULE_ELEMENT;
    private final int INDEX_USER_MODEL_ELEMENT;
    private final int INDEX_MODEL_PARAMETER;
    private final int INDEX_SELF_VARIABLE;
    private final int INDEX_RESULT_VARIABLE;
    private final int INDEX_FATAL_ASSERT;
    private final int INDEX_STDLIB_ELEMENT;
    private SemanticHighlightingReconciler.PositionCollector fCollector;
    private EPackage fOCLStdlibPckg;
    private Library fQVTStdlib;

    QVTSemanticHighlighter(QVTColorManager.ColorDescriptor[] semanticHighlightings) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int i = 0;
        QVTColorManager.ColorDescriptor[] colorDescriptorArray = semanticHighlightings;
        int n = semanticHighlightings.length;
        int n2 = 0;
        while (n2 < n) {
            QVTColorManager.ColorDescriptor colorDescriptor = colorDescriptorArray[n2];
            map.put(colorDescriptor.key(), i++);
            ++n2;
        }
        this.INDEX_NUMBERS = this.getColorIndex(QVTColorManager.NUMBER, map);
        this.INDEX_INTERM_DATA = this.getColorIndex(QVTColorManager.INTERMEDIATE_DATA, map);
        this.INDEX_MODULE_ELEMENT = this.getColorIndex(QVTColorManager.MODULE_ELEMENT, map);
        this.INDEX_MODEL_PARAMETER = this.getColorIndex(QVTColorManager.MODEL_PARAMETER, map);
        this.INDEX_USER_MODEL_ELEMENT = this.getColorIndex(QVTColorManager.USER_MODEL_ELEMENT, map);
        this.INDEX_STDLIB_ELEMENT = this.getColorIndex(QVTColorManager.STDLIB_ELEMENT, map);
        this.INDEX_RESULT_VARIABLE = this.getColorIndex(QVTColorManager.RESULT_VARIABLE, map);
        this.INDEX_SELF_VARIABLE = this.getColorIndex(QVTColorManager.SELF_VARIABLE, map);
        this.INDEX_FATAL_ASSERT = this.getColorIndex(QVTColorManager.FATAL_ASSERT, map);
    }

    void setCollector(SemanticHighlightingReconciler.PositionCollector positionCollector) {
        this.fCollector = positionCollector;
    }

    protected boolean visit(CompiledUnit unit) {
        UnitCS unitCST = unit.getUnitCST();
        if (unitCST == null) {
            return false;
        }
        try {
            boolean modelOK = this.setModel(unit);
            if (!modelOK) {
                return false;
            }
            TreeIterator allContents = unitCST.eAllContents();
            while (allContents.hasNext()) {
                CSTNode object = (CSTNode)allContents.next();
                if (object instanceof PathNameCS) {
                    PathNameCS pathNameCS = (PathNameCS)object;
                    this.visit(pathNameCS);
                    continue;
                }
                if (object instanceof SimpleNameCS) {
                    this.visit((SimpleNameCS)object);
                    continue;
                }
                if (object instanceof IntegerLiteralExpCS) {
                    this.visit((IntegerLiteralExpCS)object);
                    continue;
                }
                if (object instanceof RealLiteralExpCS) {
                    this.visit((RealLiteralExpCS)object);
                    continue;
                }
                if (object instanceof FeatureCallExpCS) {
                    this.visit((FeatureCallExpCS)object);
                    continue;
                }
                if (object instanceof ClassifierDefCS) {
                    this.visit((ClassifierDefCS)object);
                    continue;
                }
                if (object instanceof VariableExpCS) {
                    this.visit((VariableExpCS)object);
                    continue;
                }
                if (object instanceof MappingDeclarationCS) {
                    this.visit((MappingDeclarationCS)object);
                    continue;
                }
                if (object instanceof AssertExpCS) {
                    this.visit((AssertExpCS)object);
                    continue;
                }
                if (object instanceof ModulePropertyCS) {
                    this.visit((ModulePropertyCS)object);
                    continue;
                }
                if (object instanceof IteratorExpCS) {
                    this.visit((IteratorExpCS)object);
                    continue;
                }
                if (!(object instanceof ImperativeIterateExpCS)) continue;
                this.visit((ImperativeIterateExpCS)object);
            }
        }
        finally {
            this.setModel(null);
        }
        return false;
    }

    protected boolean visit(MappingDeclarationCS n) {
        SimpleNameCS simpleNameCS = n.getSimpleNameCS();
        if (n.getAst() instanceof EntryOperation) {
            return false;
        }
        return this.fCollector.visitToken((CSTNode)simpleNameCS, this.INDEX_MODULE_ELEMENT);
    }

    protected boolean visit(SimpleNameCS n) {
        Object ast = n.getAst();
        if (ast instanceof EClassifier) {
            EClassifier type = (EClassifier)ast;
            if (type.eClass() == org.eclipse.ocl.ecore.EcorePackage.eINSTANCE.getVoidType()) {
                return false;
            }
            if (this.isStdlibElement(type)) {
                if (!(type instanceof CollectionType)) {
                    return this.fCollector.visitToken((CSTNode)n, this.INDEX_STDLIB_ELEMENT);
                }
            } else {
                if (type instanceof Module && n.eContainingFeature() != CSTPackage.eINSTANCE.getPathNameCS_SimpleNames()) {
                    return this.fCollector.visitToken((CSTNode)n, this.INDEX_MODULE_ELEMENT);
                }
                if (type.eClass().getEPackage() != ExpressionsPackage.eINSTANCE) {
                    return this.fCollector.visitToken((CSTNode)n, this.INDEX_USER_MODEL_ELEMENT);
                }
            }
        } else {
            if (ast instanceof EEnumLiteral) {
                return this.fCollector.visitToken((CSTNode)n, this.INDEX_USER_MODEL_ELEMENT);
            }
            if (ast instanceof EPackage) {
                if (this.isStdlibElement((EPackage)ast)) {
                    return this.fCollector.visitToken((CSTNode)n, this.INDEX_STDLIB_ELEMENT);
                }
                return this.fCollector.visitToken((CSTNode)n, this.INDEX_USER_MODEL_ELEMENT);
            }
        }
        if (ast instanceof ModelParameter) {
            return this.fCollector.visitToken((CSTNode)n, this.INDEX_MODEL_PARAMETER);
        }
        return false;
    }

    protected boolean visit(PathNameCS n) {
        EClassifier type = null;
        Object ast = n.getAst();
        if ((type = this.toType(type, ast)) != null) {
            if (type instanceof PrimitiveType) {
                return this.fCollector.visitToken((CSTNode)n, this.INDEX_STDLIB_ELEMENT);
            }
            if (type instanceof EClass && IntermediateClassFactory.isIntermediateClass((EClassifier)type)) {
                return this.fCollector.visitToken((CSTNode)n, this.INDEX_INTERM_DATA);
            }
        }
        return false;
    }

    protected boolean visit(FeatureCallExpCS callCS) {
        SimpleNameCS nameCS = callCS.getSimpleNameCS();
        if (nameCS == null) {
            return false;
        }
        Object ast = nameCS.getAst();
        if (ast instanceof EOperation) {
            EOperation operation = (EOperation)ast;
            if (operation instanceof MappingOperation) {
                return this.fCollector.visitToken((CSTNode)callCS.getSimpleNameCS(), this.INDEX_MODULE_ELEMENT);
            }
            if (operation instanceof ImperativeOperation) {
                return this.fCollector.visitToken((CSTNode)callCS.getSimpleNameCS(), this.INDEX_MODULE_ELEMENT);
            }
            if (this.isStdlibElement(operation)) {
                int operCode = OCLStandardLibraryUtil.getOperationCode((String)operation.getName());
                switch (operCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 25: 
                    case 60: 
                    case 61: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: {
                        return false;
                    }
                }
                return this.fCollector.visitToken((CSTNode)callCS.getSimpleNameCS(), this.INDEX_STDLIB_ELEMENT);
            }
        } else if (ast instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)ast;
            if (IntermediateClassFactory.isIntermediateClass((EClassifier)feature.getEContainingClass())) {
                return this.fCollector.visitToken((CSTNode)callCS.getSimpleNameCS(), this.INDEX_INTERM_DATA);
            }
            if (ast instanceof ContextualProperty) {
                return this.fCollector.visitToken((CSTNode)callCS.getSimpleNameCS(), this.INDEX_INTERM_DATA);
            }
            if (feature.getEContainingClass().eClass() == EcorePackage.eINSTANCE.getEClass()) {
                return this.fCollector.visitToken((CSTNode)callCS.getSimpleNameCS(), this.INDEX_USER_MODEL_ELEMENT);
            }
            return this.fCollector.visitToken((CSTNode)callCS.getSimpleNameCS(), this.INDEX_MODULE_ELEMENT);
        }
        return true;
    }

    protected boolean visit(ClassifierDefCS classifierDefCS) {
        for (ClassifierPropertyCS next : classifierDefCS.getProperties()) {
            this.fCollector.visitToken((CSTNode)next.getSimpleNameCS(), this.INDEX_INTERM_DATA);
        }
        return this.fCollector.visitToken((CSTNode)classifierDefCS.getSimpleNameCS(), this.INDEX_INTERM_DATA);
    }

    protected boolean visit(ImperativeIterateExpCS iteratorExpCS) {
        IToken endToken = iteratorExpCS.getEndToken();
        if (endToken != null && "]".equals(endToken.toString())) {
            return false;
        }
        Object ast = iteratorExpCS.getAst();
        if (ast instanceof ImperativeIterateExp) {
            return this.fCollector.visitToken((CSTNode)iteratorExpCS.getSimpleNameCS(), this.INDEX_STDLIB_ELEMENT);
        }
        return false;
    }

    protected boolean visit(IteratorExpCS iteratorExpCS) {
        Object ast = iteratorExpCS.getAst();
        if (ast instanceof IteratorExp) {
            return this.fCollector.visitToken((CSTNode)iteratorExpCS.getSimpleNameCS(), this.INDEX_STDLIB_ELEMENT);
        }
        return false;
    }

    protected boolean visit(ModulePropertyCS propertyCS) {
        SimpleNameCS simpleNameCS = propertyCS.getSimpleNameCS();
        if (simpleNameCS != null) {
            if (propertyCS instanceof ContextualPropertyCS || propertyCS instanceof ClassifierPropertyCS) {
                return this.fCollector.visitToken((CSTNode)simpleNameCS, this.INDEX_INTERM_DATA);
            }
            return this.fCollector.visitToken((CSTNode)simpleNameCS, this.INDEX_MODULE_ELEMENT);
        }
        return false;
    }

    protected boolean visit(VariableExpCS variableExpCS) {
        SimpleNameCS simpleNameCS = variableExpCS.getSimpleNameCS();
        Object ast = simpleNameCS.getAst();
        if (ast instanceof ModelParameter) {
            this.fCollector.visitToken((CSTNode)simpleNameCS, this.INDEX_MODEL_PARAMETER);
        } else if (ast instanceof VarParameter) {
            String varName = simpleNameCS.getValue();
            if ("self".equals(varName)) {
                this.fCollector.visitToken((CSTNode)simpleNameCS, this.INDEX_SELF_VARIABLE);
            } else if ("result".equals(varName)) {
                this.fCollector.visitToken((CSTNode)simpleNameCS, this.INDEX_RESULT_VARIABLE);
            }
        } else if (ast instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)ast;
            EClass ownerClass = feature.getEContainingClass();
            if (feature instanceof ContextualProperty || IntermediateClassFactory.isIntermediateClass((EClassifier)ownerClass)) {
                return this.fCollector.visitToken((CSTNode)simpleNameCS, this.INDEX_INTERM_DATA);
            }
            if (ownerClass.eClass() == EcorePackage.eINSTANCE.getEClass()) {
                return this.fCollector.visitToken((CSTNode)simpleNameCS, this.INDEX_USER_MODEL_ELEMENT);
            }
            return this.fCollector.visitToken((CSTNode)simpleNameCS, this.INDEX_MODULE_ELEMENT);
        }
        return false;
    }

    protected boolean visit(AssertExpCS assertExpCS) {
        SimpleNameCS severity = assertExpCS.getSeverity();
        if (severity != null && "fatal".equals(severity.getValue())) {
            return this.fCollector.visitToken((CSTNode)severity, this.INDEX_FATAL_ASSERT);
        }
        return false;
    }

    protected boolean visit(IntegerLiteralExpCS n) {
        return this.fCollector.visitToken((CSTNode)n, this.INDEX_NUMBERS);
    }

    protected boolean visit(RealLiteralExpCS n) {
        return this.fCollector.visitToken((CSTNode)n, this.INDEX_NUMBERS);
    }

    private int getColorIndex(String colorKey, Map<String, Integer> map) {
        Integer index = map.get(colorKey);
        return index != null ? index : -1;
    }

    private boolean isStdlibElement(EClassifier type) {
        EPackage ePackage = type.getEPackage();
        return ePackage != null && this.isStdlibElement(ePackage) || type instanceof PredefinedType;
    }

    private boolean isStdlibElement(EPackage ePackage) {
        EObject root = EcoreUtil.getRootContainer((EObject)ePackage);
        return root == this.fQVTStdlib || root == this.fOCLStdlibPckg;
    }

    private boolean isStdlibElement(EOperation operation) {
        EClass eClass = operation.getEContainingClass();
        return eClass != null && this.isStdlibElement((EClassifier)eClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setModel(CompiledUnit model) {
        if (model != null) {
            List envList = model.getModuleEnvironments();
            if (envList == null || envList.isEmpty()) return false;
            QvtOperationalModuleEnv env = (QvtOperationalModuleEnv)envList.get(0);
            this.fQVTStdlib = env.getQVTStandardLibrary().getStdLibModule();
            this.fOCLStdlibPckg = ((EClassifier)env.getOCLStandardLibrary().getBoolean()).getEPackage();
            return true;
        } else {
            this.fQVTStdlib = null;
            this.fOCLStdlibPckg = null;
        }
        return true;
    }

    private EClassifier toType(EClassifier type, Object ast) {
        if (ast instanceof Typedef) {
            type = ((Typedef)ast).getBase();
        } else if (ast instanceof EClassifier) {
            type = (EClassifier)ast;
        }
        return type;
    }
}

