/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.egit;

import com.google.gerrit.reviewdb.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.Project;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.clone.GitCloneWizard;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositorySearchResult;
import org.eclipse.egit.ui.internal.provisional.wizards.NoRepositoryInfoException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Shell;

public class EGitUiUtil {
    public static RevCommit getRevCommit(Repository repository, PatchSet target) throws AmbiguousObjectException, IOException, MissingObjectException, IncorrectObjectTypeException {
        ObjectId ref = repository.resolve(target.getRevision().get());
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk walker = new RevWalk(repository);){
            return walker.parseCommit((AnyObjectId)ref);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static RevCommit fetchRefSpec(IProgressMonitor monitor, Repository repository, RemoteConfig remote, RefSpec refSpec) throws URISyntaxException, CoreException, MissingObjectException, IncorrectObjectTypeException, IOException {
        List<RefSpec> refSpecs = Collections.singletonList(refSpec);
        FetchOperationUI op = new FetchOperationUI(repository, (URIish)remote.getURIs().get(0), refSpecs, false);
        op.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        FetchResult result = op.execute(monitor);
        ObjectId resultRef = result.getAdvertisedRef(refSpec.getSource()).getObjectId();
        Throwable throwable = null;
        Object var9_10 = null;
        try (RevWalk walker = new RevWalk(repository);){
            return walker.parseCommit((AnyObjectId)resultRef);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static RevCommit fetchPatchSet(IProgressMonitor monitor, Repository repository, RemoteConfig remote, PatchSet patchSet) throws IOException, CoreException, URISyntaxException {
        try {
            return EGitUiUtil.getRevCommit(repository, patchSet);
        }
        catch (MissingObjectException e) {
            RefSpec refSpec = new RefSpec(String.valueOf(patchSet.getRefName()) + ":FETCH_HEAD");
            return EGitUiUtil.fetchRefSpec(monitor, repository, remote, refSpec);
        }
    }

    public static int openCloneRepositoryWizard(Shell shell, final TaskRepository repository, final Project project) {
        GitCloneWizard cloneWizard = new GitCloneWizard(new IRepositorySearchResult(){

            public GitRepositoryInfo getGitRepositoryInfo() throws NoRepositoryInfoException {
                try {
                    GerritConfiguration config = GerritCorePlugin.getGerritClient((TaskRepository)repository).refreshConfig(null);
                    GitRepositoryInfo gitRepositoryInfo = new GitRepositoryInfo(EGitUiUtil.getCloneUriForRepo(repository, config, project));
                    return gitRepositoryInfo;
                }
                catch (GerritException gerritException) {
                    return null;
                }
            }
        });
        WizardDialog dlg = new WizardDialog(shell, (IWizard)cloneWizard);
        dlg.setHelpAvailable(true);
        return dlg.open();
    }

    private static String getCloneUriForRepo(TaskRepository repository, GerritConfiguration config, Project project) throws NoRepositoryInfoException {
        try {
            HashMap cloneUris = GerritUtil.getCloneUris((GerritConfiguration)config, (TaskRepository)repository, (Project)project);
            if (cloneUris.keySet().contains(AccountGeneralPreferences.DownloadScheme.SSH)) {
                return (String)cloneUris.get(AccountGeneralPreferences.DownloadScheme.SSH);
            }
            if (cloneUris.keySet().contains(AccountGeneralPreferences.DownloadScheme.HTTP)) {
                return (String)cloneUris.get(AccountGeneralPreferences.DownloadScheme.HTTP);
            }
            for (AccountGeneralPreferences.DownloadScheme scheme : cloneUris.keySet()) {
                if (cloneUris.get(scheme) == null) continue;
                return (String)cloneUris.get(scheme);
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new NoRepositoryInfoException(e.getMessage(), (Throwable)e);
        }
    }
}

