/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.editor;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectColumnCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.nattable.common.editor.AbstractEMFNattableEditor;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.ui.editor.reload.EMFSelectionContext;
import org.eclipse.papyrus.infra.ui.editor.reload.IReloadContextProvider;

class NattableReloadContextProvider
implements IReloadContextProvider {
    private final AbstractEMFNattableEditor editor;

    NattableReloadContextProvider(AbstractEMFNattableEditor editor) {
        this.editor = editor;
    }

    public Object createReloadContext() {
        return new NatTableSelectionContext(this.getSelectionProvider(), this.getSelectionLayer());
    }

    public void restore(Object reloadContext) {
        ((NatTableSelectionContext)((Object)reloadContext)).restore(this.getSelectionProvider(), this.getSelectionLayer());
    }

    private ISelectionProvider getSelectionProvider() {
        return this.editor.getSite().getSelectionProvider();
    }

    private SelectionLayer getSelectionLayer() {
        INattableModelManager mgr = (INattableModelManager)AdapterUtils.adapt((Object)((Object)this.editor), INattableModelManager.class, null);
        return mgr.getBodyLayerStack().getSelectionLayer();
    }

    private static class NatTableSelectionContext
    extends EMFSelectionContext {
        private final int[] selectedRows;
        private final int[] selectedColumns;

        NatTableSelectionContext(ISelectionProvider structuredSelectionProvider, SelectionLayer selectionLayer) {
            super(structuredSelectionProvider);
            this.selectedRows = selectionLayer.getFullySelectedRowPositions();
            this.selectedColumns = selectionLayer.getFullySelectedColumnPositions();
        }

        void restore(ISelectionProvider structuredSelectionProvider, SelectionLayer selectionLayer) {
            selectionLayer.clear();
            if (this.selectedColumns.length > 0) {
                int i = 0;
                while (i < this.selectedColumns.length) {
                    selectionLayer.doCommand((ILayerCommand)new SelectColumnCommand((ILayer)selectionLayer, this.selectedColumns[i], Integer.MAX_VALUE, false, true));
                    ++i;
                }
            }
            if (this.selectedRows.length > 0) {
                selectionLayer.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)selectionLayer, Integer.MAX_VALUE, this.selectedRows, false, true, this.selectedRows[this.selectedRows.length - 1]));
            }
            this.restore(structuredSelectionProvider);
        }
    }
}

