/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.ptp.etfw.tau.ITAULaunchConfigurationConstants;
import org.eclipse.ptp.etfw.tau.messages.Messages;
import org.eclipse.ptp.etfw.tau.perfdmf.PerfDMFUIPlugin;
import org.eclipse.ptp.etfw.tau.perfdmf.views.PerfDMFView;
import org.eclipse.ptp.etfw.toolopts.IToolUITab;
import org.eclipse.ptp.etfw.toolopts.ToolPaneListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUDataTab
implements IToolUITab {
    protected Combo dbCombo = null;
    protected Button nocleanCheck;
    protected Button keepprofsCheck;
    protected Button profSummaryCheck;
    protected Button portalCheck;
    private ToolPaneListener paneListener;
    Composite fComp;

    protected static GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected static GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return SWTFactory.createCheckButton((Composite)parent, (String)label, null, (boolean)false, (int)1);
    }

    protected Button createPushButton(Composite parent, String label, Image image) {
        return SWTFactory.createPushButton((Composite)parent, (String)label, (Image)image);
    }

    protected Button createRadioButton(Composite parent, String label) {
        return SWTFactory.createRadioButton((Composite)parent, (String)label);
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        SWTFactory.createVerticalSpacer((Composite)comp, (int)colSpan);
    }

    public String getArgument(ILaunchConfiguration configuration) {
        return null;
    }

    public String getConfigID() {
        return "TAU_DATA_MANAGEMENT_PANE";
    }

    public String getConfigVarID() {
        return "TAU_DATA_MANAGEMENT_PANE_VARS";
    }

    public Map<String, String> getEnvVars(ILaunchConfiguration configuration) {
        return null;
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals("")) {
            return null;
        }
        return text;
    }

    public String getName() {
        return "Data Collection";
    }

    public String getOptionString() {
        return "";
    }

    protected Shell getShell() {
        if (this.fComp != null) {
            return this.fComp.getShell();
        }
        return null;
    }

    public String getToolName() {
        return "TAU";
    }

    public Map<String, String> getVarMap() {
        return null;
    }

    private void initDBCombo(String selected) {
        String[] dbs = null;
        try {
            dbs = PerfDMFUIPlugin.getPerfDMFView().getDatabaseNames();
        }
        catch (NoClassDefFoundError e) {
            System.out.println(Messages.TAUAnalysisTab_WarnTauJarsNotFound);
        }
        this.dbCombo.clearSelection();
        this.dbCombo.removeAll();
        if (dbs == null || dbs.length < 1) {
            this.dbCombo.add(ITAULaunchConfigurationConstants.NODB);
            this.dbCombo.select(0);
            return;
        }
        String[] stringArray = dbs;
        int n = dbs.length;
        int n2 = 0;
        while (n2 < n) {
            String db = stringArray[n2];
            this.dbCombo.add(db);
            ++n2;
        }
        if (selected == null || this.dbCombo.indexOf(selected) < 0) {
            this.dbCombo.select(0);
        } else {
            this.dbCombo.select(this.dbCombo.indexOf(selected));
        }
    }

    public void initializePane(ILaunchConfiguration configuration) throws CoreException {
        this.initDBCombo(configuration.getAttribute("perfdmf_database_configuration", null));
        this.keepprofsCheck.setSelection(configuration.getAttribute("keep_profile_files", false));
        this.profSummaryCheck.setSelection(configuration.getAttribute("print_profile_summary_only", false));
        this.portalCheck.setSelection(configuration.getAttribute("upload_profiles_to_portal", false));
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isVirtual() {
        return false;
    }

    public void makeToolPane(Composite comp) {
        this.makeToolPane(comp, null);
    }

    public void makeToolPane(Composite dataComp, ToolPaneListener listener) {
        this.fComp = dataComp;
        dataComp.setLayout((Layout)TAUDataTab.createGridLayout(1, false, 0, 0));
        dataComp.setLayoutData((Object)TAUDataTab.spanGridData(768, 5));
        this.createVerticalSpacer(dataComp, 1);
        Composite dbComp = new Composite(dataComp, 0);
        dbComp.setLayout((Layout)TAUDataTab.createGridLayout(2, false, 0, 0));
        dbComp.setLayoutData((Object)new GridData(768));
        Label dbLab = new Label(dbComp, 0);
        dbLab.setText(Messages.TAUAnalysisTab_SelectDatabase);
        this.dbCombo = new Combo(dbComp, 2060);
        this.dbCombo.addSelectionListener((SelectionListener)listener);
        this.keepprofsCheck = this.createCheckButton(dataComp, Messages.TAUAnalysisTab_KeepProfiles);
        this.keepprofsCheck.addSelectionListener((SelectionListener)listener);
        this.profSummaryCheck = this.createCheckButton(dataComp, Messages.TAUAnalysisTab_ProfileSummary);
        this.profSummaryCheck.addSelectionListener((SelectionListener)listener);
        this.portalCheck = this.createCheckButton(dataComp, Messages.TAUAnalysisTab_UploadDataToTauPortal);
        this.portalCheck.addSelectionListener((SelectionListener)listener);
    }

    public void OptUpdate() {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("keep_profile_files", this.keepprofsCheck.getSelection());
        configuration.setAttribute("print_profile_summary_only", this.profSummaryCheck.getSelection());
        configuration.setAttribute("upload_profiles_to_portal", this.portalCheck.getSelection());
        int idex = this.dbCombo.getSelectionIndex();
        if (idex >= 0) {
            configuration.setAttribute("perfdmf_database_configuration", this.dbCombo.getItem(idex));
            configuration.setAttribute("perfdmf_database_simple_name", PerfDMFView.extractDatabaseName((String)this.dbCombo.getItem(idex)));
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("keep_profile_files", false);
    }

    public void updateOptDisplay() {
    }

    public boolean updateOptField(Object source) {
        return false;
    }
}

