/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.common.wait.AbstractWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.ItemHandler;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Item;

public class ExpandItemHandler
extends ItemHandler {
    private static final Logger logger = Logger.getLogger(ExpandItemHandler.class);
    private static ExpandItemHandler instance;

    public static ExpandItemHandler getInstance() {
        if (instance == null) {
            instance = new ExpandItemHandler();
        }
        return instance;
    }

    public void expand(TimePeriod timePeriod, final ExpandItem expandItem) {
        logger.debug("Expand Expand Bar Item " + this.getText((Item)expandItem));
        if (!this.isExpanded(expandItem)) {
            this.notifyExpandBar(this.createEventForExpandBar(17, expandItem), expandItem);
            Display.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    expandItem.setExpanded(true);
                }
            });
            AbstractWait.sleep((TimePeriod)timePeriod);
            logger.info("Expand Bar Item " + this.getText((Item)expandItem) + " has been expanded");
        } else {
            logger.debug("Expand Bar Item " + this.getText((Item)expandItem) + " is already expanded. No action performed");
        }
    }

    public void collapse(final ExpandItem expandItem) {
        logger.debug("Collapse Expand Bar Item " + this.getText((Item)expandItem));
        if (this.isExpanded(expandItem)) {
            Display.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    expandItem.setExpanded(false);
                }
            });
            this.notifyExpandBar(this.createEventForExpandBar(18, expandItem), expandItem);
            logger.info("Expand Bar Item " + this.getText((Item)expandItem) + " has been collapsed");
        } else {
            logger.debug("Expand Bar Item " + this.getText((Item)expandItem) + " is already collapsed. No action performed");
        }
    }

    private void notifyExpandBar(final Event event, final ExpandItem expandItem) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                expandItem.getParent().notifyListeners(event.type, event);
            }
        });
    }

    private Event createEventForExpandBar(int type, ExpandItem expandItem) {
        return this.createEventForExpandBar(type, 0, expandItem);
    }

    private Event createEventForExpandBar(int type, int detail, ExpandItem expandItem) {
        Event event = new Event();
        event.type = type;
        event.display = Display.getDisplay();
        event.time = (int)System.currentTimeMillis();
        event.item = expandItem;
        event.widget = this.getParent(expandItem);
        event.detail = detail;
        return event;
    }

    public void expand(final ExpandItem expandItem, ExpandBar expandBar) {
        this.notifyExpandBar(this.createEventForExpandBar(17, expandItem, expandBar), expandBar);
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                expandItem.setExpanded(true);
            }
        });
    }

    public void collapse(final ExpandItem expandItem, ExpandBar expandBar) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                expandItem.setExpanded(false);
            }
        });
        this.notifyExpandBar(this.createEventForExpandBar(18, expandItem, expandBar), expandBar);
    }

    private void notifyExpandBar(final Event event, final ExpandBar expandBar) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                expandBar.notifyListeners(event.type, event);
            }
        });
    }

    private Event createEventForExpandBar(int type, ExpandItem expandItem, ExpandBar expandBar) {
        return this.createEventForExpandBar(type, 0, expandItem, expandBar);
    }

    private Event createEventForExpandBar(int type, int detail, ExpandItem expandItem, ExpandBar expandBar) {
        Event event = new Event();
        event.type = type;
        event.display = Display.getDisplay();
        event.time = (int)System.currentTimeMillis();
        event.item = expandItem;
        event.widget = expandBar;
        event.detail = detail;
        return event;
    }

    public String getToolTipText(final ExpandItem item) {
        String text = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return item.getParent().getToolTipText();
            }
        });
        return text;
    }

    public boolean isExpanded(final ExpandItem item) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return item.getExpanded();
            }
        });
    }

    public ExpandBar getParent(final ExpandItem item) {
        return (ExpandBar)Display.syncExec((ResultRunnable)new ResultRunnable<ExpandBar>(){

            public ExpandBar run() {
                return item.getParent();
            }
        });
    }

    public void setFocus(ExpandItem expandItem) {
        ControlHandler.getInstance().setFocus((Control)this.getParent(expandItem));
    }
}

