/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.matcher;

import org.eclipse.jface.window.Window;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class WindowMatcher
extends TypeSafeMatcher<Shell> {
    private Class<? extends Window> windowClass;

    public <T extends Window> WindowMatcher(Class<T> windowClass) {
        this.windowClass = windowClass;
    }

    public void describeTo(Description description) {
        description.appendText("Window matching class " + this.windowClass);
    }

    protected boolean matchesSafely(Shell item) {
        try {
            Object data = WidgetHandler.getInstance().getData((Widget)item);
            if (data != null) {
                return this.windowClass.isInstance(data);
            }
        }
        catch (RedDeerException e) {
            if (item.isDisposed()) {
                return false;
            }
            throw e;
        }
        return false;
    }
}

