/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class DebugUtil {
    private DebugUtil() {
    }

    public static void printMethodTrace() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        DebugUtil.printMethodTrace(trace, null);
    }

    public static void printMethodTrace(String extraMessage) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        DebugUtil.printMethodTrace(trace, extraMessage);
    }

    private static void printMethodTrace(StackTraceElement[] trace, String extraMessage) {
        StackTraceElement caller = trace[3];
        String className = caller.getClassName();
        className = className.substring(className.lastIndexOf(".") + 1);
        String message = String.format("%s.%s(%s:%d)", className, caller.getMethodName(), caller.getFileName(), caller.getLineNumber());
        if (extraMessage != null) {
            message = String.valueOf(message) + ": " + extraMessage;
        }
        System.out.println(message);
    }

    public static String safeClassName(Object obj) {
        return obj != null ? obj.getClass().getSimpleName() : "";
    }

    public static String toStringWithClass(Object obj) {
        return obj != null ? String.valueOf(String.valueOf(obj)) + " " + obj.getClass().getSimpleName() : "null";
    }

    public static void printObjectProperties(Object obj) {
        try {
            System.out.println("Object: " + obj);
            BeanInfo info = Introspector.getBeanInfo(obj.getClass());
            PropertyDescriptor[] propertyDescriptorArray = info.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                Method getter = propertyDescriptor.getReadMethod();
                try {
                    System.out.println("  " + getter.getName() + "=" + getter.invoke(obj, new Object[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }
}

