/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSpecification;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.FindNodeForOffsetAction;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;

public class ASTNodeSelector
implements IASTNodeSelector {
    private final ASTTranslationUnit fTu;
    private final ILocationResolver fLocationResolver;
    private String fFilePath;
    private final boolean fIsValid;

    public ASTNodeSelector(ASTTranslationUnit tu, ILocationResolver locationResolver, String filePath) {
        this.fTu = tu;
        this.fLocationResolver = locationResolver;
        this.fFilePath = filePath;
        this.fIsValid = this.verify();
    }

    private boolean verify() {
        if (this.fLocationResolver != null) {
            if (this.fFilePath == null) {
                this.fFilePath = this.fLocationResolver.getTranslationUnitPath();
            }
            return true;
        }
        return false;
    }

    private <T extends IASTNode> T findNode(int offsetInFile, int lengthInFile, ASTNodeSpecification.Relation relation, Class<T> requiredClass) {
        return this.findNode(offsetInFile, lengthInFile, relation, requiredClass, false);
    }

    private <T extends IASTNode> T findNode(int offsetInFile, int lengthInFile, ASTNodeSpecification.Relation relation, Class<T> requiredClass, boolean searchInExpansion) {
        int sequenceLength;
        if (!this.fIsValid) {
            return null;
        }
        if (lengthInFile < 0) {
            throw new IllegalArgumentException("Length cannot be less than zero.");
        }
        int altSequenceNumber = -1;
        int sequenceNumber = this.fLocationResolver.getSequenceNumberForFileOffset(this.fFilePath, offsetInFile);
        if (sequenceNumber < 0) {
            return null;
        }
        if (lengthInFile > 0) {
            sequenceLength = this.fLocationResolver.getSequenceNumberForFileOffset(this.fFilePath, offsetInFile + lengthInFile - 1) + 1 - sequenceNumber;
        } else {
            sequenceLength = 0;
            if (offsetInFile > 0) {
                altSequenceNumber = this.fLocationResolver.getSequenceNumberForFileOffset(this.fFilePath, offsetInFile - 1);
                if (altSequenceNumber + 1 == sequenceNumber) {
                    altSequenceNumber = -1;
                } else {
                    sequenceLength = 1;
                }
            }
        }
        ASTNodeSpecification<T> nodeSpec = new ASTNodeSpecification<T>(relation, requiredClass, offsetInFile, lengthInFile);
        nodeSpec.setRangeInSequence(sequenceNumber, sequenceLength, false);
        nodeSpec.setSearchInExpansion(searchInExpansion);
        this.getNode(nodeSpec);
        if (altSequenceNumber != -1) {
            nodeSpec.setRangeInSequence(altSequenceNumber, sequenceLength, true);
            this.getNode(nodeSpec);
        }
        return nodeSpec.getBestNode();
    }

    private <T extends IASTNode> T getNode(ASTNodeSpecification<T> nodeSpec) {
        this.fLocationResolver.findPreprocessorNode(nodeSpec);
        if (!nodeSpec.requiresClass(IASTPreprocessorMacroExpansion.class)) {
            IASTFileLocation floc;
            int seqbegin = nodeSpec.getSequenceStart();
            int seqend = nodeSpec.getSequenceEnd();
            IASTPreprocessorMacroExpansion expansion = nodeSpec.findLeadingMacroExpansion(this);
            if (expansion != null) {
                floc = expansion.getFileLocation();
                seqbegin = this.fLocationResolver.getSequenceNumberForFileOffset(this.fFilePath, floc.getNodeOffset() + floc.getNodeLength() - 1) + 1;
            }
            if ((expansion = nodeSpec.findTrailingMacroExpansion(this)) != null) {
                floc = expansion.getFileLocation();
                seqend = this.fLocationResolver.getSequenceNumberForFileOffset(this.fFilePath, floc.getNodeOffset() + floc.getNodeLength());
            }
            nodeSpec.setRangeInSequence(seqbegin, seqend - seqbegin);
            FindNodeForOffsetAction nodeFinder = new FindNodeForOffsetAction(nodeSpec);
            this.fTu.accept(nodeFinder);
        }
        return nodeSpec.getBestNode();
    }

    @Override
    public IASTNode findFirstContainedNode(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.FIRST_CONTAINED, IASTNode.class);
    }

    @Override
    public IASTNode findNode(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.EXACT_MATCH, IASTNode.class);
    }

    @Override
    public IASTNode findEnclosingNode(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.ENCLOSING, IASTNode.class);
    }

    @Override
    public IASTNode findStrictlyEnclosingNode(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.STRICTLY_ENCLOSING, IASTNode.class);
    }

    @Override
    public IASTNode findFirstContainedNodeInExpansion(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.FIRST_CONTAINED, IASTNode.class, true);
    }

    @Override
    public IASTNode findNodeInExpansion(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.EXACT_MATCH, IASTNode.class, true);
    }

    @Override
    public IASTNode findEnclosingNodeInExpansion(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.ENCLOSING, IASTNode.class, true);
    }

    @Override
    public IASTName findFirstContainedName(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.FIRST_CONTAINED, IASTName.class);
    }

    @Override
    public IASTName findName(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.EXACT_MATCH, IASTName.class);
    }

    @Override
    public IASTName findEnclosingName(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.ENCLOSING, IASTName.class);
    }

    @Override
    public IASTImplicitName findImplicitName(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.EXACT_MATCH, IASTImplicitName.class);
    }

    @Override
    public IASTImplicitName findEnclosingImplicitName(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.ENCLOSING, IASTImplicitName.class);
    }

    @Override
    public IASTPreprocessorMacroExpansion findEnclosingMacroExpansion(int offset, int length) {
        return this.findNode(offset, length, ASTNodeSpecification.Relation.ENCLOSING, IASTPreprocessorMacroExpansion.class);
    }
}

