/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.win32;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.compare.internal.win32.AbstractMergeViewer;
import org.eclipse.compare.internal.win32.Activator;
import org.eclipse.compare.internal.win32.CompareWin32Messages;
import org.eclipse.compare.internal.win32.WordComparison;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;
import org.osgi.framework.Bundle;

public class WordMergeViewer
extends AbstractMergeViewer
implements IFlushable,
IPropertyChangeNotifier {
    private static final String RESOURCE_BUNDLE_NAME = "org.eclipse.compare.internal.win32.WordMergeViewer";
    private FormToolkit formToolkit;
    private PageBook composite;
    private Composite docArea;
    private Composite textArea;
    private Label description;
    private WordComparison wordArea;
    private boolean isDirty;
    private ListenerList listeners = new ListenerList(1);
    private Action saveAction;
    private ResourceBundle resourceBundle;
    private Action inplaceAction;
    private long resultFileTimestamp = -1L;

    public WordMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(configuration);
        this.createContentArea(parent);
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WordMergeViewer.this.handleDispose();
            }
        });
        this.getControl().setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)CompareWin32Messages.WordMergeViewer_1);
        ToolBarManager toolBarManager = CompareViewerPane.getToolBarManager((Composite)parent);
        if (toolBarManager != null) {
            toolBarManager.removeAll();
            this.initializeToolbar((IToolBarManager)toolBarManager);
        }
        this.updateEnablements();
    }

    private void createContentArea(Composite parent) {
        this.formToolkit = new FormToolkit(parent.getDisplay());
        this.composite = new PageBook(parent, 0);
        this.createDocArea(this.composite);
        this.createTextArea(this.composite);
    }

    private void initializeToolbar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("modes"));
        toolBarManager.add((IContributionItem)new Separator("file"));
        CompareConfiguration configuration = this.getConfiguration();
        if (configuration.isRightEditable() || configuration.isLeftEditable() && configuration.isRightEditable() != configuration.isLeftEditable()) {
            this.saveAction = new Action(){

                public void run() {
                    WordMergeViewer.this.saveDocument();
                }
            };
            WordMergeViewer.initAction((IAction)this.saveAction, this.getResourceBundle(), "action.save.");
            toolBarManager.appendToGroup("file", (IAction)this.saveAction);
        }
        this.inplaceAction = new Action(CompareWin32Messages.WordMergeViewer_2, 2){

            public void run() {
                WordMergeViewer.this.toggleInplaceExternalState();
            }
        };
        WordMergeViewer.initAction((IAction)this.inplaceAction, this.getResourceBundle(), "action.inplace.");
        toolBarManager.appendToGroup("modes", (IAction)this.inplaceAction);
        toolBarManager.update(true);
    }

    private static void initAction(IAction a, ResourceBundle bundle, String prefix) {
        Object labelKey = "label";
        Object tooltipKey = "tooltip";
        Object imageKey = "image";
        Object descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = prefix + (String)labelKey;
            tooltipKey = prefix + (String)tooltipKey;
            imageKey = prefix + (String)imageKey;
            descriptionKey = prefix + (String)descriptionKey;
        }
        a.setText(WordMergeViewer.getString(bundle, (String)labelKey, (String)labelKey));
        a.setToolTipText(WordMergeViewer.getString(bundle, (String)tooltipKey, null));
        a.setDescription(WordMergeViewer.getString(bundle, (String)descriptionKey, null));
        String relPath = WordMergeViewer.getString(bundle, (String)imageKey, null);
        if (relPath != null && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            if (relPath.contains("/")) {
                String path = relPath.substring(1);
                dPath = "d" + path;
                ePath = "e" + path;
            } else {
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = WordMergeViewer.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = WordMergeViewer.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
                a.setHoverImageDescriptor(id);
            }
        }
    }

    private static ImageDescriptor getImageDescriptor(String relativePath) {
        IPath path = IPath.fromOSString((String)"$nl$/icons/full/").append(relativePath);
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)path, null);
        if (url == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    private static String getString(ResourceBundle bundle, String key, String dfltValue) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME);
        }
        return this.resourceBundle;
    }

    private Composite createComposite(Composite parent) {
        return this.formToolkit.createComposite(parent);
    }

    private void updateEnablements() {
        if (this.saveAction != null) {
            this.saveAction.setEnabled(this.isDirty());
        }
        this.inplaceAction.setChecked(this.wordArea.isInplace());
        this.inplaceAction.setEnabled(this.wordArea.isOpen());
    }

    private void createDocArea(PageBook book) {
        this.docArea = this.createComposite((Composite)book);
        this.docArea.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.wordArea = new WordComparison(this.docArea);
        IWorkbenchPart workbenchPart = this.getConfiguration().getContainer().getWorkbenchPart();
        if (workbenchPart != null) {
            this.wordArea.initializeWorkbenchMenus(workbenchPart.getSite().getWorkbenchWindow());
        }
        this.wordArea.getFrame().setLayoutData((Object)new GridData(4, 4, true, true));
        this.wordArea.getFrame().setBackground(this.formToolkit.getColors().getBackground());
        this.updateDirtyFlag();
    }

    private void createTextArea(PageBook book) {
        this.textArea = this.createComposite((Composite)book);
        this.textArea.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(10, 10, 10, 10).create());
        this.description = this.formToolkit.createLabel(this.textArea, this.getTextDescription(), 64);
        this.description.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDocument() {
        try {
            File result = this.getResultFile();
            this.wordArea.saveAsDocument(result.getAbsolutePath());
            IEditableContent saveTarget = this.getSaveTarget();
            if (saveTarget == null) {
                FileDialog dialog;
                String filename;
                if (MessageDialog.openQuestion((Shell)this.composite.getShell(), (String)"Save to File?", (String)"The compare editor is not saveable. Would you like to save your changes to another file?") && (filename = (dialog = new FileDialog(this.composite.getShell(), 8192)).open()) != null) {
                    this.wordArea.saveAsDocument(filename);
                }
            } else {
                File file = result;
                synchronized (file) {
                    if (result.exists()) {
                        saveTarget.setContent(this.asBytes(result));
                        this.resultFileTimestamp = result.lastModified();
                    }
                }
            }
            this.updateEnablements();
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.composite.getShell(), null, null, (IStatus)new Status(4, "org.eclipse.compare.win32", 0, e.getMessage(), (Throwable)e));
        }
        catch (SWTException e) {
            ErrorDialog.openError((Shell)this.composite.getShell(), null, null, (IStatus)new Status(4, "org.eclipse.compare.win32", 0, e.getMessage(), (Throwable)e));
        }
    }

    public void flush(IProgressMonitor monitor) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (WordMergeViewer.this.isReallyDirty()) {
                    WordMergeViewer.this.saveDocument();
                }
            }
        });
    }

    protected void toggleInplaceExternalState() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (WordMergeViewer.this.isReallyDirty()) {
                        try {
                            File result = WordMergeViewer.this.getResultFile();
                            WordMergeViewer.this.wordArea.saveAsDocument(result.getAbsolutePath());
                        }
                        catch (IOException e) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare.win32", 0, e.getMessage(), (Throwable)e));
                        }
                    }
                    WordMergeViewer.this.openComparison(!WordMergeViewer.this.wordArea.isInplace());
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)WordMergeViewer.this.composite.getShell(), null, null, (IStatus)e.getStatus());
                    Activator.log(e);
                }
            }
        });
    }

    private boolean isReallyDirty() {
        return this.isDirty() || this.wordArea.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openComparison(boolean inplace) throws CoreException {
        try {
            if (this.isOneSided()) {
                File file = this.getFileForSingleSide();
                if (file != null) {
                    try {
                        this.wordArea.openDocument(file.getAbsolutePath(), inplace);
                    }
                    catch (SWTException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.compare.win32", NLS.bind((String)CompareWin32Messages.WordComparison_16, (Object)file.getAbsolutePath()), (Throwable)e));
                    }
                }
            } else {
                File left = this.getFileForLeft();
                File right = this.getFileForRight();
                if (left != null && right != null) {
                    File revised;
                    File base;
                    File result = this.getResultFile();
                    int direction = this.getCompareInput().getKind() & 0xC;
                    if (direction == 8) {
                        base = left;
                        revised = right;
                    } else {
                        base = right;
                        revised = left;
                    }
                    File file = result;
                    synchronized (file) {
                        if (!result.exists()) {
                            this.wordArea.createWorkingCopy(base.getAbsolutePath(), revised.getAbsolutePath(), result.getAbsolutePath());
                            this.resultFileTimestamp = result.lastModified();
                            this.description.setText(this.getTextDescription());
                        }
                        try {
                            this.wordArea.openDocument(result.getAbsolutePath(), inplace);
                        }
                        catch (SWTException e) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare.win32", NLS.bind((String)CompareWin32Messages.WordComparison_16, (Object)result.getAbsolutePath()), (Throwable)e));
                        }
                    }
                }
            }
            if (this.wordArea.isInplace()) {
                this.composite.showPage((Control)this.docArea);
            } else {
                this.composite.showPage((Control)this.textArea);
            }
        }
        catch (SWTException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare.win32", 0, e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare.win32", 0, e.getMessage(), (Throwable)e));
        }
        this.updateEnablements();
    }

    private String getTextDescription() {
        if (this.saveAction != null && this.hasResultFile()) {
            IEditableContent saveTarget = this.getSaveTarget();
            String name = CompareWin32Messages.WordMergeViewer_3;
            if (saveTarget instanceof ITypedElement) {
                ITypedElement te = (ITypedElement)saveTarget;
                name = te.getName();
            }
            try {
                return NLS.bind((String)CompareWin32Messages.WordMergeViewer_4, (Object)this.getResultFile().getName(), (Object)name);
            }
            catch (IOException iOException) {}
        }
        return CompareWin32Messages.WordMergeViewer_5;
    }

    public Control getControl() {
        return this.composite;
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        try {
            this.openComparison(true);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.composite.getShell(), null, null, (IStatus)e.getStatus());
            Activator.log(e);
        }
    }

    private void updateDirtyFlag() {
        Runnable dirtyFlagUpdater = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (WordMergeViewer.this.wordArea.getFrame().isDisposed()) {
                    return;
                }
                boolean dirty = WordMergeViewer.this.wordArea.isDirty();
                if (WordMergeViewer.this.hasResultFile()) {
                    try {
                        File resultFile;
                        File file = resultFile = WordMergeViewer.this.getResultFile();
                        synchronized (file) {
                            long lastModified;
                            if (resultFile.exists() && (lastModified = resultFile.lastModified()) != WordMergeViewer.this.resultFileTimestamp) {
                                dirty = true;
                            }
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (WordMergeViewer.this.isDirty() != dirty) {
                    WordMergeViewer.this.setDirty(dirty);
                }
                WordMergeViewer.this.composite.getDisplay().timerExec(1000, (Runnable)this);
            }
        };
        dirtyFlagUpdater.run();
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.updateEnablements();
            this.firePropertyChange("DIRTY_STATE", !this.isDirty, this.isDirty);
        }
    }

    private void firePropertyChange(String property, Object oldValue, Object newValue) {
        Object[] allListeners = this.listeners.getListeners();
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
        Object[] objectArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object allListener = objectArray[n2];
            final IPropertyChangeListener listener = (IPropertyChangeListener)allListener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.propertyChange(event);
                }
            });
            ++n2;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void handleDispose() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                WordMergeViewer.this.wordArea.dispose();
                WordMergeViewer.this.formToolkit.dispose();
                WordMergeViewer.this.reset();
            }
        });
    }

    @Override
    protected void reset() {
        if (this.wordArea.isOpen()) {
            this.wordArea.close();
        }
        super.reset();
    }
}

