/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs;

import java.util.Iterator;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.IClassContributionProvider;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ClassContributionCollector;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class FindContributionDialog
extends TitleAreaDialog {
    private IProject project;
    private Image javaClassImage;
    private TableViewer viewer;
    private Messages Messages;
    private String bundleclassUri;
    private IEclipseContext context;
    private String packageFilter;
    private String bundleFilter;
    private Bundle bundle;
    private String mode;
    private Image titleImage;
    private String platformUri;

    public FindContributionDialog(IEclipseContext context) {
        super((Shell)context.get(Shell.class));
        this.context = context;
        this.project = (IProject)context.get(IProject.class);
        this.Messages = (Messages)context.get(Messages.class);
        this.packageFilter = (String)context.get("package");
        this.bundleFilter = (String)context.get("bundle");
        this.bundle = (Bundle)context.get(Bundle.class);
        this.mode = (String)context.get("mode");
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.Messages.ContributionClassDialog_ShellTitle);
        if (!("show-bundles".equals(this.mode) || "show-packages".equals(this.mode) || "show-icons".equals(this.mode))) {
            this.titleImage = new Image((Device)comp.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/wizban/newclass_wiz.png"));
            this.setTitleImage(this.titleImage);
        }
        this.getShell().addDisposeListener(e -> {
            this.javaClassImage.dispose();
            if (this.titleImage != null) {
                this.titleImage.dispose();
            }
        });
        this.javaClassImage = new Image((Device)this.getShell().getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/obj16/class_obj.png"));
        Composite container = new Composite(comp, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText(this.Messages.ContributionClassDialog_Label_Classname);
        final Text t = new Text(container, 2688);
        t.setLayoutData((Object)new GridData(768));
        t.setMessage(this.Messages.ContributionClassDialog_FilterText_Message);
        new Label(container, 0);
        this.viewer = new TableViewer(container, 67584);
        GridData gd = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                IClassContributionProvider.ContributionData data = (IClassContributionProvider.ContributionData)cell.getElement();
                StyledString styledString = new StyledString();
                if ("show-bundles".equals(FindContributionDialog.this.mode)) {
                    styledString.append(data.bundleName, StyledString.DECORATIONS_STYLER);
                } else if ("show-packages".equals(FindContributionDialog.this.mode)) {
                    int dot = data.className.lastIndexOf(".");
                    String packageName = dot >= 0 ? data.className.substring(0, dot) : "";
                    styledString.append(packageName, StyledString.DECORATIONS_STYLER);
                } else if ("show-icons".equals(FindContributionDialog.this.mode)) {
                    styledString.append(data.iconPath, null);
                    if (data.bundleName != null) {
                        styledString.append(" - " + data.bundleName, StyledString.DECORATIONS_STYLER);
                    }
                    if (data.sourceType != null) {
                        styledString.append(" - ", StyledString.DECORATIONS_STYLER);
                        styledString.append(data.sourceType, StyledString.COUNTER_STYLER);
                    }
                    if (data.iconPath == null) {
                        cell.setImage(FindContributionDialog.this.javaClassImage);
                    }
                } else {
                    styledString.append(data.className, null);
                    if (data.bundleName != null) {
                        styledString.append(" - " + data.bundleName, StyledString.DECORATIONS_STYLER);
                    }
                    if (data.sourceType != null) {
                        styledString.append(" - ", StyledString.DECORATIONS_STYLER);
                        styledString.append(data.sourceType, StyledString.COUNTER_STYLER);
                    }
                    if (data.iconPath == null) {
                        cell.setImage(FindContributionDialog.this.javaClassImage);
                    }
                }
                cell.setText(styledString.getString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
        });
        this.viewer.addDoubleClickListener(event -> this.okPressed());
        final WritableList list = new WritableList();
        this.viewer.setInput((Object)list);
        final ClassContributionCollector collector = this.getCollector();
        t.addModifyListener(new ModifyListener(){
            private ContributionResultHandlerImpl currentResultHandler;

            public void modifyText(ModifyEvent e) {
                if (this.currentResultHandler != null) {
                    this.currentResultHandler.cancled = true;
                }
                list.clear();
                this.currentResultHandler = new ContributionResultHandlerImpl((IObservableList<IClassContributionProvider.ContributionData>)list);
                IClassContributionProvider.Filter filter = new IClassContributionProvider.Filter(FindContributionDialog.this.project, t.getText());
                collector.findContributions(filter, this.currentResultHandler);
                t.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.keyCode == 0x1000002 && (this).FindContributionDialog.this.viewer.getTable().getItemCount() > 0) {
                            (this).FindContributionDialog.this.viewer.getTable().setFocus();
                            (this).FindContributionDialog.this.viewer.getTable().select(0);
                        }
                    }
                });
                FindContributionDialog.this.viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        super.keyPressed(e);
                        if (e.keyCode == 0x1000001 && (this).FindContributionDialog.this.viewer.getTable().getSelectionIndex() == 0) {
                            t.setFocus();
                        }
                    }
                });
            }
        });
        this.viewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IClassContributionProvider.ContributionData cd = (IClassContributionProvider.ContributionData)element;
                if ("show-bundles".equals(FindContributionDialog.this.mode)) {
                    boolean found = false;
                    for (IClassContributionProvider.ContributionData cd2 : list) {
                        if (cd2.bundleName != null && !cd2.bundleName.equals(cd.bundleName)) continue;
                        if (!found) {
                            found = true;
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                if ("show-packages".equals(FindContributionDialog.this.mode)) {
                    if (FindContributionDialog.this.bundleFilter != null && !FindContributionDialog.this.bundleFilter.isEmpty() && !FindContributionDialog.this.bundleFilter.equals(cd.bundleName)) {
                        return false;
                    }
                    int last = cd.className.lastIndexOf(".");
                    String packageName = last >= 0 ? cd.className.substring(0, last) : "";
                    boolean found = false;
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        boolean matches = false;
                        IClassContributionProvider.ContributionData cd2 = (IClassContributionProvider.ContributionData)it.next();
                        if (packageName.isEmpty() && !cd2.className.contains(".")) {
                            matches = true;
                        } else if (cd2.className.startsWith(packageName + ".")) {
                            matches = true;
                        }
                        if (!matches) continue;
                        if (!found) {
                            found = true;
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                if ("show-icons".equals(FindContributionDialog.this.mode)) {
                    if (cd.iconPath == null) {
                        return false;
                    }
                    if (FindContributionDialog.this.bundleFilter != null && !FindContributionDialog.this.bundleFilter.isEmpty() && !FindContributionDialog.this.bundleFilter.equals(cd.bundleName)) {
                        return false;
                    }
                    return FindContributionDialog.this.packageFilter == null || FindContributionDialog.this.packageFilter.isEmpty() || cd.className.startsWith(FindContributionDialog.this.packageFilter + ".");
                }
                if (FindContributionDialog.this.bundleFilter != null && !FindContributionDialog.this.bundleFilter.isEmpty() && !FindContributionDialog.this.bundleFilter.equals(cd.bundleName)) {
                    return false;
                }
                return FindContributionDialog.this.packageFilter == null || FindContributionDialog.this.packageFilter.isEmpty() || cd.className.startsWith(FindContributionDialog.this.packageFilter + ".");
            }
        }});
        StringBuilder sbFind = new StringBuilder();
        if ("show-bundles".equals(this.mode)) {
            this.setTitle(org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_findBundle);
            sbFind.append(org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_findBundle);
        } else if ("show-packages".equals(this.mode)) {
            this.setTitle(org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_findPackage);
            sbFind.append(org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_findPackage);
            if (E.notEmpty(this.bundleFilter)) {
                sbFind.append(" " + org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_inBundle + " " + this.bundleFilter);
            }
        } else if ("show-icons".equals(this.mode)) {
            this.setTitle(org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_findIcon);
            sbFind.append(org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_findIcon);
            if (E.notEmpty(this.bundleFilter)) {
                sbFind.append(" " + org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_inBundle + " " + this.bundleFilter);
            }
            if (E.notEmpty(this.packageFilter)) {
                sbFind.append(" " + org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_inPackage + " " + this.packageFilter);
            }
        } else {
            this.setTitle(org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_findClass);
            sbFind.append(org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_findClass);
            if (E.notEmpty(this.bundleFilter)) {
                sbFind.append(" " + org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_inBundle + " " + this.bundleFilter);
            }
            if (E.notEmpty(this.packageFilter)) {
                sbFind.append(" " + org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages.FindContributionDialog_inPackage + " " + this.packageFilter);
            }
        }
        this.setMessage(sbFind.toString());
        if (list.size() <= 30) {
            t.notifyListeners(24, null);
        }
        return comp;
    }

    protected void okPressed() {
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        if (!s.isEmpty()) {
            IClassContributionProvider.ContributionData cd = (IClassContributionProvider.ContributionData)s.getFirstElement();
            String uri = "bundleclass://" + cd.bundleName + "/" + cd.className;
            this.platformUri = "platform:/plugin/" + cd.bundleName + "/" + cd.className;
            this.setBundleclassUri(uri);
            super.okPressed();
        } else {
            super.cancelPressed();
        }
    }

    private ClassContributionCollector getCollector() {
        if (this.bundle == null) {
            return null;
        }
        BundleContext context = this.bundle.getBundleContext();
        ServiceReference ref = context.getServiceReference(ClassContributionCollector.class.getName());
        if (ref != null) {
            return (ClassContributionCollector)context.getService(ref);
        }
        return null;
    }

    public String getBundleclassUri() {
        return this.bundleclassUri;
    }

    public String getPlatformUri() {
        return this.platformUri;
    }

    public void setBundleclassUri(String bundleclass) {
        this.bundleclassUri = bundleclass;
    }

    private static class ContributionResultHandlerImpl
    implements IClassContributionProvider.ContributionResultHandler {
        private boolean cancled = false;
        private IObservableList<IClassContributionProvider.ContributionData> list;

        public ContributionResultHandlerImpl(IObservableList<IClassContributionProvider.ContributionData> list) {
            this.list = list;
        }

        @Override
        public void result(IClassContributionProvider.ContributionData data) {
            if (!this.cancled) {
                this.list.add((Object)data);
            }
        }

        @Override
        public void moreResults(int hint, IClassContributionProvider.Filter filter) {
        }
    }
}

