/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.BundleImageCache;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.ProjectFolderPickerDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PickProjectFolderPage
extends WizardPage {
    private TreeViewer viewer;
    private String value;
    private IEclipseContext context;
    private IPath path;
    private Label label2;
    private Label label3;
    private Label lblResourcePath;

    protected PickProjectFolderPage(IEclipseContext context) {
        super(Messages.PickProjectFolderPage_SelectProjectFolder, Messages.PickProjectFolderPage_SelectProjectFolder, null);
        this.context = context;
        this.setMessage(Messages.NonReferencedResourceDialog_selectProjectToReceiveCopy);
        Image image = ((BundleImageCache)context.get(BundleImageCache.class)).create("/icons/full/wizban/plugin_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(1, false));
        this.viewer = new TreeViewer(ret);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ProjectFolderPickerDialog.ProjectContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProjectFolderPickerDialog.ProjectLabelProvider());
        this.viewer.expandToLevel(2);
        this.viewer.addDoubleClickListener(event -> this.onChanged());
        this.viewer.addSelectionChangedListener(event -> this.onChanged());
        Composite compPath = new Composite(ret, 0);
        compPath.setLayoutData((Object)new GridData(4, 4, true, true));
        compPath.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(compPath, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(Messages.ProjectFolderPickerDialog_sourceResourceName);
        this.label2 = new Label(compPath, 0);
        this.label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.label3 = new Label(compPath, 0);
        this.label3.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.lblResourcePath = new Label(compPath, 0);
        this.lblResourcePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        compPath.setVisible(false);
        String message = Messages.ProjectFolderPickerDialog_6;
        this.getShell().setText(message);
        this.setTitle(message);
        this.setMessage(message);
        this.setControl((Control)ret);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IProject project = (IProject)this.context.get("projectToCopyTo");
            this.viewer.setInput((Object)project);
            Object object = this.context.get("folderToCopyTo.obj");
            if (object != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection(object));
            } else {
                this.viewer.setSelection((ISelection)new StructuredSelection());
            }
            this.setPageComplete(!this.viewer.getSelection().isEmpty());
            this.path = IPath.fromOSString((String)((String)this.context.get("srcPath")));
            this.label2.setText(this.path.lastSegment());
            this.label3.setText(Messages.ProjectFolderPickerDialog_sourceResourceDirectory);
            this.lblResourcePath.setText(this.path.removeLastSegments(1).toOSString());
        }
        super.setVisible(visible);
    }

    protected void onChanged() {
        Object selected = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (selected == null || selected instanceof String) {
            this.value = "";
        } else {
            IResource resource = (IResource)selected;
            this.value = resource.getFullPath().removeFirstSegments(1).toOSString();
        }
        this.context.set("folderToCopyTo", (Object)this.value);
        this.context.set("folderToCopyTo.obj", selected);
        this.setPageComplete(selected != null);
    }
}

