/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.util.NotAuthenticatedException;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.TopicManager;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.server.IAuthenticationProtocol;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalTopic;
import org.eclipse.emf.cdo.spi.server.InternalTopicManager;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.CredentialsUpdateOperation;
import org.eclipse.net4j.util.security.DiffieHellman;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IAuthenticator2;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.SecurityUtil;
import org.eclipse.net4j.util.security.UserManagerAuthenticator;

public class SessionManager
extends Container<ISession>
implements InternalSessionManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, SessionManager.class);
    private InternalRepository repository;
    private DiffieHellman.Server authenticationServer;
    private IAuthenticator authenticator;
    private IPermissionManager permissionManager;
    private final InternalTopicManager topicManager = new TopicManager(this);
    private final Map<Integer, InternalSession> sessions = new HashMap<Integer, InternalSession>();
    private final AtomicInteger lastSessionID = new AtomicInteger();
    private final Map<InternalSession, List<CDOProtocol.CommitNotificationInfo>> commitNotificationInfoQueues = new HashMap<InternalSession, List<CDOProtocol.CommitNotificationInfo>>();
    private final IListener sessionListener = new LifecycleEventAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDeactivated(ILifecycle lifecycle) {
            Map map = SessionManager.this.commitNotificationInfoQueues;
            synchronized (map) {
                SessionManager.this.commitNotificationInfoQueues.remove(lifecycle);
            }
        }
    };
    private InternalSession[] sessionsArray = new InternalSession[0];

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(InternalRepository repository) {
        this.checkInactive();
        this.repository = repository;
    }

    public ExecutorService getExecutorService() {
        return this.repository.getExecutorService();
    }

    @Override
    @Deprecated
    public IUserManager getUserManager() {
        if (this.authenticator instanceof UserManagerAuthenticator) {
            return ((UserManagerAuthenticator)this.authenticator).getUserManager();
        }
        return null;
    }

    @Override
    @Deprecated
    public void setUserManager(IUserManager userManager) {
        UserManagerAuthenticator userManagerAuthenticator = new UserManagerAuthenticator();
        userManagerAuthenticator.setUserManager(userManager);
        this.setAuthenticator((IAuthenticator)userManagerAuthenticator);
    }

    @Override
    public DiffieHellman.Server getAuthenticationServer() {
        return this.authenticationServer;
    }

    @Override
    public void setAuthenticationServer(DiffieHellman.Server authenticationServer) {
        this.authenticationServer = authenticationServer;
    }

    @Override
    public IAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void setAuthenticator(IAuthenticator authenticator) {
        this.authenticator = authenticator;
        if (this.isActive() && authenticator != null) {
            this.initAuthentication();
        }
    }

    @Override
    public IPermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Override
    public void setPermissionManager(IPermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public InternalTopicManager getTopicManager() {
        return this.topicManager;
    }

    @Override
    public InternalSession[] getSessions() {
        return this.sessionsArray;
    }

    private void buildSessionsArray() {
        this.sessionsArray = this.sessions.values().toArray(new InternalSession[this.sessions.size()]);
        Arrays.sort(this.sessionsArray, (s1, s2) -> {
            int sys2;
            int sys1 = "CDO_SYSTEM".equals(s1.getUserID()) ? 0 : 1;
            int result = Integer.compare(sys1, sys2 = "CDO_SYSTEM".equals(s2.getUserID()) ? 0 : 1);
            if (result == 0) {
                long t1 = s1.getOpeningTime();
                long t2 = s2.getOpeningTime();
                result = Long.compare(t1, t2);
            }
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalSession getSession(int sessionID) {
        this.checkActive();
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            return this.sessions.get(sessionID);
        }
    }

    public InternalSession[] getElements() {
        return this.getSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            return this.sessions.isEmpty();
        }
    }

    @Override
    public InternalSession openSession(ISessionProtocol sessionProtocol) {
        return this.openSession(sessionProtocol, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalSession openSession(ISessionProtocol sessionProtocol, int sessionID) {
        int id;
        if (sessionID == 0) {
            id = this.lastSessionID.incrementAndGet();
            if (TRACER.isEnabled()) {
                TRACER.trace("Opening session " + id);
            }
        } else {
            id = sessionID;
            if (TRACER.isEnabled()) {
                TRACER.trace("Reopening session " + id);
            }
        }
        String userID = this.authenticateUser(sessionProtocol);
        InternalSession session = this.createSession(id, userID, sessionProtocol);
        LifecycleUtil.activate((Object)session);
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            this.repository.executeOutsideStartCommit(() -> {
                long openingTime = this.repository.getTimeStamp();
                session.setOpeningTime(openingTime);
                long firstUpdateTime = this.repository.getLastCommitTimeStamp();
                session.setFirstUpdateTime(firstUpdateTime);
                this.sessions.put(id, session);
                this.buildSessionsArray();
            });
        }
        this.sendRemoteSessionNotification(session, (byte)1);
        this.fireElementAddedEvent(session);
        return session;
    }

    protected InternalSession createSession(int id, String userID, ISessionProtocol protocol) {
        return new Session(this, protocol, id, userID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionClosed(InternalSession session) {
        InternalSession removedSession;
        int sessionID = session.getSessionID();
        HashSet<InternalSession> recipients = new HashSet<InternalSession>();
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            removedSession = this.sessions.remove(sessionID);
            if (removedSession != null) {
                this.buildSessionsArray();
                for (InternalSession remainingSession : this.sessions.values()) {
                    if (!remainingSession.isSubscribed()) continue;
                    recipients.add(remainingSession);
                }
                List<InternalTopic> affectedTopics = this.topicManager.sessionClosed(removedSession);
                for (InternalTopic affectedTopic : affectedTopics) {
                    InternalSession[] internalSessionArray = affectedTopic.getSessions();
                    int n = internalSessionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InternalSession affectedSession = internalSessionArray[n2];
                        recipients.add(affectedSession);
                        ++n2;
                    }
                }
            }
        }
        if (removedSession != null) {
            if (!recipients.isEmpty()) {
                this.sendRemoteSessionNotification(removedSession, recipients, null, (byte)2);
            }
            this.fireElementRemovedEvent(removedSession);
        }
    }

    @Override
    public void openedOnClientSide(InternalSession session) {
        this.processQueuedCommitNotifications(session);
    }

    @Override
    public void sendRepositoryTypeNotification(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            try {
                session.sendRepositoryTypeNotification(oldType, newType);
            }
            catch (Exception ex) {
                this.handleNotificationProblem(session, ex);
            }
            ++n2;
        }
    }

    @Override
    @Deprecated
    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        this.sendRepositoryStateNotification(oldState, newState, null);
    }

    @Override
    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState, CDOID rootResourceID) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            try {
                session.sendRepositoryStateNotification(oldState, newState, rootResourceID);
            }
            catch (Exception ex) {
                this.handleNotificationProblem(session, ex);
            }
            ++n2;
        }
    }

    @Override
    @Deprecated
    public void sendBranchNotification(InternalSession sender, InternalCDOBranch branch) {
        this.sendBranchNotification(sender, branch, CDOBranchChangedEvent.ChangeKind.CREATED);
    }

    @Override
    @Deprecated
    public void sendBranchNotification(InternalSession sender, InternalCDOBranch branch, CDOBranchChangedEvent.ChangeKind changeKind) {
        this.sendBranchNotification(sender, changeKind, new CDOBranch[]{branch});
    }

    @Override
    public void sendBranchNotification(InternalSession sender, CDOBranchChangedEvent.ChangeKind changeKind, CDOBranch ... branches) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender) {
                try {
                    session.sendBranchNotification(changeKind, branches);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(session, ex);
                }
            }
            ++n2;
        }
    }

    @Override
    public void sendTagNotification(InternalSession sender, int modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender) {
                try {
                    session.sendTagNotification(modCount, oldName, newName, branchPoint);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(session, ex);
                }
            }
            ++n2;
        }
    }

    @Override
    @Deprecated
    public void sendCommitNotification(InternalSession sender, CDOCommitInfo commitInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void sendCommitNotification(InternalSession sender, CDOCommitInfo commitInfo, boolean clearResourcePathCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendCommitNotification(CDOProtocol.CommitNotificationInfo info) {
        InternalSession[] sessions;
        CDOCommonSession sender = info.getSender();
        InternalSession[] internalSessionArray = sessions = this.getSessions();
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender || info.isModifiedByServer()) {
                if (session.isOpenOnClientSide()) {
                    this.processQueuedCommitNotifications(session);
                    this.doSendCommitNotification(session, info);
                } else {
                    this.queueCommitNotification(session, info);
                }
            }
            ++n2;
        }
    }

    private void doSendCommitNotification(InternalSession session, CDOProtocol.CommitNotificationInfo info) {
        try {
            session.sendCommitNotification(info);
        }
        catch (Exception ex) {
            this.handleNotificationProblem(session, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueCommitNotification(InternalSession session, CDOProtocol.CommitNotificationInfo info) {
        Map<InternalSession, List<CDOProtocol.CommitNotificationInfo>> map = this.commitNotificationInfoQueues;
        synchronized (map) {
            List<CDOProtocol.CommitNotificationInfo> queue = this.commitNotificationInfoQueues.get(session);
            if (queue == null) {
                queue = new ArrayList<CDOProtocol.CommitNotificationInfo>();
                this.commitNotificationInfoQueues.put(session, queue);
                session.addListener(this.sessionListener);
            }
            queue.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueuedCommitNotifications(InternalSession session) {
        List<CDOProtocol.CommitNotificationInfo> queue;
        Map<InternalSession, List<CDOProtocol.CommitNotificationInfo>> map = this.commitNotificationInfoQueues;
        synchronized (map) {
            queue = this.commitNotificationInfoQueues.remove(session);
        }
        if (queue != null && !session.isClosed()) {
            session.removeListener(this.sessionListener);
            for (CDOProtocol.CommitNotificationInfo queuedInfo : queue) {
                this.doSendCommitNotification(session, queuedInfo);
            }
        }
    }

    @Override
    public void sendLockNotification(InternalSession sender, CDOLockChangeInfo lockChangeInfo) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender && session.options().getLockNotificationMode() != CDOCommonSession.Options.LockNotificationMode.OFF) {
                try {
                    session.sendLockNotification(lockChangeInfo);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(session, ex);
                }
            }
            ++n2;
        }
    }

    @Override
    public void sendLockOwnerRemappedNotification(InternalSession sender, CDOBranch branch, CDOLockOwner oldOwner, CDOLockOwner newOwner) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender) {
                try {
                    session.sendLockOwnerRemappedNotification(branch, oldOwner, newOwner);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(session, ex);
                }
            }
            ++n2;
        }
    }

    @Override
    public void sendRemoteSessionNotification(InternalSession sender, byte opcode) {
        ArrayList<InternalSession> recipients = new ArrayList<InternalSession>();
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender && session.isSubscribed()) {
                recipients.add(session);
            }
            ++n2;
        }
        this.sendRemoteSessionNotification(sender, recipients, null, opcode);
    }

    @Override
    public void sendRemoteSessionNotification(InternalSession sender, Collection<InternalSession> recipients, InternalTopic topic, byte opcode) {
        if (recipients == null) {
            recipients = new ArrayList<InternalSession>();
            InternalSession[] internalSessionArray = topic.getSessions();
            int n = internalSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalSession session = internalSessionArray[n2];
                recipients.add(session);
                ++n2;
            }
        }
        try {
            for (InternalSession session : recipients) {
                if (session == sender) continue;
                try {
                    session.sendRemoteSessionNotification(sender, topic, opcode);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(session, ex);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.warn("A problem occured while notifying other sessions", (Throwable)ex);
        }
    }

    @Override
    public List<Integer> sendRemoteMessageNotification(InternalSession sender, CDORemoteSessionMessage message, InternalTopic topic) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        InternalSession[] internalSessionArray = topic.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession recipient = internalSessionArray[n2];
            try {
                if (recipient != null && recipient != sender) {
                    recipient.sendRemoteMessageNotification(sender, topic, message);
                    result.add(recipient.getSessionID());
                }
            }
            catch (Exception ex) {
                this.handleNotificationProblem(recipient, ex);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<Integer> sendRemoteMessageNotification(InternalSession sender, CDORemoteSessionMessage message, int[] recipients) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < recipients.length) {
            InternalSession recipient = this.getSession(recipients[i]);
            try {
                if (recipient != null && recipient.isSubscribed()) {
                    recipient.sendRemoteMessageNotification(sender, null, message);
                    result.add(recipient.getSessionID());
                }
            }
            catch (Exception ex) {
                this.handleNotificationProblem(recipient, ex);
            }
            ++i;
        }
        return result;
    }

    protected void handleNotificationProblem(InternalSession session, Throwable t) {
        if (session.isClosed()) {
            if (TRACER.isEnabled()) {
                TRACER.trace("A problem occured while notifying session " + session, t);
            }
        } else {
            OM.LOG.warn("A problem occured while notifying session " + session, t);
        }
    }

    @Override
    public String authenticateUser(IAuthenticationProtocol protocol) throws SecurityException {
        if (protocol == null) {
            return null;
        }
        if (this.authenticationServer == null || this.authenticator == null) {
            return null;
        }
        try {
            DiffieHellman.Server.Challenge challenge = this.authenticationServer.getChallenge();
            DiffieHellman.Client.Response response = protocol.sendAuthenticationChallenge(challenge);
            if (response == null) {
                throw this.notAuthenticated();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(this.authenticationServer.handleResponse(response));
            ExtendedDataInputStream stream = new ExtendedDataInputStream((InputStream)bais);
            String userID = stream.readString();
            char[] password = SecurityUtil.toCharArray((String)stream.readString());
            this.authenticator.authenticate(userID, password);
            return userID;
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SecurityException) {
                throw (SecurityException)cause;
            }
            throw new SecurityException(ex);
        }
    }

    @Override
    public void changeUserCredentials(IAuthenticationProtocol sessionProtocol, String userID) {
        this.changeUserCredentials(sessionProtocol, userID, CredentialsUpdateOperation.CHANGE_PASSWORD);
    }

    @Override
    public void resetUserCredentials(IAuthenticationProtocol sessionProtocol, String userID) {
        this.changeUserCredentials(sessionProtocol, userID, CredentialsUpdateOperation.RESET_PASSWORD);
    }

    protected void changeUserCredentials(IAuthenticationProtocol sessionProtocol, String userID, CredentialsUpdateOperation operation) {
        if (sessionProtocol == null) {
            return;
        }
        if (this.authenticationServer == null || this.authenticator == null) {
            return;
        }
        if (!(this.authenticator instanceof IAuthenticator2)) {
            throw new SecurityException("Current authenticator does not permit password updates");
        }
        try {
            DiffieHellman.Server.Challenge challenge = this.authenticationServer.getChallenge();
            DiffieHellman.Client.Response response = sessionProtocol.sendCredentialsChallenge(challenge, userID, operation);
            if (response == null) {
                throw this.notAuthenticated();
            }
            ByteArrayInputStream baos = new ByteArrayInputStream(this.authenticationServer.handleResponse(response));
            ExtendedDataInputStream stream = new ExtendedDataInputStream((InputStream)baos);
            if (operation == CredentialsUpdateOperation.RESET_PASSWORD) {
                String adminID = stream.readString();
                char[] adminPassword = SecurityUtil.toCharArray((String)stream.readString());
                if (!ObjectUtil.equals((Object)userID, (Object)stream.readString())) {
                    throw new SecurityException("Attempt to reset password of a different user than requested");
                }
                char[] newPassword = SecurityUtil.toCharArray((String)stream.readString());
                ((IAuthenticator2)this.authenticator).resetPassword(adminID, adminPassword, userID, newPassword);
            } else {
                userID = stream.readString();
                char[] password = SecurityUtil.toCharArray((String)stream.readString());
                char[] newPassword = SecurityUtil.toCharArray((String)stream.readString());
                ((IAuthenticator2)this.authenticator).updatePassword(userID, password, newPassword);
            }
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SecurityException) {
                throw (SecurityException)cause;
            }
            throw new SecurityException(ex);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.topicManager);
        this.initAuthentication();
    }

    protected void initAuthentication() {
        if (this.authenticator != null) {
            if (this.authenticationServer == null) {
                this.authenticationServer = new DiffieHellman.Server(this.repository.getUUID());
            }
            LifecycleUtil.activate((Object)this.authenticationServer);
            LifecycleUtil.activate((Object)this.authenticator);
        }
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.authenticator);
        LifecycleUtil.deactivate((Object)this.authenticationServer);
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            LifecycleUtil.deactivate((Object)session);
            ++n2;
        }
        LifecycleUtil.deactivate((Object)this.topicManager);
        super.doDeactivate();
    }

    private SecurityException notAuthenticated() {
        return new NotAuthenticatedException();
    }
}

