/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.Arrays;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.security.AuthenticatorFactory;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.SecurityUtil;
import org.eclipse.net4j.util.security.UserManagerFactory;

public abstract class RepositoryUserManager
extends Lifecycle
implements IUserManager,
IAuthenticator {
    private IManagedContainer container;
    private String repositoryName;

    protected RepositoryUserManager() {
    }

    private void setContainer(IManagedContainer container) {
        this.container = container;
    }

    private void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void addUser(String userID, char[] password) {
    }

    public void removeUser(String userID) {
    }

    public byte[] encrypt(String userID, byte[] data, String algorithmName, byte[] salt, int count) throws SecurityException {
        try {
            char[] password = this.getPassword(userID);
            return SecurityUtil.pbeEncrypt((byte[])data, (char[])password, (String)algorithmName, (byte[])salt, (int)count);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public void authenticate(String userID, char[] password) throws SecurityException {
        char[] userPassword = this.getPassword(userID);
        if (!Arrays.equals(password, userPassword)) {
            throw new SecurityException("Access denied");
        }
    }

    protected IRepository getRepository(IManagedContainer container, String repositoryName) {
        return CDOServerUtil.getRepository(container, repositoryName);
    }

    protected char[] getPassword(String userID) {
        IRepository repository = this.getRepository(this.container, this.repositoryName);
        if (repository == null) {
            throw new SecurityException("Repository not found: " + this.repositoryName);
        }
        char[] password = this.getPassword(repository, userID);
        if (password == null) {
            throw new SecurityException("No such user: " + userID);
        }
        return password;
    }

    protected abstract char[] getPassword(IRepository var1, String var2);

    public static void prepareContainer(IManagedContainer container, RepositoryUserManagerFactory factory) {
        container.registerFactory((IFactory)factory);
        container.addPostProcessor((IElementProcessor)new RepositoryInjector());
    }

    public static abstract class RepositoryAuthenticatorFactory
    extends AuthenticatorFactory {
        protected RepositoryAuthenticatorFactory(String type) {
            super(type);
        }

        public final Object create(String description) throws ProductCreationException {
            RepositoryUserManager userManager = this.doCreate(description);
            String repositoryName = this.getRepositoryName(description);
            userManager.setRepositoryName(repositoryName);
            return userManager;
        }

        protected String getRepositoryName(String description) {
            return description;
        }

        protected abstract RepositoryUserManager doCreate(String var1) throws ProductCreationException;
    }

    public static class RepositoryInjector
    implements IElementProcessor {
        public Object process(IManagedContainer container, String productGroup, String factoryType, String description, Object element) {
            if (element instanceof RepositoryUserManager) {
                RepositoryUserManager userManager = (RepositoryUserManager)((Object)element);
                userManager.setContainer(container);
            }
            return element;
        }
    }

    public static abstract class RepositoryUserManagerFactory
    extends UserManagerFactory {
        protected RepositoryUserManagerFactory(String type) {
            super(type);
        }

        public final Object create(String description) throws ProductCreationException {
            RepositoryUserManager userManager = this.doCreate(description);
            String repositoryName = this.getRepositoryName(description);
            userManager.setRepositoryName(repositoryName);
            return userManager;
        }

        protected String getRepositoryName(String description) {
            return description;
        }

        protected abstract RepositoryUserManager doCreate(String var1) throws ProductCreationException;
    }
}

